/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.item.chisel;

import com.cricketcraft.chisel.api.IChiselItem;
import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import com.cricketcraft.chisel.api.carving.IChiselMode;
import com.google.common.collect.Queues;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;
import team.chisel.Chisel;
import team.chisel.carving.Carving;
import team.chisel.utils.General;

public final class ChiselController {
    public static final ChiselController INSTANCE = new ChiselController();
    private long lastTickClick = 0L;
    private Queue<GuiOpen> openQueue = Queues.newArrayDeque();

    private ChiselController() {
    }

    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        ItemStack held = event.entityPlayer.func_71045_bC();
        int slot = event.entityPlayer.field_71071_by.field_70461_c;
        if (held == null || !(held.func_77973_b() instanceof IChiselItem)) {
            return;
        }
        IChiselItem chisel = (IChiselItem)held.func_77973_b();
        switch (event.action) {
            case LEFT_CLICK_BLOCK: {
                int n;
                boolean shifting = event.entityPlayer.func_70093_af();
                int x = event.x;
                int y = event.y;
                int z = event.z;
                Block block = event.world.func_147439_a(x, y, z);
                int metadata = event.world.func_72805_g(x, y, z);
                ICarvingGroup group = Carving.chisel.getGroup(block, metadata);
                if (group == null) {
                    return;
                }
                List<ICarvingVariation> list = group.getVariations();
                block4: for (ItemStack stack : OreDictionary.getOres((String)group.getOreName())) {
                    ICarvingVariation v = General.getVariation(stack);
                    for (ICarvingVariation iCarvingVariation : list) {
                        if (iCarvingVariation.getBlock() != v.getBlock() || iCarvingVariation.getBlockMeta() != v.getBlockMeta()) continue;
                        continue block4;
                    }
                    list.add(General.getVariation(stack));
                }
                ICarvingVariation[] variations = list.toArray(new ICarvingVariation[0]);
                if (!chisel.canChiselBlock(event.world, event.entityPlayer, x, y, z, block, metadata)) break;
                ItemStack target = General.getChiselTarget(held);
                IChiselMode mode = General.getChiselMode(held);
                ForgeDirection sideHit = ForgeDirection.VALID_DIRECTIONS[event.face];
                if (target != null) {
                    for (ICarvingVariation v : variations) {
                        if (v.getBlock() != Block.func_149634_a((Item)target.func_77973_b()) || v.getBlockMeta() != target.func_77960_j()) continue;
                        mode.chiselAll(event.entityPlayer, event.world, x, y, z, sideHit, v);
                    }
                    break;
                }
                boolean bl = false;
                for (int i = 0; i < variations.length; ++i) {
                    ICarvingVariation v = variations[i];
                    if (v.getBlock() != block || v.getBlockMeta() != metadata) continue;
                    n = i + variations.length + (shifting ? -1 : 1);
                    n %= variations.length;
                }
                ICarvingVariation newVar = variations[n];
                mode.chiselAll(event.entityPlayer, event.world, x, y, z, sideHit, newVar);
                event.entityPlayer.field_71071_by.field_70461_c = slot;
                break;
            }
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                if (event.world.func_82737_E() == this.lastTickClick) break;
                this.lastTickClick = event.world.func_82737_E();
                if (event.world.field_72995_K || !chisel.canOpenGui(event.world, event.entityPlayer, held)) break;
                this.openQueue.add(new GuiOpen(event.entityPlayer, held));
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack stack = event.getPlayer().func_71045_bC();
        if (event.getPlayer().field_71075_bZ.field_75098_d && stack != null && stack.func_77973_b() instanceof IChiselItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void openQueuedGui(TickEvent.ServerTickEvent event) {
        GuiOpen open;
        if (event.phase == TickEvent.Phase.END && (open = this.openQueue.poll()) != null) {
            open.run();
        }
    }

    private static class GuiOpen
    implements Runnable {
        private EntityPlayer player;
        private ItemStack stack;

        public GuiOpen(EntityPlayer player, ItemStack stack) {
            this.player = player;
            this.stack = stack;
        }

        @Override
        public void run() {
            ItemStack current = this.player.func_71045_bC();
            if (current != null && ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)current) && ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)current)) {
                this.player.openGui((Object)Chisel.instance, 0, this.player.field_70170_p, 0, 0, 0);
            }
        }
    }
}

