/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio;

public class CSExceptions
extends RuntimeException {
    public CSExceptions() {
    }

    public CSExceptions(String message) {
        super("CraftStudio Library Exception: " + message);
    }

    public CSExceptions(Throwable cause) {
        super(cause);
    }

    public CSExceptions(String message, Throwable cause) {
        super("CraftStudio Library Exception: " + message, cause);
    }

    public CSExceptions(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super("CraftStudio Library Exception: " + message, cause, enableSuppression, writableStackTrace);
    }

    public static class DuplicateProjectException
    extends CSExceptions {
        public DuplicateProjectException(Object project) {
            super(String.format("CraftStudioLib is unable to add CSProject: %s; There is a duplicate project with the same ID", project.toString()));
        }
    }

    public static class ResourcesNotFoundException
    extends CSExceptions {
        public ResourcesNotFoundException(Object project) {
            super(String.format("CraftStudioLib is unable to locate any resources for CSProject: %s", project.toString()));
        }
    }

    public static class UnsupportedVersionException
    extends CSExceptions {
        public UnsupportedVersionException(Object version) {
            super(String.format("This version of CraftStudioLib is unable to load the passed in file version(%s)", version.toString()));
        }
    }

    public static class TypeMismatchException
    extends CSExceptions {
        public TypeMismatchException(Object expected, Object received) {
            super(String.format("The file type being loaded(%s) does not match the expcted type(%s).", received.toString(), expected.toString()));
        }
    }

    public static class NoCSProjectException
    extends CSExceptions {
        public NoCSProjectException() {
            super("Programming error: CSPacks must be added to a CSProject to be used.");
        }
    }
}

