/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.helper;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakSet<E>
extends AbstractSet<E>
implements Set<E> {
    private transient WeakHashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public WeakSet() {
        this.map = new WeakHashMap();
    }

    public WeakSet(Collection<? extends E> c) {
        this.map = new WeakHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public WeakSet(int initialCapacity, float loadFactor) {
        this.map = new WeakHashMap(initialCapacity, loadFactor);
    }

    public WeakSet(int initialCapacity) {
        this.map = new WeakHashMap(initialCapacity);
    }

    WeakSet(int initialCapacity, float loadFactor, boolean dummy) {
        this.map = new WeakHashMap(initialCapacity, loadFactor);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

