/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.ganysMods;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v1.RequirementType;
import com.InfinityRaider.AgriCraft.api.v3.ICrop;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementHandler;
import com.InfinityRaider.AgriCraft.renderers.PlantRenderer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CropPlantGanysNether
extends CropPlant {
    private final Item seed;
    private final Block plant;
    private final ItemStack fruit;
    private final int renderMethod;

    protected CropPlantGanysNether(Item seed, Block plant, ItemStack fruit, int renderMethod) {
        this.seed = seed;
        this.plant = plant;
        this.fruit = fruit;
        this.renderMethod = renderMethod;
    }

    @Override
    public int tier() {
        return 3;
    }

    @Override
    public ItemStack getSeed() {
        return new ItemStack(this.seed);
    }

    @Override
    public Block getBlock() {
        return this.plant;
    }

    @Override
    public ArrayList<ItemStack> getAllFruits() {
        ArrayList<ItemStack> fruits = new ArrayList<ItemStack>();
        fruits.add(this.fruit.func_77946_l());
        return fruits;
    }

    @Override
    public ItemStack getRandomFruit(Random rand) {
        return this.fruit.func_77946_l();
    }

    @Override
    public ArrayList<ItemStack> getFruitsOnHarvest(int gain, Random rand) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int amount = (int)Math.ceil(((double)gain + 0.0) / 3.0); amount > 0; --amount) {
            list.add(this.getRandomFruit(rand));
        }
        return list;
    }

    @Override
    public boolean canBonemeal() {
        return true;
    }

    @Override
    protected IGrowthRequirement initGrowthRequirement() {
        return GrowthRequirementHandler.getNewBuilder().soil(new BlockWithMeta((Block)Block.field_149771_c.func_82594_a("ganysnether:tilledNetherrack"))).requiredBlock(new BlockWithMeta(Blocks.field_150353_l), RequirementType.NEARBY, false).build();
    }

    @Override
    public boolean onAllowedGrowthTick(World world, int x, int y, int z, int oldGrowthStage, ICrop crop) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getHeight(int meta) {
        return 0.8125f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getPlantIcon(int growthStage) {
        return this.getBlock().func_149691_a(0, growthStage);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsFlower() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInformation() {
        String name = this.seed.func_77658_a();
        String[] split = name.split("\\.");
        return "agricraft_journal.ganysNether_" + split[split.length - 1];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPlantInCrop(IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        switch (this.renderMethod) {
            case 0: {
                super.renderPlantInCrop(world, x, y, z, renderer);
                break;
            }
            case 1: {
                renderer.func_147784_q(this.plant, x, y, z);
                break;
            }
            case 2: {
                int meta = world.func_72805_g(x, y, z);
                PlantRenderer.renderStemPlant(x, y, z, renderer, this.getPlantIcon(meta), meta, this.getBlock(), Blocks.field_150465_bP, meta >= 7);
            }
        }
    }
}

