/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.mutation.statcalculator;

import com.InfinityRaider.AgriCraft.farming.mutation.statcalculator.StatCalculatorBase;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;

public class StatCalculatorHardcore
extends StatCalculatorBase {
    @Override
    protected int calculateStats(int input, int neighbours, int divisor) {
        if (neighbours == 1 && ConfigurationHandler.singleSpreadsIncrement) {
            neighbours = 2;
        }
        int newStat = this.getAction(neighbours).apply(input) / divisor;
        return Math.max(1, Math.min(newStat, ConfigurationHandler.cropStatCap));
    }

    private Action getAction(int count) {
        Action[] actions;
        int totalWeight = 0;
        for (Action action : actions = Action.values()) {
            totalWeight += action.getWeight(count);
        }
        int randomIndex = -1;
        double random = Math.random() * (double)totalWeight;
        for (int i = 0; i < actions.length; ++i) {
            if (!((random -= (double)actions[i].getWeight(count)) <= 0.0)) continue;
            randomIndex = i;
            break;
        }
        return actions[randomIndex];
    }

    private static enum Action {
        DECREMENT(-1, new int[]{3, 2, 1, 1}),
        NOTHING(0, new int[]{1, 1, 2, 1}),
        INCREMENT(1, new int[]{0, 1, 1, 2});

        private final int incr;
        private final int[] weights;

        private Action(int incr, int[] weights) {
            this.incr = incr;
            this.weights = weights;
        }

        public int getWeight(int count) {
            --count;
            count = Math.max(Math.min(count, this.weights.length - 1), 0);
            return this.weights[count];
        }

        public int apply(int input) {
            return input + this.incr;
        }
    }
}

