/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.init;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.RenderMethod;
import com.InfinityRaider.AgriCraft.api.v1.RequirementType;
import com.InfinityRaider.AgriCraft.blocks.BlockModPlant;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.items.ItemModSeed;
import com.InfinityRaider.AgriCraft.reference.Data;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.OreDictHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ResourceCrops {
    public static ArrayList<BlockModPlant> vanillaCrops;
    public static ArrayList<ItemModSeed> vanillaSeeds;
    public static ArrayList<BlockModPlant> modCrops;
    public static ArrayList<ItemModSeed> modSeeds;

    public static void init() {
        if (ConfigurationHandler.resourcePlants) {
            OreDictHelper.getRegisteredOres();
            ResourceCrops.initVanillaResources();
            ResourceCrops.initModdedResources();
            LogHelper.debug("Resource crops registered");
        }
    }

    private static void initVanillaResources() {
        Object[][] vanillaResources;
        vanillaCrops = new ArrayList();
        vanillaSeeds = new ArrayList();
        for (Object[] data : vanillaResources = new Object[][]{{"Aurigold", new ItemStack(Items.field_151074_bl), RequirementType.BELOW, new BlockWithMeta(Blocks.field_150352_o, 0), 4, RenderMethod.HASHTAG}, {"Ferranium", new ItemStack(OreDictHelper.getNuggetForName("Iron"), 1, OreDictHelper.getNuggetMetaForName("Iron")), RequirementType.BELOW, new BlockWithMeta(Blocks.field_150366_p, 0), 4, RenderMethod.HASHTAG}, {"Diamahlia", new ItemStack(OreDictHelper.getNuggetForName("Diamond"), 1, OreDictHelper.getNuggetMetaForName("Diamond")), RequirementType.BELOW, new BlockWithMeta(Blocks.field_150482_ag, 0), 5, RenderMethod.HASHTAG}, {"Lapender", new ItemStack(Items.field_151100_aR, 1, 4), RequirementType.BELOW, new BlockWithMeta(Blocks.field_150369_x, 4), 3, RenderMethod.HASHTAG}, {"Emeryllis", new ItemStack(OreDictHelper.getNuggetForName("Emerald"), 1, OreDictHelper.getNuggetMetaForName("Emerald")), RequirementType.BELOW, new BlockWithMeta(Blocks.field_150412_bA, 0), 5, RenderMethod.HASHTAG}, {"Redstodendron", new ItemStack(Items.field_151137_ax), RequirementType.BELOW, new BlockWithMeta(Blocks.field_150450_ax, 0), 3, RenderMethod.HASHTAG}, {"NitorWart", new ItemStack(Items.field_151114_aO), new BlockWithMeta(Blocks.field_150425_aM), RequirementType.BELOW, new BlockWithMeta(Blocks.field_150426_aN, 0), 4, RenderMethod.HASHTAG}, {"Quartzanthemum", new ItemStack(OreDictHelper.getNuggetForName("Quartz")), new BlockWithMeta(Blocks.field_150425_aM), RequirementType.BELOW, new BlockWithMeta(Blocks.field_150449_bY, 0), 4, RenderMethod.HASHTAG}}) {
            try {
                BlockModPlant plant = new BlockModPlant(data);
                vanillaCrops.add(plant);
                vanillaSeeds.add(plant.getSeed());
            }
            catch (Exception e) {
                LogHelper.printStackTrace(e);
            }
        }
    }

    public static void initModdedResources() {
        modCrops = new ArrayList();
        modSeeds = new ArrayList();
        for (String[] data : Data.modResources) {
            Block base = OreDictHelper.getOreBlockForName(data[0]);
            if (base == null) continue;
            Object[] args = new Object[]{data[1], new ItemStack(OreDictHelper.getNuggetForName(data[0]), 1, OreDictHelper.getNuggetMetaForName(data[0])), RequirementType.BELOW, new BlockWithMeta(OreDictHelper.getOreBlockForName(data[0]), OreDictHelper.getOreMetaForName(data[0])), 4, RenderMethod.HASHTAG};
            try {
                BlockModPlant plant = new BlockModPlant(args);
                modCrops.add(plant);
                modSeeds.add(plant.getSeed());
            }
            catch (Exception e) {
                LogHelper.printStackTrace(e);
            }
        }
    }
}

