/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import cofh.lib.util.position.Area;
import cofh.lib.util.position.BlockPosition;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.core.HarvestMode;
import powercrystals.minefactoryreloaded.core.IHarvestManager;

public class FruitHarvestManager
implements IHarvestManager {
    private List<BlockPosition> _treeBlocks;
    private int _currentBlock;
    private boolean _isDone;
    private HarvestMode _harvestMode;
    private Area _area;

    public FruitHarvestManager(World world, Area area, HarvestMode harvestMode) {
        this.reset(world, area, harvestMode, null);
    }

    @Override
    public BlockPosition getNextBlock() {
        return this._treeBlocks.get(this._currentBlock);
    }

    @Override
    public void moveNext() {
        ++this._currentBlock;
        if (this._currentBlock >= this._treeBlocks.size()) {
            this._isDone = true;
        }
    }

    @Override
    public void reset(World world, Area area, HarvestMode harvestMode, Map<String, Boolean> map) {
        this._harvestMode = harvestMode;
        this._area = area;
        this._currentBlock = 0;
        this._isDone = false;
        this._treeBlocks = this._harvestMode.isInverted ? this._area.getPositionsTopFirst() : this._area.getPositionsBottomFirst();
    }

    @Override
    public void setWorld(World world) {
    }

    @Override
    public boolean getIsDone() {
        return this._isDone;
    }

    @Override
    public BlockPosition getOrigin() {
        return this._area.getOrigin();
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.func_74757_a("done", this._isDone);
        nBTTagCompound2.func_74768_a("curPos", this._currentBlock);
        nBTTagCompound2.func_74768_a("mode", this._harvestMode.ordinal());
        BlockPosition blockPosition = this.getOrigin();
        nBTTagCompound2.func_74783_a("area", new int[]{blockPosition.x - this._area.xMin, blockPosition.y - this._area.yMin, this._area.yMax - blockPosition.y});
        nBTTagCompound2.func_74783_a("origin", new int[]{blockPosition.x, blockPosition.y, blockPosition.z});
        nBTTagCompound.func_74782_a("harvestManager", (NBTBase)nBTTagCompound2);
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        int[] nArray;
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("harvestManager");
        this._isDone = nBTTagCompound2.func_74767_n("done");
        this._currentBlock = nBTTagCompound2.func_74762_e("curPos");
        this._harvestMode = HarvestMode.values()[nBTTagCompound2.func_74762_e("mode")];
        int[] nArray2 = nBTTagCompound2.func_74759_k("area");
        if (nArray2 == null | (nArray = nBTTagCompound2.func_74759_k("origin")) == null || nArray.length < 3 | nArray2.length < 3) {
            this._isDone = true;
            return;
        }
        this._area = new Area(new BlockPosition(nArray[0], nArray[1], nArray[2]), nArray2[0], nArray2[1], nArray2[2]);
    }

    @Override
    public void free() {
    }
}

