/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.gui.control;

import cofh.core.CoFHProps;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButtonManaged;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.client.GuiRedNetLogic;
import powercrystals.minefactoryreloaded.gui.control.LogicButtonType;

public class ButtonLogicPinSelect
extends ElementButtonManaged {
    private static GuiColor[] _pinColors = new GuiColor[]{new GuiColor(223, 223, 223), new GuiColor(219, 125, 63), new GuiColor(180, 81, 188), new GuiColor(107, 138, 207), new GuiColor(177, 166, 39), new GuiColor(66, 174, 57), new GuiColor(208, 132, 153), new GuiColor(65, 65, 65), new GuiColor(155, 155, 155), new GuiColor(47, 111, 137), new GuiColor(127, 62, 182), new GuiColor(46, 57, 141), new GuiColor(79, 50, 31), new GuiColor(53, 71, 28), new GuiColor(151, 52, 49), new GuiColor(22, 22, 26)};
    private static String[] _pinColorNames = new String[]{"WHIT", "ORNG", "MGTA", "L_BL", "YLLW", "LIME", "PINK", "GRAY", "SILV", "CYAN", "PURP", "BLUE", "BRWN", "GRN", "RED", "BLK"};
    private int _pinIndex;
    private LogicButtonType _buttonType;
    private GuiRedNetLogic _containerScreen;
    private int _pin;
    private int _buffer;

    public ButtonLogicPinSelect(GuiRedNetLogic guiRedNetLogic, int n, int n2, int n3, LogicButtonType logicButtonType) {
        super((GuiBase)guiRedNetLogic, n, n2, 30, 14, "");
        this._pinIndex = n3;
        this._buttonType = logicButtonType;
        this._containerScreen = guiRedNetLogic;
        this.setVisible(false);
    }

    public int getBuffer() {
        return this._buffer;
    }

    public void setBuffer(int n) {
        this._buffer = n;
    }

    public int getPin() {
        return this._pin;
    }

    public void setPin(int n) {
        this._pin = n;
        this.setText(Integer.valueOf(this._pin).toString());
    }

    public void onClick() {
        int n = ButtonLogicPinSelect.getMult();
        this._pin += n;
        switch (this._buffer) {
            case 14: {
                this._pin = 0;
                break;
            }
            case 13: {
                this._pin %= this._containerScreen.getVariableCount();
                break;
            }
            case 12: {
                this._pin %= 10000;
                break;
            }
            default: {
                this._pin %= 16;
            }
        }
        this.updatePin();
    }

    public void onRightClick() {
        int n = ButtonLogicPinSelect.getMult();
        this._pin -= n;
        if (this._pin < 0) {
            switch (this._buffer) {
                case 14: {
                    this._pin = 0;
                    break;
                }
                case 13: {
                    int n2 = this._containerScreen.getVariableCount();
                    this._pin = n2 + this._pin % n2;
                    break;
                }
                case 12: {
                    this._pin = 10000 + this._pin;
                    break;
                }
                default: {
                    this._pin = 16 + this._pin % 16;
                }
            }
        }
        this.updatePin();
    }

    public void onMiddleClick() {
        int n = ButtonLogicPinSelect.getMult();
        if (this._buffer == 13) {
            this._pin += 16 * n;
            this._pin %= this._containerScreen.getVariableCount();
            this.updatePin();
        } else if (this._buffer == 12) {
            this._pin += 16 * n;
            this._pin %= 10000;
            this.updatePin();
        } else {
            this.onClick();
        }
    }

    private static final int getMult() {
        if (MFRUtil.isAltKeyDown()) {
            if (MFRUtil.isShiftKeyDown()) {
                if (MFRUtil.isCtrlKeyDown()) {
                    return 64;
                }
                return 32;
            }
            if (MFRUtil.isCtrlKeyDown()) {
                return 6;
            }
            return 4;
        }
        if (MFRUtil.isShiftKeyDown()) {
            if (MFRUtil.isCtrlKeyDown()) {
                return 16;
            }
            return 8;
        }
        if (MFRUtil.isCtrlKeyDown()) {
            return 2;
        }
        return 1;
    }

    private void updatePin() {
        this.setText(String.valueOf(this._pin));
        if (this._buttonType == LogicButtonType.Input) {
            this._containerScreen.setInputPinMapping(this._pinIndex, this._buffer, this._pin);
        } else {
            this._containerScreen.setOutputPinMapping(this._pinIndex, this._buffer, this._pin);
        }
    }

    public void drawForeground(int n, int n2) {
        if (this._buffer < 12) {
            if (!CoFHProps.enableColorBlindTextures) {
                this.drawModalRect(((ElementBase)this).posX + 3, ((ElementBase)this).posY + 3, ((ElementBase)this).posX + ((ElementBase)this).sizeX - 3, ((ElementBase)this).posY + ((ElementBase)this).sizeY - 3, _pinColors[this._pin].getColor());
            } else {
                this.drawCenteredString(((ElementBase)this).gui.getFontRenderer(), _pinColorNames[this._pin], ((ElementBase)this).posX + ((ElementBase)this).sizeX / 2, ((ElementBase)this).posY + ((ElementBase)this).sizeY / 2 - 4, this.getTextColor(n, n2));
            }
        } else if (this._buffer < 14) {
            super.drawForeground(n, n2);
        }
    }
}

