/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.forestry;

import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.ReplacementBlock;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;

public class ForestrySapling
extends PlantableStandard
implements IFactoryFertilizable {
    private ITreeRoot root = (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");

    public ForestrySapling(Item item, Block block) {
        super(item, block, Short.MAX_VALUE, null);
        this._plantedBlock = new ReplacementBlock((Block)null){

            @Override
            public boolean replaceBlock(World world, int n, int n2, int n3, ItemStack itemStack) {
                return ForestrySapling.this.root.plantSapling(world, ForestrySapling.this.root.getMember(itemStack), null, n, n2, n3);
            }
        };
    }

    @Override
    public Block getPlant() {
        return this._block;
    }

    @Override
    public boolean canBePlantedHere(World world, int n, int n2, int n3, ItemStack itemStack) {
        if (!world.func_147437_c(n, n2, n3)) {
            return false;
        }
        return this.root.getMember(itemStack).canStay(world, n, n2, n3);
    }

    @Override
    public boolean canFertilize(World world, int n, int n2, int n3, FertilizerType fertilizerType) {
        return true;
    }

    @Override
    public boolean fertilize(World world, Random random, int n, int n2, int n3, FertilizerType fertilizerType) {
        Block block = world.func_147439_a(n, n2, n3);
        this.root.getTree(world, n, n2, n3).getTreeGenerator(world, n, n2, n3, true).func_76484_a(world, random, n, n2, n3);
        return world.func_147439_a(n, n2, n3) != block;
    }
}

