/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.render.block;

import cofh.repack.codechicken.lib.lighting.LightModel;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.uv.IconTransformation;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Scale;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.tile.transport.TileEntityPlasticPipe;

public class PlasticPipeRenderer
implements ISimpleBlockRenderingHandler {
    protected static CCModel base;
    protected static CCModel[] cable;
    protected static CCModel[] iface;
    protected static CCModel[] gripO;
    protected static CCModel[] gripI;
    protected static CCModel[] gripP;
    public static IconTransformation uvt;
    private ForgeDirection[] dirs = ForgeDirection.VALID_DIRECTIONS;

    private static void calculateSidedModels(CCModel[] cCModelArray, Vector3 vector3) {
        cCModelArray[4] = cCModelArray[5].copy().apply((Transformation)new Rotation(Math.PI, 0.0, 1.0, 0.0));
        PlasticPipeRenderer.compute(cCModelArray[4]);
        cCModelArray[3] = cCModelArray[5].copy().apply((Transformation)new Rotation(-1.5707963267948966, 0.0, 1.0, 0.0));
        PlasticPipeRenderer.compute(cCModelArray[3]);
        cCModelArray[2] = cCModelArray[5].copy().apply((Transformation)new Rotation(1.5707963267948966, 0.0, 1.0, 0.0));
        PlasticPipeRenderer.compute(cCModelArray[2]);
        cCModelArray[1] = cCModelArray[5].copy().apply((Transformation)new Rotation(1.5707963267948966, 0.0, 0.0, 1.0).with((Transformation)new Rotation(Math.PI, 0.0, 1.0, 0.0)));
        PlasticPipeRenderer.compute(cCModelArray[1]);
        cCModelArray[0] = cCModelArray[5].copy().apply((Transformation)new Rotation(-1.5707963267948966, 0.0, 0.0, 1.0));
        PlasticPipeRenderer.compute(cCModelArray[0]);
        PlasticPipeRenderer.compute(cCModelArray[5]);
    }

    private static void compute(CCModel cCModel) {
        cCModel.computeNormals();
        cCModel.apply((Transformation)new Translation(0.5, 0.5, 0.5));
        cCModel.computeLighting(LightModel.standardLightModel);
        cCModel.shrinkUVs(9.765625E-4);
    }

    public static void updateUVT(IIcon iIcon) {
        uvt = new IconTransformation(iIcon);
    }

    public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
        CCRenderState.reset();
        CCRenderState.useNormals = true;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        base.render(new CCRenderState.IVertexOperation[]{uvt});
        cable[2].render(new CCRenderState.IVertexOperation[]{uvt});
        cable[3].render(new CCRenderState.IVertexOperation[]{uvt});
        tessellator.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        CCRenderState.reset();
        CCRenderState.useNormals = true;
        CCRenderState.alphaOverride = 255;
        TileEntityPlasticPipe tileEntityPlasticPipe = (TileEntityPlasticPipe)iBlockAccess.func_147438_o(n, n2, n3);
        int n5 = block.func_149677_c(iBlockAccess, n, n2, n3);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78380_c(n5);
        tessellator.func_78372_c((float)n, (float)n2, (float)n3);
        base.render(new CCRenderState.IVertexOperation[]{uvt});
        ForgeDirection[] forgeDirectionArray = this.dirs;
        int n6 = forgeDirectionArray.length;
        while (n6-- > 0) {
            ForgeDirection forgeDirection = forgeDirectionArray[n6];
            if (!tileEntityPlasticPipe.isInterfacing(forgeDirection)) continue;
            int n7 = forgeDirection.ordinal();
            switch (tileEntityPlasticPipe.interfaceMode(forgeDirection)) {
                case 2: {
                    cable[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                    break;
                }
                case 1: {
                    iface[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                    byte by = tileEntityPlasticPipe.getMode(n7);
                    if ((by & 2) == 2) {
                        if (tileEntityPlasticPipe.isPowered()) {
                            gripI[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                            break;
                        }
                        gripP[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                        break;
                    }
                    gripO[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                    break;
                }
            }
        }
        tessellator.func_78372_c((float)(-n), (float)(-n2), (float)(-n3));
        return true;
    }

    public boolean shouldRender3DInInventory(int n) {
        return true;
    }

    public int getRenderId() {
        return MineFactoryReloadedCore.renderIdPPipe;
    }

    static {
        cable = new CCModel[6];
        iface = new CCModel[6];
        gripO = new CCModel[6];
        gripI = new CCModel[6];
        gripP = new CCModel[6];
        try {
            Map map = CCModel.parseObjModels((InputStream)MineFactoryReloadedCore.class.getResourceAsStream("/powercrystals/minefactoryreloaded/models/PlasticPipe.obj"), (int)7, (Transformation)new Scale(0.0625));
            Vector3 vector3 = new Vector3(0.0, 0.0, 0.0);
            base = ((CCModel)map.get("base")).backfacedCopy();
            PlasticPipeRenderer.compute(base);
            PlasticPipeRenderer.iface[5] = ((CCModel)map.get("interface")).backfacedCopy();
            PlasticPipeRenderer.calculateSidedModels(iface, vector3);
            PlasticPipeRenderer.cable[5] = ((CCModel)map.get("cable")).backfacedCopy();
            PlasticPipeRenderer.calculateSidedModels(cable, vector3);
            PlasticPipeRenderer.gripO[5] = ((CCModel)map.get("gripO")).backfacedCopy();
            PlasticPipeRenderer.calculateSidedModels(gripO, vector3);
            PlasticPipeRenderer.gripI[5] = ((CCModel)map.get("gripI")).backfacedCopy();
            PlasticPipeRenderer.calculateSidedModels(gripI, vector3);
            PlasticPipeRenderer.gripP[5] = ((CCModel)map.get("gripP")).backfacedCopy();
            PlasticPipeRenderer.calculateSidedModels(gripP, vector3);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

