/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.position.Area;
import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.MFRLiquidMover;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiSewer;
import powercrystals.minefactoryreloaded.gui.container.ContainerSewer;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntitySewer
extends TileEntityFactoryInventory
implements ITankContainerBucketable {
    private boolean _jammed;
    private int _tick;
    private long _nextSewerCheckTick;

    public TileEntitySewer() {
        super(Machine.Sewer);
        TileEntitySewer.createHAM(this, 0, 1, 0, false);
        this._areaManager.setOverrideDirection(ForgeDirection.UP);
        this._tanks[0].setLock(FluidRegistry.getFluid((String)"sewage"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiSewer(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerSewer getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerSewer(this, inventoryPlayer);
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this._tick;
        if (this._nextSewerCheckTick <= this.field_145850_b.func_82737_E()) {
            Area area = new Area(BlockPosition.fromRotateableTile((TileEntity)this), this._areaManager.getRadius(), 2, 2);
            this._jammed = false;
            for (BlockPosition blockPosition : area.getPositionsBottomFirst()) {
                if (!this.field_145850_b.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z).equals(this._machine.getBlock()) || this.field_145850_b.func_72805_g(blockPosition.x, blockPosition.y, blockPosition.z) != this._machine.getMeta() || blockPosition.x == this.field_145851_c && blockPosition.y == this.field_145848_d && blockPosition.z == this.field_145849_e) continue;
                this._jammed = true;
                break;
            }
            this._nextSewerCheckTick = this.field_145850_b.func_82737_E() + 800L + (long)this.field_145850_b.field_73012_v.nextInt(800);
        }
        if (this._tick >= 31 && !this._jammed) {
            this._tick = 0;
            double d = 0.0;
            long l = this.field_145850_b.func_82737_E();
            AxisAlignedBB axisAlignedBB = this._areaManager.getHarvestArea().toAxisAlignedBB();
            int n = this._tanks[1].getSpace();
            if (n > 0) {
                List list = this.field_145850_b.func_72872_a(EntityXPOrb.class, axisAlignedBB);
                EntityLivingBase entityLivingBase = list.iterator();
                while (entityLivingBase.hasNext()) {
                    EntityXPOrb entityXPOrb = (EntityXPOrb)entityLivingBase.next();
                    if (entityXPOrb.field_70128_L || MFRLiquidMover.fillTankWithXP(this._tanks[1], entityXPOrb) != 0) continue;
                    break;
                }
            }
            List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, axisAlignedBB);
            for (EntityLivingBase entityLivingBase : list) {
                if (!(entityLivingBase instanceof EntityAnimal) && !(entityLivingBase instanceof EntityVillager) && (!entityLivingBase.func_70093_af() || !(entityLivingBase instanceof EntityPlayer)) || entityLivingBase.getEntityData().func_74763_f("mfr:sewerTime") > l) continue;
                entityLivingBase.getEntityData().func_74772_a("mfr:sewerTime", l + 30L);
                d += Math.pow(entityLivingBase.field_70121_D.func_72320_b(), 2.0);
            }
            if (d > 0.0) {
                this._tanks[0].fill(FluidRegistry.getFluidStack((String)"sewage", (int)((int)(25.0 * d))), true);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("jammed", this._jammed);
        nBTTagCompound.func_74774_a("tick", (byte)this._tick);
        nBTTagCompound.func_74772_a("next", this._nextSewerCheckTick);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._jammed = nBTTagCompound.func_74767_n("jammed");
        this._tick = nBTTagCompound.func_74764_b("tick") ? nBTTagCompound.func_74771_c("tick") : MathHelper.RANDOM.nextInt(32);
        this._nextSewerCheckTick = nBTTagCompound.func_74763_f("next");
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain(ItemStack itemStack) {
        return true;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.drain(fluidStack, bl);
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(1000), new FluidTankAdv(4000)};
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    @Override
    public int getUpgradeSlot() {
        return 0;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n == 0 && this.isUsableAugment(itemStack);
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }
}

