/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderExtra {
    public static final RenderExtra INSTANCE = new RenderExtra();
    public byte uvRotateEast;
    public byte uvRotateWest;
    public byte uvRotateSouth;
    public byte uvRotateNorth;
    public byte uvRotateTop;
    public byte uvRotateBottom;
    public boolean uvFlipEast;
    public boolean uvFlipWest;
    public boolean uvFlipSouth;
    public boolean uvFlipNorth;
    public boolean uvFlipTop;
    public boolean uvFlipBottom;
    public boolean uvLock;
    private boolean[] faceSkip = new boolean[6];
    private boolean[] renderFromInside = new boolean[6];
    private boolean overrideColor = false;
    private int overridingColor = 0xFFFFFF;
    private IIcon[] iconIndex = new IIcon[6];
    private byte[] subIcon = new byte[6];
    private boolean blockScaled = false;
    private float scalefactor = 1.0f;
    private boolean blockShifted = false;
    private float[] blockShift = new float[3];
    private float[][] faceShift = new float[6][3];

    public static boolean isRendererDrawingBreakGraphic(RenderBlocks renderer) {
        return renderer.func_147744_b() && renderer.field_147840_d.func_94215_i().startsWith("destroy_stage_");
    }

    public static void resetRenderer(RenderBlocks renderer) {
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        renderer.field_147865_v = 0;
        renderer.field_147867_u = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147873_r = 0;
        renderer.field_147875_q = 0;
        renderer.field_147842_e = false;
        renderer.field_147837_f = false;
        if (!RenderExtra.isRendererDrawingBreakGraphic(renderer)) {
            renderer.func_147771_a();
        }
    }

    public void reset() {
        this.uvRotateEast = 0;
        this.uvRotateWest = 0;
        this.uvRotateSouth = 0;
        this.uvRotateNorth = 0;
        this.uvRotateTop = 0;
        this.uvRotateBottom = 0;
        this.uvFlipEast = false;
        this.uvFlipWest = false;
        this.uvFlipSouth = false;
        this.uvFlipNorth = false;
        this.uvFlipTop = false;
        this.uvFlipBottom = false;
        this.uvLock = false;
        this.clearFaceSkip();
        this.clearAllInsideFace();
        this.clearColorOverride();
        this.clearIconOverrides();
        this.clearSubIcons();
        this.clearRenderScale();
        this.clearRenderShift();
        this.clearAllFaceShift();
    }

    public void setFaceSkip(boolean ... face) {
        for (int side = 0; side < Math.min(6, face.length); side = (int)((byte)(side + 1))) {
            this.faceSkip[side] = face[side];
        }
    }

    public void clearFaceSkip() {
        for (int side = 0; side < 6; side = (int)((byte)(side + 1))) {
            this.faceSkip[side] = false;
        }
    }

    public void setInsideFace(boolean ... face) {
        for (int side = 0; side < Math.min(6, face.length); side = (int)((byte)(side + 1))) {
            this.renderFromInside[side] = face[side];
        }
    }

    public void setAllInsideFace() {
        for (int face = 0; face < 6; face = (int)((byte)(face + 1))) {
            this.renderFromInside[face] = true;
        }
    }

    public void clearInsideFace(int face) {
        if (face >= 0 && face <= 6) {
            this.renderFromInside[face] = false;
        }
    }

    public void clearAllInsideFace() {
        for (int face = 0; face < 6; face = (int)((byte)(face + 1))) {
            this.renderFromInside[face] = false;
        }
    }

    public void setColorOverride(int color) {
        this.overrideColor = true;
        this.overridingColor = color;
    }

    public void clearColorOverride() {
        this.overrideColor = false;
        this.overridingColor = 0xFFFFFF;
    }

    public void setIconOverride(IIcon icon, int face) {
        if (face >= 0 && face < 6) {
            this.iconIndex[face] = icon;
        }
    }

    public void setIconOverrides(IIcon ... icon) {
        for (int face = 0; face < Math.min(6, icon.length); face = (int)((byte)(face + 1))) {
            this.iconIndex[face] = icon[face];
        }
    }

    public void setIconOverrides(Block block, int metadata) {
        for (int face = 0; face < 6; face = (int)((byte)(face + 1))) {
            this.iconIndex[face] = block.func_149691_a(face, metadata);
        }
    }

    public void setAllIconOverrides(IIcon icon) {
        for (int face = 0; face < 6; face = (int)((byte)(face + 1))) {
            this.iconIndex[face] = icon;
        }
    }

    public void clearIconOverride(int face) {
        if (face >= 0 && face <= 6) {
            this.iconIndex[face] = null;
        }
    }

    public void clearIconOverrides() {
        for (int face = 0; face < 6; face = (int)((byte)(face + 1))) {
            this.iconIndex[face] = null;
        }
    }

    public void setSubIcons(int ... icon) {
        for (int face = 0; face < Math.min(6, icon.length); face = (int)((byte)(face + 1))) {
            this.subIcon[face] = (byte)MathHelper.func_76125_a((int)icon[face], (int)0, (int)4);
        }
    }

    public void clearSubIcons() {
        for (int face = 0; face < 6; face = (int)((byte)(face + 1))) {
            this.subIcon[face] = 0;
        }
    }

    public void setRenderScaled(float scalefactor) {
        this.blockScaled = true;
        this.scalefactor = scalefactor;
    }

    public void clearRenderScale() {
        this.blockScaled = false;
        this.scalefactor = 1.0f;
    }

    public void setRenderShift(float xShift, float yShift, float zShift) {
        this.blockShifted = true;
        this.blockShift = new float[]{xShift, yShift, zShift};
    }

    public void clearRenderShift() {
        this.blockShifted = false;
        this.blockShift = new float[6];
    }

    public void setFaceShift(int face, float xShift, float yShift, float zShift) {
        if (face >= 0 && face <= 6) {
            this.faceShift[face] = new float[]{xShift, yShift, zShift};
        }
    }

    public void clearFaceShift(int face) {
        if (face >= 0 && face <= 6) {
            this.faceShift[face] = new float[3];
        }
    }

    public void clearAllFaceShift() {
        for (int face = 0; face < 6; face = (int)((byte)(face + 1))) {
            this.faceShift[face] = new float[3];
        }
    }

    public boolean renderStandardBlock(RenderBlocks renderer, Block block, int x, int y, int z) {
        int color = this.overrideColor ? this.overridingColor : block.func_149720_d(renderer.field_147845_a, x, y, z);
        float valR = (float)(color >> 16 & 0xFF) / 255.0f;
        float valG = (float)(color >> 8 & 0xFF) / 255.0f;
        float valB = (float)(color & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float newR = (valR * 30.0f + valG * 59.0f + valB * 11.0f) / 100.0f;
            float newG = (valR * 30.0f + valG * 70.0f) / 100.0f;
            float newB = (valR * 30.0f + valB * 70.0f) / 100.0f;
            valR = newR;
            valG = newG;
            valB = newB;
        }
        if (Minecraft.func_71379_u() && block.func_149750_m() == 0) {
            boolean fullBlock = !renderer.field_147849_o;
            return this.renderwithAmbientOcclusion(renderer, block, x, y, z, valR, valG, valB, fullBlock);
        }
        return this.renderWithColorMultiplier(renderer, block, x, y, z, valR, valG, valB);
    }

    public boolean renderwithAmbientOcclusion(RenderBlocks renderer, Block block, int x, int y, int z, float valR, float valG, float valB, boolean fullBlock) {
        int i2;
        int l1;
        int k1;
        int j1;
        float f11;
        float f10;
        float f9;
        float f8;
        float aoLightValue;
        int tempBrightness;
        boolean flag5;
        boolean flag4;
        boolean flag3;
        boolean flag2;
        renderer.field_147863_w = true;
        boolean rendered = false;
        float colorTL = 0.0f;
        float colorBL = 0.0f;
        float colorBR = 0.0f;
        float colorTR = 0.0f;
        boolean isGrass = true;
        int masterBrightness = block.func_149677_c(renderer.field_147845_a, x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(983055);
        if (renderer.func_147745_b(block).func_94215_i().equals("grass_top") || renderer.func_147744_b()) {
            isGrass = false;
        }
        if (!this.faceSkip[0] && (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y - 1, z, 0))) {
            if (renderer.field_147855_j <= 0.0) {
                --y;
            }
            renderer.field_147831_S = block.func_149677_c(renderer.field_147845_a, x - 1, y, z);
            renderer.field_147825_U = block.func_149677_c(renderer.field_147845_a, x, y, z - 1);
            renderer.field_147828_V = block.func_149677_c(renderer.field_147845_a, x, y, z + 1);
            renderer.field_147835_X = block.func_149677_c(renderer.field_147845_a, x + 1, y, z);
            renderer.field_147886_y = renderer.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I();
            renderer.field_147814_A = renderer.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I();
            renderer.field_147815_B = renderer.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I();
            renderer.field_147810_D = renderer.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I();
            flag2 = renderer.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149751_l();
            flag3 = renderer.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149751_l();
            flag4 = renderer.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149751_l();
            flag5 = renderer.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149751_l();
            if (!flag5 && !flag3) {
                renderer.field_147888_x = renderer.field_147886_y;
                renderer.field_147832_R = renderer.field_147831_S;
            } else {
                renderer.field_147888_x = renderer.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149685_I();
                renderer.field_147832_R = block.func_149677_c(renderer.field_147845_a, x - 1, y, z - 1);
            }
            if (!flag4 && !flag3) {
                renderer.field_147884_z = renderer.field_147886_y;
                renderer.field_147826_T = renderer.field_147831_S;
            } else {
                renderer.field_147884_z = renderer.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149685_I();
                renderer.field_147826_T = block.func_149677_c(renderer.field_147845_a, x - 1, y, z + 1);
            }
            if (!flag5 && !flag2) {
                renderer.field_147816_C = renderer.field_147810_D;
                renderer.field_147827_W = renderer.field_147835_X;
            } else {
                renderer.field_147816_C = renderer.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149685_I();
                renderer.field_147827_W = block.func_149677_c(renderer.field_147845_a, x + 1, y, z - 1);
            }
            if (!flag4 && !flag2) {
                renderer.field_147811_E = renderer.field_147810_D;
                renderer.field_147834_Y = renderer.field_147835_X;
            } else {
                renderer.field_147811_E = renderer.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149685_I();
                renderer.field_147834_Y = block.func_149677_c(renderer.field_147845_a, x + 1, y, z + 1);
            }
            if (renderer.field_147855_j <= 0.0) {
                ++y;
            }
            tempBrightness = masterBrightness;
            if (renderer.field_147855_j <= 0.0 || !renderer.field_147845_a.func_147439_a(x, y - 1, z).func_149662_c()) {
                tempBrightness = block.func_149677_c(renderer.field_147845_a, x, y - 1, z);
            }
            aoLightValue = renderer.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I();
            colorTL = (renderer.field_147884_z + renderer.field_147886_y + renderer.field_147815_B + aoLightValue) / 4.0f;
            colorTR = (renderer.field_147815_B + aoLightValue + renderer.field_147811_E + renderer.field_147810_D) / 4.0f;
            colorBR = (aoLightValue + renderer.field_147814_A + renderer.field_147810_D + renderer.field_147816_C) / 4.0f;
            colorBL = (renderer.field_147886_y + renderer.field_147888_x + aoLightValue + renderer.field_147814_A) / 4.0f;
            renderer.field_147864_al = renderer.func_147778_a(renderer.field_147826_T, renderer.field_147831_S, renderer.field_147828_V, tempBrightness);
            renderer.field_147870_ao = renderer.func_147778_a(renderer.field_147828_V, renderer.field_147834_Y, renderer.field_147835_X, tempBrightness);
            renderer.field_147876_an = renderer.func_147778_a(renderer.field_147825_U, renderer.field_147835_X, renderer.field_147827_W, tempBrightness);
            renderer.field_147874_am = renderer.func_147778_a(renderer.field_147831_S, renderer.field_147832_R, renderer.field_147825_U, tempBrightness);
            if (isGrass) {
                renderer.field_147850_ar = renderer.field_147848_as = valR * 0.5f;
                renderer.field_147852_aq = renderer.field_147848_as;
                renderer.field_147872_ap = renderer.field_147848_as;
                renderer.field_147858_av = renderer.field_147856_aw = valG * 0.5f;
                renderer.field_147860_au = renderer.field_147856_aw;
                renderer.field_147846_at = renderer.field_147856_aw;
                renderer.field_147839_az = renderer.field_147833_aA = valB * 0.5f;
                renderer.field_147841_ay = renderer.field_147833_aA;
                renderer.field_147854_ax = renderer.field_147833_aA;
            } else {
                renderer.field_147848_as = 0.5f;
                renderer.field_147850_ar = 0.5f;
                renderer.field_147852_aq = 0.5f;
                renderer.field_147872_ap = 0.5f;
                renderer.field_147856_aw = 0.5f;
                renderer.field_147858_av = 0.5f;
                renderer.field_147860_au = 0.5f;
                renderer.field_147846_at = 0.5f;
                renderer.field_147833_aA = 0.5f;
                renderer.field_147839_az = 0.5f;
                renderer.field_147841_ay = 0.5f;
                renderer.field_147854_ax = 0.5f;
            }
            renderer.field_147872_ap *= colorTL;
            renderer.field_147846_at *= colorTL;
            renderer.field_147854_ax *= colorTL;
            renderer.field_147852_aq *= colorBL;
            renderer.field_147860_au *= colorBL;
            renderer.field_147841_ay *= colorBL;
            renderer.field_147850_ar *= colorBR;
            renderer.field_147858_av *= colorBR;
            renderer.field_147839_az *= colorBR;
            renderer.field_147848_as *= colorTR;
            renderer.field_147856_aw *= colorTR;
            renderer.field_147833_aA *= colorTR;
            this.renderFace(renderer, block, x, y, z, 0);
            rendered = true;
        }
        if (!this.faceSkip[1] && (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y + 1, z, 1))) {
            if (renderer.field_147857_k >= 1.0) {
                ++y;
            }
            renderer.field_147880_aa = block.func_149677_c(renderer.field_147845_a, x - 1, y, z);
            renderer.field_147885_ae = block.func_149677_c(renderer.field_147845_a, x + 1, y, z);
            renderer.field_147878_ac = block.func_149677_c(renderer.field_147845_a, x, y, z - 1);
            renderer.field_147887_af = block.func_149677_c(renderer.field_147845_a, x, y, z + 1);
            renderer.field_147813_G = renderer.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I();
            renderer.field_147824_K = renderer.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I();
            renderer.field_147822_I = renderer.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I();
            renderer.field_147817_L = renderer.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I();
            flag2 = renderer.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149751_l();
            flag3 = renderer.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149751_l();
            flag4 = renderer.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149751_l();
            flag5 = renderer.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149751_l();
            if (!flag5 && !flag3) {
                renderer.field_147812_F = renderer.field_147813_G;
                renderer.field_147836_Z = renderer.field_147880_aa;
            } else {
                renderer.field_147812_F = renderer.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149685_I();
                renderer.field_147836_Z = block.func_149677_c(renderer.field_147845_a, x - 1, y, z - 1);
            }
            if (!flag5 && !flag2) {
                renderer.field_147823_J = renderer.field_147824_K;
                renderer.field_147879_ad = renderer.field_147885_ae;
            } else {
                renderer.field_147823_J = renderer.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149685_I();
                renderer.field_147879_ad = block.func_149677_c(renderer.field_147845_a, x + 1, y, z - 1);
            }
            if (!flag4 && !flag3) {
                renderer.field_147821_H = renderer.field_147813_G;
                renderer.field_147881_ab = renderer.field_147880_aa;
            } else {
                renderer.field_147821_H = renderer.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149685_I();
                renderer.field_147881_ab = block.func_149677_c(renderer.field_147845_a, x - 1, y, z + 1);
            }
            if (!flag4 && !flag2) {
                renderer.field_147818_M = renderer.field_147824_K;
                renderer.field_147882_ag = renderer.field_147885_ae;
            } else {
                renderer.field_147818_M = renderer.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149685_I();
                renderer.field_147882_ag = block.func_149677_c(renderer.field_147845_a, x + 1, y, z + 1);
            }
            if (renderer.field_147857_k >= 1.0) {
                --y;
            }
            tempBrightness = masterBrightness;
            if (renderer.field_147857_k >= 1.0 || !renderer.field_147845_a.func_147439_a(x, y + 1, z).func_149662_c()) {
                tempBrightness = block.func_149677_c(renderer.field_147845_a, x, y + 1, z);
            }
            aoLightValue = renderer.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I();
            colorTR = (renderer.field_147821_H + renderer.field_147813_G + renderer.field_147817_L + aoLightValue) / 4.0f;
            colorTL = (renderer.field_147817_L + aoLightValue + renderer.field_147818_M + renderer.field_147824_K) / 4.0f;
            colorBL = (aoLightValue + renderer.field_147822_I + renderer.field_147824_K + renderer.field_147823_J) / 4.0f;
            colorBR = (renderer.field_147813_G + renderer.field_147812_F + aoLightValue + renderer.field_147822_I) / 4.0f;
            renderer.field_147870_ao = renderer.func_147778_a(renderer.field_147881_ab, renderer.field_147880_aa, renderer.field_147887_af, tempBrightness);
            renderer.field_147864_al = renderer.func_147778_a(renderer.field_147887_af, renderer.field_147882_ag, renderer.field_147885_ae, tempBrightness);
            renderer.field_147874_am = renderer.func_147778_a(renderer.field_147878_ac, renderer.field_147885_ae, renderer.field_147879_ad, tempBrightness);
            renderer.field_147876_an = renderer.func_147778_a(renderer.field_147880_aa, renderer.field_147836_Z, renderer.field_147878_ac, tempBrightness);
            renderer.field_147850_ar = renderer.field_147848_as = valR;
            renderer.field_147852_aq = renderer.field_147848_as;
            renderer.field_147872_ap = renderer.field_147848_as;
            renderer.field_147858_av = renderer.field_147856_aw = valG;
            renderer.field_147860_au = renderer.field_147856_aw;
            renderer.field_147846_at = renderer.field_147856_aw;
            renderer.field_147839_az = renderer.field_147833_aA = valB;
            renderer.field_147841_ay = renderer.field_147833_aA;
            renderer.field_147854_ax = renderer.field_147833_aA;
            renderer.field_147872_ap *= colorTL;
            renderer.field_147846_at *= colorTL;
            renderer.field_147854_ax *= colorTL;
            renderer.field_147852_aq *= colorBL;
            renderer.field_147860_au *= colorBL;
            renderer.field_147841_ay *= colorBL;
            renderer.field_147850_ar *= colorBR;
            renderer.field_147858_av *= colorBR;
            renderer.field_147839_az *= colorBR;
            renderer.field_147848_as *= colorTR;
            renderer.field_147856_aw *= colorTR;
            renderer.field_147833_aA *= colorTR;
            this.renderFace(renderer, block, x, y, z, 1);
            rendered = true;
        }
        if (!this.faceSkip[2] && (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y, z - 1, 2))) {
            if (renderer.field_147851_l <= 0.0) {
                --z;
            }
            renderer.field_147819_N = renderer.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I();
            renderer.field_147814_A = renderer.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I();
            renderer.field_147822_I = renderer.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I();
            renderer.field_147820_O = renderer.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I();
            renderer.field_147883_ah = block.func_149677_c(renderer.field_147845_a, x - 1, y, z);
            renderer.field_147825_U = block.func_149677_c(renderer.field_147845_a, x, y - 1, z);
            renderer.field_147878_ac = block.func_149677_c(renderer.field_147845_a, x, y + 1, z);
            renderer.field_147866_ai = block.func_149677_c(renderer.field_147845_a, x + 1, y, z);
            flag2 = renderer.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149751_l();
            flag3 = renderer.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149751_l();
            flag4 = renderer.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149751_l();
            flag5 = renderer.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149751_l();
            if (!flag3 && !flag5) {
                renderer.field_147888_x = renderer.field_147819_N;
                renderer.field_147832_R = renderer.field_147883_ah;
            } else {
                renderer.field_147888_x = renderer.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149685_I();
                renderer.field_147832_R = block.func_149677_c(renderer.field_147845_a, x - 1, y - 1, z);
            }
            if (!flag3 && !flag4) {
                renderer.field_147812_F = renderer.field_147819_N;
                renderer.field_147836_Z = renderer.field_147883_ah;
            } else {
                renderer.field_147812_F = renderer.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149685_I();
                renderer.field_147836_Z = block.func_149677_c(renderer.field_147845_a, x - 1, y + 1, z);
            }
            if (!flag2 && !flag5) {
                renderer.field_147816_C = renderer.field_147820_O;
                renderer.field_147827_W = renderer.field_147866_ai;
            } else {
                renderer.field_147816_C = renderer.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149685_I();
                renderer.field_147827_W = block.func_149677_c(renderer.field_147845_a, x + 1, y - 1, z);
            }
            if (!flag2 && !flag4) {
                renderer.field_147823_J = renderer.field_147820_O;
                renderer.field_147879_ad = renderer.field_147866_ai;
            } else {
                renderer.field_147823_J = renderer.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149685_I();
                renderer.field_147879_ad = block.func_149677_c(renderer.field_147845_a, x + 1, y + 1, z);
            }
            if (renderer.field_147851_l <= 0.0) {
                ++z;
            }
            tempBrightness = masterBrightness;
            if (renderer.field_147851_l <= 0.0 || !renderer.field_147845_a.func_147439_a(x, y, z - 1).func_149662_c()) {
                tempBrightness = block.func_149677_c(renderer.field_147845_a, x, y, z - 1);
            }
            aoLightValue = renderer.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I();
            if (fullBlock) {
                colorTL = (renderer.field_147819_N + renderer.field_147812_F + aoLightValue + renderer.field_147822_I) / 4.0f;
                colorBL = (aoLightValue + renderer.field_147822_I + renderer.field_147820_O + renderer.field_147823_J) / 4.0f;
                colorBR = (renderer.field_147814_A + aoLightValue + renderer.field_147816_C + renderer.field_147820_O) / 4.0f;
                colorTR = (renderer.field_147888_x + renderer.field_147819_N + renderer.field_147814_A + aoLightValue) / 4.0f;
                renderer.field_147864_al = renderer.func_147778_a(renderer.field_147883_ah, renderer.field_147836_Z, renderer.field_147878_ac, tempBrightness);
                renderer.field_147874_am = renderer.func_147778_a(renderer.field_147878_ac, renderer.field_147866_ai, renderer.field_147879_ad, tempBrightness);
                renderer.field_147876_an = renderer.func_147778_a(renderer.field_147825_U, renderer.field_147827_W, renderer.field_147866_ai, tempBrightness);
                renderer.field_147870_ao = renderer.func_147778_a(renderer.field_147832_R, renderer.field_147883_ah, renderer.field_147825_U, tempBrightness);
            } else {
                f8 = (renderer.field_147819_N + renderer.field_147812_F + aoLightValue + renderer.field_147822_I) / 4.0f;
                f9 = (aoLightValue + renderer.field_147822_I + renderer.field_147820_O + renderer.field_147823_J) / 4.0f;
                f10 = (renderer.field_147814_A + aoLightValue + renderer.field_147816_C + renderer.field_147820_O) / 4.0f;
                f11 = (renderer.field_147888_x + renderer.field_147819_N + renderer.field_147814_A + aoLightValue) / 4.0f;
                colorTL = (float)((double)f8 * renderer.field_147857_k * (1.0 - renderer.field_147859_h) + (double)f9 * renderer.field_147857_k * renderer.field_147859_h + (double)f10 * (1.0 - renderer.field_147857_k) * renderer.field_147859_h + (double)f11 * (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147859_h));
                colorBL = (float)((double)f8 * renderer.field_147857_k * (1.0 - renderer.field_147861_i) + (double)f9 * renderer.field_147857_k * renderer.field_147861_i + (double)f10 * (1.0 - renderer.field_147857_k) * renderer.field_147861_i + (double)f11 * (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147861_i));
                colorBR = (float)((double)f8 * renderer.field_147855_j * (1.0 - renderer.field_147861_i) + (double)f9 * renderer.field_147855_j * renderer.field_147861_i + (double)f10 * (1.0 - renderer.field_147855_j) * renderer.field_147861_i + (double)f11 * (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147861_i));
                colorTR = (float)((double)f8 * renderer.field_147855_j * (1.0 - renderer.field_147859_h) + (double)f9 * renderer.field_147855_j * renderer.field_147859_h + (double)f10 * (1.0 - renderer.field_147855_j) * renderer.field_147859_h + (double)f11 * (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147859_h));
                j1 = renderer.func_147778_a(renderer.field_147883_ah, renderer.field_147836_Z, renderer.field_147878_ac, tempBrightness);
                k1 = renderer.func_147778_a(renderer.field_147878_ac, renderer.field_147866_ai, renderer.field_147879_ad, tempBrightness);
                l1 = renderer.func_147778_a(renderer.field_147825_U, renderer.field_147827_W, renderer.field_147866_ai, tempBrightness);
                i2 = renderer.func_147778_a(renderer.field_147832_R, renderer.field_147883_ah, renderer.field_147825_U, tempBrightness);
                renderer.field_147864_al = renderer.func_147727_a(j1, k1, l1, i2, renderer.field_147857_k * (1.0 - renderer.field_147859_h), renderer.field_147857_k * renderer.field_147859_h, (1.0 - renderer.field_147857_k) * renderer.field_147859_h, (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147859_h));
                renderer.field_147874_am = renderer.func_147727_a(j1, k1, l1, i2, renderer.field_147857_k * (1.0 - renderer.field_147861_i), renderer.field_147857_k * renderer.field_147861_i, (1.0 - renderer.field_147857_k) * renderer.field_147861_i, (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147861_i));
                renderer.field_147876_an = renderer.func_147727_a(j1, k1, l1, i2, renderer.field_147855_j * (1.0 - renderer.field_147861_i), renderer.field_147855_j * renderer.field_147861_i, (1.0 - renderer.field_147855_j) * renderer.field_147861_i, (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147861_i));
                renderer.field_147870_ao = renderer.func_147727_a(j1, k1, l1, i2, renderer.field_147855_j * (1.0 - renderer.field_147859_h), renderer.field_147855_j * renderer.field_147859_h, (1.0 - renderer.field_147855_j) * renderer.field_147859_h, (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147859_h));
            }
            if (isGrass) {
                renderer.field_147850_ar = renderer.field_147848_as = valR * 0.8f;
                renderer.field_147852_aq = renderer.field_147848_as;
                renderer.field_147872_ap = renderer.field_147848_as;
                renderer.field_147858_av = renderer.field_147856_aw = valG * 0.8f;
                renderer.field_147860_au = renderer.field_147856_aw;
                renderer.field_147846_at = renderer.field_147856_aw;
                renderer.field_147839_az = renderer.field_147833_aA = valB * 0.8f;
                renderer.field_147841_ay = renderer.field_147833_aA;
                renderer.field_147854_ax = renderer.field_147833_aA;
            } else {
                renderer.field_147848_as = 0.8f;
                renderer.field_147850_ar = 0.8f;
                renderer.field_147852_aq = 0.8f;
                renderer.field_147872_ap = 0.8f;
                renderer.field_147856_aw = 0.8f;
                renderer.field_147858_av = 0.8f;
                renderer.field_147860_au = 0.8f;
                renderer.field_147846_at = 0.8f;
                renderer.field_147833_aA = 0.8f;
                renderer.field_147839_az = 0.8f;
                renderer.field_147841_ay = 0.8f;
                renderer.field_147854_ax = 0.8f;
            }
            renderer.field_147872_ap *= colorTL;
            renderer.field_147846_at *= colorTL;
            renderer.field_147854_ax *= colorTL;
            renderer.field_147852_aq *= colorBL;
            renderer.field_147860_au *= colorBL;
            renderer.field_147841_ay *= colorBL;
            renderer.field_147850_ar *= colorBR;
            renderer.field_147858_av *= colorBR;
            renderer.field_147839_az *= colorBR;
            renderer.field_147848_as *= colorTR;
            renderer.field_147856_aw *= colorTR;
            renderer.field_147833_aA *= colorTR;
            this.renderFace(renderer, block, x, y, z, 2);
            rendered = true;
        }
        if (!this.faceSkip[3] && (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y, z + 1, 3))) {
            if (renderer.field_147853_m >= 1.0) {
                ++z;
            }
            renderer.field_147830_P = renderer.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I();
            renderer.field_147829_Q = renderer.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I();
            renderer.field_147815_B = renderer.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I();
            renderer.field_147817_L = renderer.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I();
            renderer.field_147868_aj = block.func_149677_c(renderer.field_147845_a, x - 1, y, z);
            renderer.field_147862_ak = block.func_149677_c(renderer.field_147845_a, x + 1, y, z);
            renderer.field_147828_V = block.func_149677_c(renderer.field_147845_a, x, y - 1, z);
            renderer.field_147887_af = block.func_149677_c(renderer.field_147845_a, x, y + 1, z);
            flag2 = renderer.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149751_l();
            flag3 = renderer.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149751_l();
            flag4 = renderer.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149751_l();
            flag5 = renderer.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149751_l();
            if (!flag3 && !flag5) {
                renderer.field_147884_z = renderer.field_147830_P;
                renderer.field_147826_T = renderer.field_147868_aj;
            } else {
                renderer.field_147884_z = renderer.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149685_I();
                renderer.field_147826_T = block.func_149677_c(renderer.field_147845_a, x - 1, y - 1, z);
            }
            if (!flag3 && !flag4) {
                renderer.field_147821_H = renderer.field_147830_P;
                renderer.field_147881_ab = renderer.field_147868_aj;
            } else {
                renderer.field_147821_H = renderer.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149685_I();
                renderer.field_147881_ab = block.func_149677_c(renderer.field_147845_a, x - 1, y + 1, z);
            }
            if (!flag2 && !flag5) {
                renderer.field_147811_E = renderer.field_147829_Q;
                renderer.field_147834_Y = renderer.field_147862_ak;
            } else {
                renderer.field_147811_E = renderer.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149685_I();
                renderer.field_147834_Y = block.func_149677_c(renderer.field_147845_a, x + 1, y - 1, z);
            }
            if (!flag2 && !flag4) {
                renderer.field_147818_M = renderer.field_147829_Q;
                renderer.field_147882_ag = renderer.field_147862_ak;
            } else {
                renderer.field_147818_M = renderer.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149685_I();
                renderer.field_147882_ag = block.func_149677_c(renderer.field_147845_a, x + 1, y + 1, z);
            }
            if (renderer.field_147853_m >= 1.0) {
                --z;
            }
            tempBrightness = masterBrightness;
            if (renderer.field_147853_m >= 1.0 || !renderer.field_147845_a.func_147439_a(x, y, z + 1).func_149662_c()) {
                tempBrightness = block.func_149677_c(renderer.field_147845_a, x, y, z + 1);
            }
            aoLightValue = renderer.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I();
            if (fullBlock) {
                colorTL = (renderer.field_147830_P + renderer.field_147821_H + aoLightValue + renderer.field_147817_L) / 4.0f;
                colorTR = (aoLightValue + renderer.field_147817_L + renderer.field_147829_Q + renderer.field_147818_M) / 4.0f;
                colorBR = (renderer.field_147815_B + aoLightValue + renderer.field_147811_E + renderer.field_147829_Q) / 4.0f;
                colorBL = (renderer.field_147884_z + renderer.field_147830_P + renderer.field_147815_B + aoLightValue) / 4.0f;
                renderer.field_147864_al = renderer.func_147778_a(renderer.field_147868_aj, renderer.field_147881_ab, renderer.field_147887_af, tempBrightness);
                renderer.field_147870_ao = renderer.func_147778_a(renderer.field_147887_af, renderer.field_147862_ak, renderer.field_147882_ag, tempBrightness);
                renderer.field_147876_an = renderer.func_147778_a(renderer.field_147828_V, renderer.field_147834_Y, renderer.field_147862_ak, tempBrightness);
                renderer.field_147874_am = renderer.func_147778_a(renderer.field_147826_T, renderer.field_147868_aj, renderer.field_147828_V, tempBrightness);
            } else {
                f8 = (renderer.field_147830_P + renderer.field_147821_H + aoLightValue + renderer.field_147817_L) / 4.0f;
                f9 = (aoLightValue + renderer.field_147817_L + renderer.field_147829_Q + renderer.field_147818_M) / 4.0f;
                f10 = (renderer.field_147815_B + aoLightValue + renderer.field_147811_E + renderer.field_147829_Q) / 4.0f;
                f11 = (renderer.field_147884_z + renderer.field_147830_P + renderer.field_147815_B + aoLightValue) / 4.0f;
                colorTL = (float)((double)f8 * renderer.field_147857_k * (1.0 - renderer.field_147859_h) + (double)f9 * renderer.field_147857_k * renderer.field_147859_h + (double)f10 * (1.0 - renderer.field_147857_k) * renderer.field_147859_h + (double)f11 * (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147859_h));
                colorBL = (float)((double)f8 * renderer.field_147855_j * (1.0 - renderer.field_147859_h) + (double)f9 * renderer.field_147855_j * renderer.field_147859_h + (double)f10 * (1.0 - renderer.field_147855_j) * renderer.field_147859_h + (double)f11 * (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147859_h));
                colorBR = (float)((double)f8 * renderer.field_147855_j * (1.0 - renderer.field_147861_i) + (double)f9 * renderer.field_147855_j * renderer.field_147861_i + (double)f10 * (1.0 - renderer.field_147855_j) * renderer.field_147861_i + (double)f11 * (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147861_i));
                colorTR = (float)((double)f8 * renderer.field_147857_k * (1.0 - renderer.field_147861_i) + (double)f9 * renderer.field_147857_k * renderer.field_147861_i + (double)f10 * (1.0 - renderer.field_147857_k) * renderer.field_147861_i + (double)f11 * (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147861_i));
                j1 = renderer.func_147778_a(renderer.field_147868_aj, renderer.field_147881_ab, renderer.field_147887_af, tempBrightness);
                k1 = renderer.func_147778_a(renderer.field_147887_af, renderer.field_147862_ak, renderer.field_147882_ag, tempBrightness);
                l1 = renderer.func_147778_a(renderer.field_147828_V, renderer.field_147834_Y, renderer.field_147862_ak, tempBrightness);
                i2 = renderer.func_147778_a(renderer.field_147826_T, renderer.field_147868_aj, renderer.field_147828_V, tempBrightness);
                renderer.field_147864_al = renderer.func_147727_a(j1, i2, l1, k1, renderer.field_147857_k * (1.0 - renderer.field_147859_h), (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147859_h), (1.0 - renderer.field_147857_k) * renderer.field_147859_h, renderer.field_147857_k * renderer.field_147859_h);
                renderer.field_147874_am = renderer.func_147727_a(j1, i2, l1, k1, renderer.field_147855_j * (1.0 - renderer.field_147859_h), (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147859_h), (1.0 - renderer.field_147855_j) * renderer.field_147859_h, renderer.field_147855_j * renderer.field_147859_h);
                renderer.field_147876_an = renderer.func_147727_a(j1, i2, l1, k1, renderer.field_147855_j * (1.0 - renderer.field_147861_i), (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147861_i), (1.0 - renderer.field_147855_j) * renderer.field_147861_i, renderer.field_147855_j * renderer.field_147861_i);
                renderer.field_147870_ao = renderer.func_147727_a(j1, i2, l1, k1, renderer.field_147857_k * (1.0 - renderer.field_147861_i), (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147861_i), (1.0 - renderer.field_147857_k) * renderer.field_147861_i, renderer.field_147857_k * renderer.field_147861_i);
            }
            if (isGrass) {
                renderer.field_147850_ar = renderer.field_147848_as = valR * 0.8f;
                renderer.field_147852_aq = renderer.field_147848_as;
                renderer.field_147872_ap = renderer.field_147848_as;
                renderer.field_147858_av = renderer.field_147856_aw = valG * 0.8f;
                renderer.field_147860_au = renderer.field_147856_aw;
                renderer.field_147846_at = renderer.field_147856_aw;
                renderer.field_147839_az = renderer.field_147833_aA = valB * 0.8f;
                renderer.field_147841_ay = renderer.field_147833_aA;
                renderer.field_147854_ax = renderer.field_147833_aA;
            } else {
                renderer.field_147848_as = 0.8f;
                renderer.field_147850_ar = 0.8f;
                renderer.field_147852_aq = 0.8f;
                renderer.field_147872_ap = 0.8f;
                renderer.field_147856_aw = 0.8f;
                renderer.field_147858_av = 0.8f;
                renderer.field_147860_au = 0.8f;
                renderer.field_147846_at = 0.8f;
                renderer.field_147833_aA = 0.8f;
                renderer.field_147839_az = 0.8f;
                renderer.field_147841_ay = 0.8f;
                renderer.field_147854_ax = 0.8f;
            }
            renderer.field_147872_ap *= colorTL;
            renderer.field_147846_at *= colorTL;
            renderer.field_147854_ax *= colorTL;
            renderer.field_147852_aq *= colorBL;
            renderer.field_147860_au *= colorBL;
            renderer.field_147841_ay *= colorBL;
            renderer.field_147850_ar *= colorBR;
            renderer.field_147858_av *= colorBR;
            renderer.field_147839_az *= colorBR;
            renderer.field_147848_as *= colorTR;
            renderer.field_147856_aw *= colorTR;
            renderer.field_147833_aA *= colorTR;
            this.renderFace(renderer, block, x, y, z, 3);
            rendered = true;
        }
        if (!this.faceSkip[4] && (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x - 1, y, z, 4))) {
            if (renderer.field_147859_h <= 0.0) {
                --x;
            }
            renderer.field_147886_y = renderer.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I();
            renderer.field_147819_N = renderer.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I();
            renderer.field_147830_P = renderer.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I();
            renderer.field_147813_G = renderer.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I();
            renderer.field_147831_S = block.func_149677_c(renderer.field_147845_a, x, y - 1, z);
            renderer.field_147883_ah = block.func_149677_c(renderer.field_147845_a, x, y, z - 1);
            renderer.field_147868_aj = block.func_149677_c(renderer.field_147845_a, x, y, z + 1);
            renderer.field_147880_aa = block.func_149677_c(renderer.field_147845_a, x, y + 1, z);
            flag2 = renderer.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149751_l();
            flag3 = renderer.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149751_l();
            flag4 = renderer.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149751_l();
            flag5 = renderer.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149751_l();
            if (!flag4 && !flag3) {
                renderer.field_147888_x = renderer.field_147819_N;
                renderer.field_147832_R = renderer.field_147883_ah;
            } else {
                renderer.field_147888_x = renderer.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149685_I();
                renderer.field_147832_R = block.func_149677_c(renderer.field_147845_a, x, y - 1, z - 1);
            }
            if (!flag5 && !flag3) {
                renderer.field_147884_z = renderer.field_147830_P;
                renderer.field_147826_T = renderer.field_147868_aj;
            } else {
                renderer.field_147884_z = renderer.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149685_I();
                renderer.field_147826_T = block.func_149677_c(renderer.field_147845_a, x, y - 1, z + 1);
            }
            if (!flag4 && !flag2) {
                renderer.field_147812_F = renderer.field_147819_N;
                renderer.field_147836_Z = renderer.field_147883_ah;
            } else {
                renderer.field_147812_F = renderer.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149685_I();
                renderer.field_147836_Z = block.func_149677_c(renderer.field_147845_a, x, y + 1, z - 1);
            }
            if (!flag5 && !flag2) {
                renderer.field_147821_H = renderer.field_147830_P;
                renderer.field_147881_ab = renderer.field_147868_aj;
            } else {
                renderer.field_147821_H = renderer.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149685_I();
                renderer.field_147881_ab = block.func_149677_c(renderer.field_147845_a, x, y + 1, z + 1);
            }
            if (renderer.field_147859_h <= 0.0) {
                ++x;
            }
            tempBrightness = masterBrightness;
            if (renderer.field_147859_h <= 0.0 || !renderer.field_147845_a.func_147439_a(x - 1, y, z).func_149662_c()) {
                tempBrightness = block.func_149677_c(renderer.field_147845_a, x - 1, y, z);
            }
            aoLightValue = renderer.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I();
            if (fullBlock) {
                colorTR = (renderer.field_147886_y + renderer.field_147884_z + aoLightValue + renderer.field_147830_P) / 4.0f;
                colorTL = (aoLightValue + renderer.field_147830_P + renderer.field_147813_G + renderer.field_147821_H) / 4.0f;
                colorBL = (renderer.field_147819_N + aoLightValue + renderer.field_147812_F + renderer.field_147813_G) / 4.0f;
                colorBR = (renderer.field_147888_x + renderer.field_147886_y + renderer.field_147819_N + aoLightValue) / 4.0f;
                renderer.field_147870_ao = renderer.func_147778_a(renderer.field_147831_S, renderer.field_147826_T, renderer.field_147868_aj, tempBrightness);
                renderer.field_147864_al = renderer.func_147778_a(renderer.field_147868_aj, renderer.field_147880_aa, renderer.field_147881_ab, tempBrightness);
                renderer.field_147874_am = renderer.func_147778_a(renderer.field_147883_ah, renderer.field_147836_Z, renderer.field_147880_aa, tempBrightness);
                renderer.field_147876_an = renderer.func_147778_a(renderer.field_147832_R, renderer.field_147831_S, renderer.field_147883_ah, tempBrightness);
            } else {
                f8 = (renderer.field_147886_y + renderer.field_147884_z + aoLightValue + renderer.field_147830_P) / 4.0f;
                f9 = (aoLightValue + renderer.field_147830_P + renderer.field_147813_G + renderer.field_147821_H) / 4.0f;
                f10 = (renderer.field_147819_N + aoLightValue + renderer.field_147812_F + renderer.field_147813_G) / 4.0f;
                f11 = (renderer.field_147888_x + renderer.field_147886_y + renderer.field_147819_N + aoLightValue) / 4.0f;
                colorTL = (float)((double)f9 * renderer.field_147857_k * renderer.field_147853_m + (double)f10 * renderer.field_147857_k * (1.0 - renderer.field_147853_m) + (double)f11 * (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147853_m) + (double)f8 * (1.0 - renderer.field_147857_k) * renderer.field_147853_m);
                colorBL = (float)((double)f9 * renderer.field_147857_k * renderer.field_147851_l + (double)f10 * renderer.field_147857_k * (1.0 - renderer.field_147851_l) + (double)f11 * (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147851_l) + (double)f8 * (1.0 - renderer.field_147857_k) * renderer.field_147851_l);
                colorBR = (float)((double)f9 * renderer.field_147855_j * renderer.field_147851_l + (double)f10 * renderer.field_147855_j * (1.0 - renderer.field_147851_l) + (double)f11 * (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147851_l) + (double)f8 * (1.0 - renderer.field_147855_j) * renderer.field_147851_l);
                colorTR = (float)((double)f9 * renderer.field_147855_j * renderer.field_147853_m + (double)f10 * renderer.field_147855_j * (1.0 - renderer.field_147853_m) + (double)f11 * (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147853_m) + (double)f8 * (1.0 - renderer.field_147855_j) * renderer.field_147853_m);
                j1 = renderer.func_147778_a(renderer.field_147831_S, renderer.field_147826_T, renderer.field_147868_aj, tempBrightness);
                k1 = renderer.func_147778_a(renderer.field_147868_aj, renderer.field_147880_aa, renderer.field_147881_ab, tempBrightness);
                l1 = renderer.func_147778_a(renderer.field_147883_ah, renderer.field_147836_Z, renderer.field_147880_aa, tempBrightness);
                i2 = renderer.func_147778_a(renderer.field_147832_R, renderer.field_147831_S, renderer.field_147883_ah, tempBrightness);
                renderer.field_147864_al = renderer.func_147727_a(k1, l1, i2, j1, renderer.field_147857_k * renderer.field_147853_m, renderer.field_147857_k * (1.0 - renderer.field_147853_m), (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147853_m), (1.0 - renderer.field_147857_k) * renderer.field_147853_m);
                renderer.field_147874_am = renderer.func_147727_a(k1, l1, i2, j1, renderer.field_147857_k * renderer.field_147851_l, renderer.field_147857_k * (1.0 - renderer.field_147851_l), (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147851_l), (1.0 - renderer.field_147857_k) * renderer.field_147851_l);
                renderer.field_147876_an = renderer.func_147727_a(k1, l1, i2, j1, renderer.field_147855_j * renderer.field_147851_l, renderer.field_147855_j * (1.0 - renderer.field_147851_l), (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147851_l), (1.0 - renderer.field_147855_j) * renderer.field_147851_l);
                renderer.field_147870_ao = renderer.func_147727_a(k1, l1, i2, j1, renderer.field_147855_j * renderer.field_147853_m, renderer.field_147855_j * (1.0 - renderer.field_147853_m), (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147853_m), (1.0 - renderer.field_147855_j) * renderer.field_147853_m);
            }
            if (isGrass) {
                renderer.field_147850_ar = renderer.field_147848_as = valR * 0.6f;
                renderer.field_147852_aq = renderer.field_147848_as;
                renderer.field_147872_ap = renderer.field_147848_as;
                renderer.field_147858_av = renderer.field_147856_aw = valG * 0.6f;
                renderer.field_147860_au = renderer.field_147856_aw;
                renderer.field_147846_at = renderer.field_147856_aw;
                renderer.field_147839_az = renderer.field_147833_aA = valB * 0.6f;
                renderer.field_147841_ay = renderer.field_147833_aA;
                renderer.field_147854_ax = renderer.field_147833_aA;
            } else {
                renderer.field_147848_as = 0.6f;
                renderer.field_147850_ar = 0.6f;
                renderer.field_147852_aq = 0.6f;
                renderer.field_147872_ap = 0.6f;
                renderer.field_147856_aw = 0.6f;
                renderer.field_147858_av = 0.6f;
                renderer.field_147860_au = 0.6f;
                renderer.field_147846_at = 0.6f;
                renderer.field_147833_aA = 0.6f;
                renderer.field_147839_az = 0.6f;
                renderer.field_147841_ay = 0.6f;
                renderer.field_147854_ax = 0.6f;
            }
            renderer.field_147872_ap *= colorTL;
            renderer.field_147846_at *= colorTL;
            renderer.field_147854_ax *= colorTL;
            renderer.field_147852_aq *= colorBL;
            renderer.field_147860_au *= colorBL;
            renderer.field_147841_ay *= colorBL;
            renderer.field_147850_ar *= colorBR;
            renderer.field_147858_av *= colorBR;
            renderer.field_147839_az *= colorBR;
            renderer.field_147848_as *= colorTR;
            renderer.field_147856_aw *= colorTR;
            renderer.field_147833_aA *= colorTR;
            this.renderFace(renderer, block, x, y, z, 4);
            rendered = true;
        }
        if (!this.faceSkip[5] && (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x + 1, y, z, 5))) {
            if (renderer.field_147861_i >= 1.0) {
                ++x;
            }
            renderer.field_147810_D = renderer.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I();
            renderer.field_147820_O = renderer.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I();
            renderer.field_147829_Q = renderer.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I();
            renderer.field_147824_K = renderer.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I();
            renderer.field_147835_X = block.func_149677_c(renderer.field_147845_a, x, y - 1, z);
            renderer.field_147866_ai = block.func_149677_c(renderer.field_147845_a, x, y, z - 1);
            renderer.field_147862_ak = block.func_149677_c(renderer.field_147845_a, x, y, z + 1);
            renderer.field_147885_ae = block.func_149677_c(renderer.field_147845_a, x, y + 1, z);
            flag2 = renderer.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149751_l();
            flag3 = renderer.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149751_l();
            flag4 = renderer.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149751_l();
            flag5 = renderer.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149751_l();
            if (!flag3 && !flag5) {
                renderer.field_147816_C = renderer.field_147820_O;
                renderer.field_147827_W = renderer.field_147866_ai;
            } else {
                renderer.field_147816_C = renderer.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149685_I();
                renderer.field_147827_W = block.func_149677_c(renderer.field_147845_a, x, y - 1, z - 1);
            }
            if (!flag3 && !flag4) {
                renderer.field_147811_E = renderer.field_147829_Q;
                renderer.field_147834_Y = renderer.field_147862_ak;
            } else {
                renderer.field_147811_E = renderer.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149685_I();
                renderer.field_147834_Y = block.func_149677_c(renderer.field_147845_a, x, y - 1, z + 1);
            }
            if (!flag2 && !flag5) {
                renderer.field_147823_J = renderer.field_147820_O;
                renderer.field_147879_ad = renderer.field_147866_ai;
            } else {
                renderer.field_147823_J = renderer.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149685_I();
                renderer.field_147879_ad = block.func_149677_c(renderer.field_147845_a, x, y + 1, z - 1);
            }
            if (!flag2 && !flag4) {
                renderer.field_147818_M = renderer.field_147829_Q;
                renderer.field_147882_ag = renderer.field_147862_ak;
            } else {
                renderer.field_147818_M = renderer.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149685_I();
                renderer.field_147882_ag = block.func_149677_c(renderer.field_147845_a, x, y + 1, z + 1);
            }
            if (renderer.field_147861_i >= 1.0) {
                --x;
            }
            tempBrightness = masterBrightness;
            if (renderer.field_147861_i >= 1.0 || !renderer.field_147845_a.func_147439_a(x + 1, y, z).func_149662_c()) {
                tempBrightness = block.func_149677_c(renderer.field_147845_a, x + 1, y, z);
            }
            aoLightValue = renderer.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I();
            if (fullBlock) {
                colorTL = (renderer.field_147810_D + renderer.field_147811_E + aoLightValue + renderer.field_147829_Q) / 4.0f;
                colorBL = (renderer.field_147816_C + renderer.field_147810_D + renderer.field_147820_O + aoLightValue) / 4.0f;
                colorBR = (renderer.field_147820_O + aoLightValue + renderer.field_147823_J + renderer.field_147824_K) / 4.0f;
                colorTR = (aoLightValue + renderer.field_147829_Q + renderer.field_147824_K + renderer.field_147818_M) / 4.0f;
                renderer.field_147864_al = renderer.func_147778_a(renderer.field_147835_X, renderer.field_147834_Y, renderer.field_147862_ak, tempBrightness);
                renderer.field_147870_ao = renderer.func_147778_a(renderer.field_147862_ak, renderer.field_147885_ae, renderer.field_147882_ag, tempBrightness);
                renderer.field_147876_an = renderer.func_147778_a(renderer.field_147866_ai, renderer.field_147879_ad, renderer.field_147885_ae, tempBrightness);
                renderer.field_147874_am = renderer.func_147778_a(renderer.field_147827_W, renderer.field_147835_X, renderer.field_147866_ai, tempBrightness);
            } else {
                f8 = (renderer.field_147810_D + renderer.field_147811_E + aoLightValue + renderer.field_147829_Q) / 4.0f;
                f9 = (renderer.field_147816_C + renderer.field_147810_D + renderer.field_147820_O + aoLightValue) / 4.0f;
                f10 = (renderer.field_147820_O + aoLightValue + renderer.field_147823_J + renderer.field_147824_K) / 4.0f;
                f11 = (aoLightValue + renderer.field_147829_Q + renderer.field_147824_K + renderer.field_147818_M) / 4.0f;
                colorTL = (float)((double)f8 * (1.0 - renderer.field_147855_j) * renderer.field_147853_m + (double)f9 * (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147853_m) + (double)f10 * renderer.field_147855_j * (1.0 - renderer.field_147853_m) + (double)f11 * renderer.field_147855_j * renderer.field_147853_m);
                colorBL = (float)((double)f8 * (1.0 - renderer.field_147855_j) * renderer.field_147851_l + (double)f9 * (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147851_l) + (double)f10 * renderer.field_147855_j * (1.0 - renderer.field_147851_l) + (double)f11 * renderer.field_147855_j * renderer.field_147851_l);
                colorBR = (float)((double)f8 * (1.0 - renderer.field_147857_k) * renderer.field_147851_l + (double)f9 * (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147851_l) + (double)f10 * renderer.field_147857_k * (1.0 - renderer.field_147851_l) + (double)f11 * renderer.field_147857_k * renderer.field_147851_l);
                colorTR = (float)((double)f8 * (1.0 - renderer.field_147857_k) * renderer.field_147853_m + (double)f9 * (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147853_m) + (double)f10 * renderer.field_147857_k * (1.0 - renderer.field_147853_m) + (double)f11 * renderer.field_147857_k * renderer.field_147853_m);
                j1 = renderer.func_147778_a(renderer.field_147835_X, renderer.field_147834_Y, renderer.field_147862_ak, tempBrightness);
                k1 = renderer.func_147778_a(renderer.field_147862_ak, renderer.field_147885_ae, renderer.field_147882_ag, tempBrightness);
                l1 = renderer.func_147778_a(renderer.field_147866_ai, renderer.field_147879_ad, renderer.field_147885_ae, tempBrightness);
                i2 = renderer.func_147778_a(renderer.field_147827_W, renderer.field_147835_X, renderer.field_147866_ai, tempBrightness);
                renderer.field_147864_al = renderer.func_147727_a(j1, i2, l1, k1, (1.0 - renderer.field_147855_j) * renderer.field_147853_m, (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147853_m), renderer.field_147855_j * (1.0 - renderer.field_147853_m), renderer.field_147855_j * renderer.field_147853_m);
                renderer.field_147874_am = renderer.func_147727_a(j1, i2, l1, k1, (1.0 - renderer.field_147855_j) * renderer.field_147851_l, (1.0 - renderer.field_147855_j) * (1.0 - renderer.field_147851_l), renderer.field_147855_j * (1.0 - renderer.field_147851_l), renderer.field_147855_j * renderer.field_147851_l);
                renderer.field_147876_an = renderer.func_147727_a(j1, i2, l1, k1, (1.0 - renderer.field_147857_k) * renderer.field_147851_l, (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147851_l), renderer.field_147857_k * (1.0 - renderer.field_147851_l), renderer.field_147857_k * renderer.field_147851_l);
                renderer.field_147870_ao = renderer.func_147727_a(j1, i2, l1, k1, (1.0 - renderer.field_147857_k) * renderer.field_147853_m, (1.0 - renderer.field_147857_k) * (1.0 - renderer.field_147853_m), renderer.field_147857_k * (1.0 - renderer.field_147853_m), renderer.field_147857_k * renderer.field_147853_m);
            }
            if (isGrass) {
                renderer.field_147850_ar = renderer.field_147848_as = valR * 0.6f;
                renderer.field_147852_aq = renderer.field_147848_as;
                renderer.field_147872_ap = renderer.field_147848_as;
                renderer.field_147858_av = renderer.field_147856_aw = valG * 0.6f;
                renderer.field_147860_au = renderer.field_147856_aw;
                renderer.field_147846_at = renderer.field_147856_aw;
                renderer.field_147839_az = renderer.field_147833_aA = valB * 0.6f;
                renderer.field_147841_ay = renderer.field_147833_aA;
                renderer.field_147854_ax = renderer.field_147833_aA;
            } else {
                renderer.field_147848_as = 0.6f;
                renderer.field_147850_ar = 0.6f;
                renderer.field_147852_aq = 0.6f;
                renderer.field_147872_ap = 0.6f;
                renderer.field_147856_aw = 0.6f;
                renderer.field_147858_av = 0.6f;
                renderer.field_147860_au = 0.6f;
                renderer.field_147846_at = 0.6f;
                renderer.field_147833_aA = 0.6f;
                renderer.field_147839_az = 0.6f;
                renderer.field_147841_ay = 0.6f;
                renderer.field_147854_ax = 0.6f;
            }
            renderer.field_147872_ap *= colorTL;
            renderer.field_147846_at *= colorTL;
            renderer.field_147854_ax *= colorTL;
            renderer.field_147852_aq *= colorBL;
            renderer.field_147860_au *= colorBL;
            renderer.field_147841_ay *= colorBL;
            renderer.field_147850_ar *= colorBR;
            renderer.field_147858_av *= colorBR;
            renderer.field_147839_az *= colorBR;
            renderer.field_147848_as *= colorTR;
            renderer.field_147856_aw *= colorTR;
            renderer.field_147833_aA *= colorTR;
            this.renderFace(renderer, block, x, y, z, 5);
            rendered = true;
        }
        renderer.field_147863_w = false;
        return rendered;
    }

    public boolean renderWithColorMultiplier(RenderBlocks renderer, Block block, int x, int y, int z, int color) {
        float valR = (float)(color >> 16 & 0xFF) / 255.0f;
        float valG = (float)(color >> 8 & 0xFF) / 255.0f;
        float valB = (float)(color & 0xFF) / 255.0f;
        return this.renderWithColorMultiplier(renderer, block, x, y, z, valR, valG, valB);
    }

    public boolean renderWithColorMultiplier(RenderBlocks renderer, Block block, int x, int y, int z, float valR, float valG, float valB) {
        renderer.field_147863_w = false;
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean rendered = false;
        float shade_b = 0.5f;
        float shade_t = 1.0f;
        float shade_ns = 0.8f;
        float shade_ew = 0.6f;
        int brightness = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (!this.faceSkip[0] && (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y - 1, z, 0))) {
            tessellator.func_78380_c(renderer.field_147855_j > 0.0 ? brightness : block.func_149677_c(renderer.field_147845_a, x, y - 1, z));
            tessellator.func_78386_a(shade_b * valR, shade_b * valG, shade_b * valB);
            this.renderFace(renderer, block, x, y, z, 0);
            rendered = true;
        }
        if (!this.faceSkip[1] && (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y + 1, z, 1))) {
            tessellator.func_78380_c(renderer.field_147857_k < 1.0 ? brightness : block.func_149677_c(renderer.field_147845_a, x, y + 1, z));
            tessellator.func_78386_a(shade_t * valR, shade_t * valG, shade_t * valB);
            this.renderFace(renderer, block, x, y, z, 1);
            rendered = true;
        }
        if (!this.faceSkip[2] && (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y, z - 1, 2))) {
            tessellator.func_78380_c(renderer.field_147851_l > 0.0 ? brightness : block.func_149677_c(renderer.field_147845_a, x, y, z - 1));
            tessellator.func_78386_a(shade_ns * valR, shade_ns * valG, shade_ns * valB);
            this.renderFace(renderer, block, x, y, z, 2);
            rendered = true;
        }
        if (!this.faceSkip[3] && (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y, z + 1, 3))) {
            tessellator.func_78380_c(renderer.field_147853_m < 1.0 ? brightness : block.func_149677_c(renderer.field_147845_a, x, y, z + 1));
            tessellator.func_78386_a(shade_ns * valR, shade_ns * valG, shade_ns * valB);
            this.renderFace(renderer, block, x, y, z, 3);
            rendered = true;
        }
        if (!this.faceSkip[4] && (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x - 1, y, z, 4))) {
            tessellator.func_78380_c(renderer.field_147859_h > 0.0 ? brightness : block.func_149677_c(renderer.field_147845_a, x - 1, y, z));
            tessellator.func_78386_a(shade_ew * valR, shade_ew * valG, shade_ew * valB);
            this.renderFace(renderer, block, x, y, z, 4);
            rendered = true;
        }
        if (!this.faceSkip[5] && (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x + 1, y, z, 5))) {
            tessellator.func_78380_c(renderer.field_147861_i < 1.0 ? brightness : block.func_149677_c(renderer.field_147845_a, x + 1, y, z));
            tessellator.func_78386_a(shade_ew * valR, shade_ew * valG, shade_ew * valB);
            this.renderFace(renderer, block, x, y, z, 5);
            rendered = true;
        }
        return rendered;
    }

    private void renderFace(RenderBlocks renderer, Block block, int x, int y, int z, int side) {
        double[] rZ;
        double[] rY;
        double[] rX;
        if (side < 0 || side > 5) {
            return;
        }
        IIcon icon = RenderExtra.isRendererDrawingBreakGraphic(renderer) ? renderer.func_147758_b(renderer.field_147840_d) : (this.iconIndex[side] != null ? renderer.func_147758_b(this.iconIndex[side]) : renderer.func_147793_a(block, renderer.field_147845_a, x, y, z, side));
        byte subIcon = this.subIcon[side];
        double rendererMinX = renderer.field_147859_h;
        double rendererMaxX = renderer.field_147861_i;
        double rendererMinY = renderer.field_147855_j;
        double rendererMaxY = renderer.field_147857_k;
        double rendererMinZ = renderer.field_147851_l;
        double rendererMaxZ = renderer.field_147853_m;
        double difX = (rendererMaxX - rendererMinX) / 2.0;
        double difY = (rendererMaxY - rendererMinY) / 2.0;
        double difZ = (rendererMaxZ - rendererMinZ) / 2.0;
        if (this.blockScaled) {
            rX = new double[]{(double)x + rendererMinX * (double)this.scalefactor + (double)((1.0f - this.scalefactor) / 2.0f), (double)x + rendererMaxX * (double)this.scalefactor + (double)((1.0f - this.scalefactor) / 2.0f)};
            rY = new double[]{(double)y + rendererMinY * (double)this.scalefactor + (double)((1.0f - this.scalefactor) / 2.0f), (double)y + rendererMaxY * (double)this.scalefactor + (double)((1.0f - this.scalefactor) / 2.0f)};
            rZ = new double[]{(double)z + rendererMinZ * (double)this.scalefactor + (double)((1.0f - this.scalefactor) / 2.0f), (double)z + rendererMaxZ * (double)this.scalefactor + (double)((1.0f - this.scalefactor) / 2.0f)};
        } else {
            rX = new double[]{(double)x + rendererMinX, (double)x + rendererMaxX};
            rY = new double[]{(double)y + rendererMinY, (double)y + rendererMaxY};
            rZ = new double[]{(double)z + rendererMinZ, (double)z + rendererMaxZ};
        }
        if (this.blockShifted) {
            rX[0] = rX[0] + (double)this.blockShift[0];
            rX[1] = rX[1] + (double)this.blockShift[0];
            rY[0] = rY[0] + (double)this.blockShift[1];
            rY[1] = rY[1] + (double)this.blockShift[1];
            rZ[0] = rZ[0] + (double)this.blockShift[2];
            rZ[1] = rZ[1] + (double)this.blockShift[2];
        }
        if (this.uvLock) {
            rendererMinZ = 0.0;
            rendererMinY = 0.0;
            rendererMinX = 0.0;
            rendererMaxZ = 1.0;
            rendererMaxY = 1.0;
            rendererMaxX = 1.0;
        }
        if (side == 0 || side == 1) {
            if (subIcon > 0 && subIcon < 5) {
                if (subIcon % 2 == 0) {
                    rendererMinX += difX;
                } else {
                    rendererMaxX -= difX;
                }
                if (subIcon > 2) {
                    rendererMinZ += difZ;
                } else {
                    rendererMaxZ -= difZ;
                }
            }
            if (side == 0) {
                this.renderBottom(renderer, icon, rendererMinX, rendererMaxX, rendererMinZ, rendererMaxZ, rX, rY[0], rZ);
            } else {
                this.renderTop(renderer, icon, rendererMinX, rendererMaxX, rendererMinZ, rendererMaxZ, rX, rY[1], rZ);
            }
        } else if (side == 2 || side == 3) {
            if (subIcon > 0 && subIcon < 5) {
                if (subIcon % 2 == 0) {
                    rendererMinX += difX;
                    rendererMinZ += difZ;
                } else {
                    rendererMaxX -= difX;
                    rendererMaxZ -= difZ;
                }
                if (subIcon > 2) {
                    rendererMinY += difY;
                } else {
                    rendererMaxY -= difY;
                }
            }
            if (side == 2) {
                this.renderNorth(renderer, icon, rendererMinX, rendererMaxX, rendererMinY, rendererMaxY, rX, rY, rZ[0]);
            } else {
                this.renderSouth(renderer, icon, rendererMinX, rendererMaxX, rendererMinY, rendererMaxY, rX, rY, rZ[1]);
            }
        } else if (side == 4 || side == 5) {
            if (subIcon > 0 && subIcon < 5) {
                if (subIcon % 2 == 0) {
                    rendererMinY += difY;
                } else {
                    rendererMaxY -= difY;
                }
                if (subIcon > 2) {
                    rendererMinZ += difZ;
                } else {
                    rendererMaxZ -= difZ;
                }
            }
            if (side == 4) {
                this.renderWest(renderer, icon, rendererMinY, rendererMaxY, rendererMinZ, rendererMaxZ, rX[0], rY, rZ);
            } else {
                this.renderEast(renderer, icon, rendererMinY, rendererMaxY, rendererMinZ, rendererMaxZ, rX[1], rY, rZ);
            }
        }
    }

    protected void renderBottom(RenderBlocks renderer, IIcon icon, double rendererMinX, double rendererMaxX, double rendererMinZ, double rendererMaxZ, double[] rX, double rY, double[] rZ) {
        double[][] cords = new double[4][5];
        double[] pt = new double[4];
        switch (this.uvRotateBottom) {
            default: {
                pt[0] = icon.func_94214_a(rendererMinX * 16.0);
                pt[1] = icon.func_94214_a(rendererMaxX * 16.0);
                pt[2] = icon.func_94207_b(rendererMinZ * 16.0);
                pt[3] = icon.func_94207_b(rendererMaxZ * 16.0);
                double x1 = !this.renderFromInside[0] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[0] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x1, rY, rZ[1], pt[0], pt[3]);
                cords[1] = this.buildCords(x1, rY, rZ[0], pt[0], pt[2]);
                cords[2] = this.buildCords(x2, rY, rZ[0], pt[1], pt[2]);
                cords[3] = this.buildCords(x2, rY, rZ[1], pt[1], pt[3]);
                break;
            }
            case 1: {
                pt[0] = icon.func_94214_a(16.0 - rendererMaxZ * 16.0);
                pt[1] = icon.func_94207_b(rendererMinX * 16.0);
                pt[2] = icon.func_94214_a(16.0 - rendererMinZ * 16.0);
                pt[3] = icon.func_94207_b(rendererMaxX * 16.0);
                double x1 = !this.renderFromInside[0] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[0] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x1, rY, rZ[1], pt[0], pt[1]);
                cords[1] = this.buildCords(x1, rY, rZ[0], pt[2], pt[1]);
                cords[2] = this.buildCords(x2, rY, rZ[0], pt[2], pt[3]);
                cords[3] = this.buildCords(x2, rY, rZ[1], pt[0], pt[3]);
                break;
            }
            case 2: {
                pt[0] = icon.func_94214_a(rendererMinZ * 16.0);
                pt[1] = icon.func_94207_b(16.0 - rendererMaxX * 16.0);
                pt[2] = icon.func_94214_a(rendererMaxZ * 16.0);
                pt[3] = icon.func_94207_b(16.0 - rendererMinX * 16.0);
                double x1 = !this.renderFromInside[0] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[0] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x1, rY, rZ[1], pt[2], pt[3]);
                cords[1] = this.buildCords(x1, rY, rZ[0], pt[0], pt[3]);
                cords[2] = this.buildCords(x2, rY, rZ[0], pt[0], pt[1]);
                cords[3] = this.buildCords(x2, rY, rZ[1], pt[2], pt[1]);
                break;
            }
            case 3: {
                pt[0] = icon.func_94214_a(16.0 - rendererMinX * 16.0);
                pt[1] = icon.func_94214_a(16.0 - rendererMaxX * 16.0);
                pt[2] = icon.func_94207_b(16.0 - rendererMinZ * 16.0);
                pt[3] = icon.func_94207_b(16.0 - rendererMaxZ * 16.0);
                double x1 = !this.renderFromInside[0] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[0] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x1, rY, rZ[1], pt[0], pt[3]);
                cords[1] = this.buildCords(x1, rY, rZ[0], pt[0], pt[2]);
                cords[2] = this.buildCords(x2, rY, rZ[0], pt[1], pt[2]);
                cords[3] = this.buildCords(x2, rY, rZ[1], pt[1], pt[3]);
            }
        }
        this.render(renderer, cords, this.uvFlipBottom, 0);
    }

    protected void renderTop(RenderBlocks renderer, IIcon icon, double rendererMinX, double rendererMaxX, double rendererMinZ, double rendererMaxZ, double[] rX, double rY, double[] rZ) {
        double[][] cords = new double[4][5];
        double[] pt = new double[4];
        switch (this.uvRotateTop) {
            default: {
                pt[0] = icon.func_94214_a(rendererMinX * 16.0);
                pt[1] = icon.func_94214_a(rendererMaxX * 16.0);
                pt[2] = icon.func_94207_b(rendererMinZ * 16.0);
                pt[3] = icon.func_94207_b(rendererMaxZ * 16.0);
                double x1 = !this.renderFromInside[1] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[1] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x2, rY, rZ[1], pt[1], pt[3]);
                cords[1] = this.buildCords(x2, rY, rZ[0], pt[1], pt[2]);
                cords[2] = this.buildCords(x1, rY, rZ[0], pt[0], pt[2]);
                cords[3] = this.buildCords(x1, rY, rZ[1], pt[0], pt[3]);
                break;
            }
            case 1: {
                pt[0] = icon.func_94214_a(rendererMinZ * 16.0);
                pt[1] = icon.func_94207_b(16.0 - rendererMaxX * 16.0);
                pt[2] = icon.func_94214_a(rendererMaxZ * 16.0);
                pt[3] = icon.func_94207_b(16.0 - rendererMinX * 16.0);
                double x1 = !this.renderFromInside[1] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[1] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x2, rY, rZ[1], pt[2], pt[1]);
                cords[1] = this.buildCords(x2, rY, rZ[0], pt[0], pt[1]);
                cords[2] = this.buildCords(x1, rY, rZ[0], pt[0], pt[3]);
                cords[3] = this.buildCords(x1, rY, rZ[1], pt[2], pt[3]);
                break;
            }
            case 2: {
                pt[0] = icon.func_94214_a(16.0 - rendererMaxZ * 16.0);
                pt[1] = icon.func_94207_b(rendererMinX * 16.0);
                pt[2] = icon.func_94214_a(16.0 - rendererMinZ * 16.0);
                pt[3] = icon.func_94207_b(rendererMaxX * 16.0);
                double x1 = !this.renderFromInside[1] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[1] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x2, rY, rZ[1], pt[0], pt[3]);
                cords[1] = this.buildCords(x2, rY, rZ[0], pt[2], pt[3]);
                cords[2] = this.buildCords(x1, rY, rZ[0], pt[2], pt[1]);
                cords[3] = this.buildCords(x1, rY, rZ[1], pt[0], pt[1]);
                break;
            }
            case 3: {
                pt[0] = icon.func_94214_a(16.0 - rendererMinX * 16.0);
                pt[1] = icon.func_94214_a(16.0 - rendererMaxX * 16.0);
                pt[2] = icon.func_94207_b(16.0 - rendererMinZ * 16.0);
                pt[3] = icon.func_94207_b(16.0 - rendererMaxZ * 16.0);
                double x1 = !this.renderFromInside[1] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[1] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x2, rY, rZ[1], pt[1], pt[3]);
                cords[1] = this.buildCords(x2, rY, rZ[0], pt[1], pt[2]);
                cords[2] = this.buildCords(x1, rY, rZ[0], pt[0], pt[2]);
                cords[3] = this.buildCords(x1, rY, rZ[1], pt[0], pt[3]);
            }
        }
        this.render(renderer, cords, this.uvFlipTop, 1);
    }

    protected void renderNorth(RenderBlocks renderer, IIcon icon, double rendererMinX, double rendererMaxX, double rendererMinY, double rendererMaxY, double[] rX, double[] rY, double rZ) {
        double[][] cords = new double[4][5];
        double[] pt = new double[4];
        switch (this.uvRotateNorth) {
            default: {
                pt[0] = !renderer.field_152631_f ? (double)icon.func_94214_a(rendererMinX * 16.0) : (double)icon.func_94214_a((1.0 - rendererMaxX) * 16.0);
                pt[1] = !renderer.field_152631_f ? (double)icon.func_94214_a(rendererMaxX * 16.0) : (double)icon.func_94214_a((1.0 - rendererMinX) * 16.0);
                pt[2] = icon.func_94207_b(16.0 - rendererMaxY * 16.0);
                pt[3] = icon.func_94207_b(16.0 - rendererMinY * 16.0);
                double x1 = !this.renderFromInside[2] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[2] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x1, rY[1], rZ, pt[1], pt[2]);
                cords[1] = this.buildCords(x2, rY[1], rZ, pt[0], pt[2]);
                cords[2] = this.buildCords(x2, rY[0], rZ, pt[0], pt[3]);
                cords[3] = this.buildCords(x1, rY[0], rZ, pt[1], pt[3]);
                break;
            }
            case 1: {
                pt[0] = icon.func_94214_a(16.0 - rendererMaxY * 16.0);
                pt[1] = icon.func_94214_a(16.0 - rendererMinY * 16.0);
                pt[2] = icon.func_94207_b(rendererMaxX * 16.0);
                pt[3] = icon.func_94207_b(rendererMinX * 16.0);
                double x1 = !this.renderFromInside[2] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[2] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x1, rY[1], rZ, pt[1], pt[3]);
                cords[1] = this.buildCords(x2, rY[1], rZ, pt[1], pt[2]);
                cords[2] = this.buildCords(x2, rY[0], rZ, pt[0], pt[2]);
                cords[3] = this.buildCords(x1, rY[0], rZ, pt[0], pt[3]);
                break;
            }
            case 2: {
                pt[0] = icon.func_94214_a(rendererMinY * 16.0);
                pt[1] = icon.func_94214_a(rendererMaxY * 16.0);
                pt[2] = icon.func_94207_b(16.0 - rendererMinX * 16.0);
                pt[3] = icon.func_94207_b(16.0 - rendererMaxX * 16.0);
                double x1 = !this.renderFromInside[2] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[2] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x1, rY[1], rZ, pt[0], pt[2]);
                cords[1] = this.buildCords(x2, rY[1], rZ, pt[0], pt[3]);
                cords[2] = this.buildCords(x2, rY[0], rZ, pt[1], pt[3]);
                cords[3] = this.buildCords(x1, rY[0], rZ, pt[1], pt[2]);
                break;
            }
            case 3: {
                pt[0] = icon.func_94214_a(16.0 - rendererMinX * 16.0);
                pt[1] = icon.func_94214_a(16.0 - rendererMaxX * 16.0);
                pt[2] = icon.func_94207_b(rendererMaxY * 16.0);
                pt[3] = icon.func_94207_b(rendererMinY * 16.0);
                double x1 = !this.renderFromInside[2] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[2] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x1, rY[1], rZ, pt[1], pt[2]);
                cords[1] = this.buildCords(x2, rY[1], rZ, pt[0], pt[2]);
                cords[2] = this.buildCords(x2, rY[0], rZ, pt[0], pt[3]);
                cords[3] = this.buildCords(x1, rY[0], rZ, pt[1], pt[3]);
            }
        }
        this.render(renderer, cords, this.uvFlipNorth, 2);
    }

    protected void renderSouth(RenderBlocks renderer, IIcon icon, double rendererMinX, double rendererMaxX, double rendererMinY, double rendererMaxY, double[] rX, double[] rY, double rZ) {
        double[][] cords = new double[4][5];
        double[] pt = new double[4];
        switch (this.uvRotateSouth) {
            default: {
                pt[0] = icon.func_94214_a(rendererMinX * 16.0);
                pt[1] = icon.func_94214_a(rendererMaxX * 16.0);
                pt[2] = icon.func_94207_b(16.0 - rendererMaxY * 16.0);
                pt[3] = icon.func_94207_b(16.0 - rendererMinY * 16.0);
                double x1 = !this.renderFromInside[3] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[3] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x1, rY[1], rZ, pt[0], pt[2]);
                cords[1] = this.buildCords(x1, rY[0], rZ, pt[0], pt[3]);
                cords[2] = this.buildCords(x2, rY[0], rZ, pt[1], pt[3]);
                cords[3] = this.buildCords(x2, rY[1], rZ, pt[1], pt[2]);
                break;
            }
            case 1: {
                pt[0] = icon.func_94214_a(rendererMinY * 16.0);
                pt[1] = icon.func_94207_b(16.0 - rendererMinX * 16.0);
                pt[2] = icon.func_94214_a(rendererMaxY * 16.0);
                pt[3] = icon.func_94207_b(16.0 - rendererMaxX * 16.0);
                double x1 = !this.renderFromInside[3] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[3] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x1, rY[1], rZ, pt[0], pt[1]);
                cords[1] = this.buildCords(x1, rY[0], rZ, pt[2], pt[1]);
                cords[2] = this.buildCords(x2, rY[0], rZ, pt[2], pt[3]);
                cords[3] = this.buildCords(x2, rY[1], rZ, pt[0], pt[3]);
                break;
            }
            case 2: {
                pt[0] = icon.func_94214_a(16.0 - rendererMaxY * 16.0);
                pt[1] = icon.func_94207_b(rendererMinX * 16.0);
                pt[2] = icon.func_94214_a(16.0 - rendererMinY * 16.0);
                pt[3] = icon.func_94207_b(rendererMaxX * 16.0);
                double x1 = !this.renderFromInside[3] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[3] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x1, rY[1], rZ, pt[2], pt[1]);
                cords[1] = this.buildCords(x1, rY[0], rZ, pt[0], pt[1]);
                cords[2] = this.buildCords(x2, rY[0], rZ, pt[0], pt[3]);
                cords[3] = this.buildCords(x2, rY[1], rZ, pt[2], pt[3]);
                break;
            }
            case 3: {
                pt[0] = icon.func_94214_a(16.0 - rendererMinX * 16.0);
                pt[1] = icon.func_94214_a(16.0 - rendererMaxX * 16.0);
                pt[2] = icon.func_94207_b(rendererMaxY * 16.0);
                pt[3] = icon.func_94207_b(rendererMinY * 16.0);
                double x1 = !this.renderFromInside[3] ? rX[0] : rX[1];
                double x2 = !this.renderFromInside[3] ? rX[1] : rX[0];
                cords[0] = this.buildCords(x1, rY[1], rZ, pt[0], pt[2]);
                cords[1] = this.buildCords(x1, rY[0], rZ, pt[0], pt[3]);
                cords[2] = this.buildCords(x2, rY[0], rZ, pt[1], pt[3]);
                cords[3] = this.buildCords(x2, rY[1], rZ, pt[1], pt[2]);
            }
        }
        this.render(renderer, cords, this.uvFlipSouth, 3);
    }

    protected void renderWest(RenderBlocks renderer, IIcon icon, double rendererMinY, double rendererMaxY, double rendererMinZ, double rendererMaxZ, double rX, double[] rY, double[] rZ) {
        double[][] cords = new double[4][5];
        double[] pt = new double[4];
        switch (this.uvRotateWest) {
            default: {
                pt[0] = icon.func_94214_a(rendererMinZ * 16.0);
                pt[1] = icon.func_94214_a(rendererMaxZ * 16.0);
                pt[2] = icon.func_94207_b(16.0 - rendererMaxY * 16.0);
                pt[3] = icon.func_94207_b(16.0 - rendererMinY * 16.0);
                double z1 = !this.renderFromInside[4] ? rZ[0] : rZ[1];
                double z2 = !this.renderFromInside[4] ? rZ[1] : rZ[0];
                cords[0] = this.buildCords(rX, rY[1], z2, pt[1], pt[2]);
                cords[1] = this.buildCords(rX, rY[1], z1, pt[0], pt[2]);
                cords[2] = this.buildCords(rX, rY[0], z1, pt[0], pt[3]);
                cords[3] = this.buildCords(rX, rY[0], z2, pt[1], pt[3]);
                break;
            }
            case 1: {
                pt[0] = icon.func_94214_a(rendererMinY * 16.0);
                pt[1] = icon.func_94207_b(16.0 - rendererMaxZ * 16.0);
                pt[2] = icon.func_94214_a(rendererMaxY * 16.0);
                pt[3] = icon.func_94207_b(16.0 - rendererMinZ * 16.0);
                double z1 = !this.renderFromInside[4] ? rZ[0] : rZ[1];
                double z2 = !this.renderFromInside[4] ? rZ[1] : rZ[0];
                cords[0] = this.buildCords(rX, rY[1], z2, pt[0], pt[1]);
                cords[1] = this.buildCords(rX, rY[1], z1, pt[0], pt[3]);
                cords[2] = this.buildCords(rX, rY[0], z1, pt[2], pt[3]);
                cords[3] = this.buildCords(rX, rY[0], z2, pt[2], pt[1]);
                break;
            }
            case 2: {
                pt[0] = icon.func_94214_a(16.0 - rendererMaxY * 16.0);
                pt[1] = icon.func_94207_b(rendererMinZ * 16.0);
                pt[2] = icon.func_94214_a(16.0 - rendererMinY * 16.0);
                pt[3] = icon.func_94207_b(rendererMaxZ * 16.0);
                double z1 = !this.renderFromInside[4] ? rZ[0] : rZ[1];
                double z2 = !this.renderFromInside[4] ? rZ[1] : rZ[0];
                cords[0] = this.buildCords(rX, rY[1], z2, pt[2], pt[3]);
                cords[1] = this.buildCords(rX, rY[1], z1, pt[2], pt[1]);
                cords[2] = this.buildCords(rX, rY[0], z1, pt[0], pt[1]);
                cords[3] = this.buildCords(rX, rY[0], z2, pt[0], pt[3]);
                break;
            }
            case 3: {
                pt[0] = icon.func_94214_a(16.0 - rendererMinZ * 16.0);
                pt[1] = icon.func_94214_a(16.0 - rendererMaxZ * 16.0);
                pt[2] = icon.func_94207_b(rendererMaxY * 16.0);
                pt[3] = icon.func_94207_b(rendererMinY * 16.0);
                double z1 = !this.renderFromInside[4] ? rZ[0] : rZ[1];
                double z2 = !this.renderFromInside[4] ? rZ[1] : rZ[0];
                cords[0] = this.buildCords(rX, rY[1], z2, pt[1], pt[2]);
                cords[1] = this.buildCords(rX, rY[1], z1, pt[0], pt[2]);
                cords[2] = this.buildCords(rX, rY[0], z1, pt[0], pt[3]);
                cords[3] = this.buildCords(rX, rY[0], z2, pt[1], pt[3]);
            }
        }
        this.render(renderer, cords, this.uvFlipWest, 4);
    }

    protected void renderEast(RenderBlocks renderer, IIcon icon, double rendererMinY, double rendererMaxY, double rendererMinZ, double rendererMaxZ, double rX, double[] rY, double[] rZ) {
        double[][] cords = new double[4][5];
        double[] pt = new double[4];
        switch (this.uvRotateEast) {
            default: {
                pt[0] = !renderer.field_152631_f ? (double)icon.func_94214_a(rendererMinZ * 16.0) : (double)icon.func_94214_a((1.0 - rendererMaxZ) * 16.0);
                pt[1] = !renderer.field_152631_f ? (double)icon.func_94214_a(rendererMaxZ * 16.0) : (double)icon.func_94214_a((1.0 - rendererMinZ) * 16.0);
                pt[2] = icon.func_94207_b(16.0 - rendererMaxY * 16.0);
                pt[3] = icon.func_94207_b(16.0 - rendererMinY * 16.0);
                double z1 = !this.renderFromInside[5] ? rZ[0] : rZ[1];
                double z2 = !this.renderFromInside[5] ? rZ[1] : rZ[0];
                cords[0] = this.buildCords(rX, rY[0], z2, pt[0], pt[3]);
                cords[1] = this.buildCords(rX, rY[0], z1, pt[1], pt[3]);
                cords[2] = this.buildCords(rX, rY[1], z1, pt[1], pt[2]);
                cords[3] = this.buildCords(rX, rY[1], z2, pt[0], pt[2]);
                break;
            }
            case 1: {
                pt[0] = icon.func_94214_a(16.0 - rendererMaxY * 16.0);
                pt[1] = icon.func_94207_b(rendererMaxZ * 16.0);
                pt[2] = icon.func_94214_a(16.0 - rendererMinY * 16.0);
                pt[3] = icon.func_94207_b(rendererMinZ * 16.0);
                double z1 = !this.renderFromInside[5] ? rZ[0] : rZ[1];
                double z2 = !this.renderFromInside[5] ? rZ[1] : rZ[0];
                cords[0] = this.buildCords(rX, rY[0], z2, pt[0], pt[1]);
                cords[1] = this.buildCords(rX, rY[0], z1, pt[0], pt[3]);
                cords[2] = this.buildCords(rX, rY[1], z1, pt[2], pt[3]);
                cords[3] = this.buildCords(rX, rY[1], z2, pt[2], pt[1]);
                break;
            }
            case 2: {
                pt[0] = icon.func_94214_a(rendererMinY * 16.0);
                pt[1] = icon.func_94207_b(16.0 - rendererMinZ * 16.0);
                pt[2] = icon.func_94214_a(rendererMaxY * 16.0);
                pt[3] = icon.func_94207_b(16.0 - rendererMaxZ * 16.0);
                double z1 = !this.renderFromInside[5] ? rZ[0] : rZ[1];
                double z2 = !this.renderFromInside[5] ? rZ[1] : rZ[0];
                cords[0] = this.buildCords(rX, rY[0], z2, pt[2], pt[3]);
                cords[1] = this.buildCords(rX, rY[0], z1, pt[2], pt[1]);
                cords[2] = this.buildCords(rX, rY[1], z1, pt[0], pt[1]);
                cords[3] = this.buildCords(rX, rY[1], z2, pt[0], pt[3]);
                break;
            }
            case 3: {
                pt[0] = icon.func_94214_a(16.0 - rendererMinZ * 16.0);
                pt[1] = icon.func_94214_a(16.0 - rendererMaxZ * 16.0);
                pt[2] = icon.func_94207_b(rendererMaxY * 16.0);
                pt[3] = icon.func_94207_b(rendererMinY * 16.0);
                double z1 = !this.renderFromInside[5] ? rZ[0] : rZ[1];
                double z2 = !this.renderFromInside[5] ? rZ[1] : rZ[0];
                cords[0] = this.buildCords(rX, rY[0], z2, pt[0], pt[3]);
                cords[1] = this.buildCords(rX, rY[0], z1, pt[1], pt[3]);
                cords[2] = this.buildCords(rX, rY[1], z1, pt[1], pt[2]);
                cords[3] = this.buildCords(rX, rY[1], z2, pt[0], pt[2]);
            }
        }
        this.render(renderer, cords, this.uvFlipEast, 5);
    }

    private double[] buildCords(double x, double y, double z, double u, double v) {
        double[] cords = new double[]{x, y, z, u, v};
        return cords;
    }

    private void render(RenderBlocks renderer, double[][] cords, boolean flipTexture, int side) {
        if (flipTexture) {
            double tempcord = cords[0][3];
            cords[0][3] = cords[2][3];
            cords[2][3] = tempcord;
            tempcord = cords[1][3];
            cords[1][3] = cords[3][3];
            cords[3][3] = tempcord;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78372_c(this.faceShift[side][0], this.faceShift[side][1], this.faceShift[side][2]);
        if (renderer.field_147863_w) {
            tessellator.func_78386_a(renderer.field_147872_ap, renderer.field_147846_at, renderer.field_147854_ax);
            tessellator.func_78380_c(renderer.field_147864_al);
            tessellator.func_78374_a(cords[0][0], cords[0][1], cords[0][2], cords[0][3], cords[0][4]);
            tessellator.func_78386_a(renderer.field_147852_aq, renderer.field_147860_au, renderer.field_147841_ay);
            tessellator.func_78380_c(renderer.field_147874_am);
            tessellator.func_78374_a(cords[1][0], cords[1][1], cords[1][2], cords[1][3], cords[1][4]);
            tessellator.func_78386_a(renderer.field_147850_ar, renderer.field_147858_av, renderer.field_147839_az);
            tessellator.func_78380_c(renderer.field_147876_an);
            tessellator.func_78374_a(cords[2][0], cords[2][1], cords[2][2], cords[2][3], cords[2][4]);
            tessellator.func_78386_a(renderer.field_147848_as, renderer.field_147856_aw, renderer.field_147833_aA);
            tessellator.func_78380_c(renderer.field_147870_ao);
            tessellator.func_78374_a(cords[3][0], cords[3][1], cords[3][2], cords[3][3], cords[3][4]);
        } else {
            tessellator.func_78374_a(cords[0][0], cords[0][1], cords[0][2], cords[0][3], cords[0][4]);
            tessellator.func_78374_a(cords[1][0], cords[1][1], cords[1][2], cords[1][3], cords[1][4]);
            tessellator.func_78374_a(cords[2][0], cords[2][1], cords[2][2], cords[2][3], cords[2][4]);
            tessellator.func_78374_a(cords[3][0], cords[3][1], cords[3][2], cords[3][3], cords[3][4]);
        }
        tessellator.func_78372_c(-this.faceShift[side][0], -this.faceShift[side][1], -this.faceShift[side][2]);
    }

    public static void drawFaces(Block block, int metadata, RenderBlocks renderBlocks) {
        RenderExtra.drawFaces(block, metadata, renderBlocks, 0);
    }

    public static void drawFaces(Block block, int metadata, RenderBlocks renderBlocks, int bottom) {
        IIcon[] icons = new IIcon[6];
        icons[0] = block.func_149691_a(bottom, metadata);
        for (int face = 1; face < 6; face = (int)((byte)(face + 1))) {
            icons[face] = block.func_149691_a(face, metadata);
        }
        RenderExtra.drawFaces(block, icons, renderBlocks);
    }

    public static void drawFaces(Block block, IIcon icon, RenderBlocks renderBlocks) {
        RenderExtra.drawFaces(block, icon, renderBlocks, new boolean[]{false, false, false, false, false, false});
    }

    public static void drawFaces(Block block, IIcon icon, RenderBlocks renderBlocks, boolean[] skip) {
        IIcon[] icons = new IIcon[6];
        for (int face = 0; face < 6; face = (int)((byte)(face + 1))) {
            icons[face] = icon;
        }
        RenderExtra.drawFaces(block, icons, renderBlocks, skip);
    }

    public static void drawFaces(Block block, IIcon[] icons, RenderBlocks renderBlocks) {
        RenderExtra.drawFaces(block, icons, renderBlocks, new boolean[]{false, false, false, false, false, false});
    }

    public static void drawFaces(Block block, IIcon[] icons, RenderBlocks renderBlocks, boolean[] skip) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (!skip[0]) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderBlocks.func_147768_a(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(icons[0]));
            tessellator.func_78381_a();
        }
        if (!skip[1]) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderBlocks.func_147806_b(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(icons[1]));
            tessellator.func_78381_a();
        }
        if (!skip[2]) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderBlocks.field_147842_e = true;
            renderBlocks.func_147764_f(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(icons[2]));
            tessellator.func_78381_a();
        }
        if (!skip[3]) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderBlocks.field_147842_e = false;
            renderBlocks.func_147798_e(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(icons[3]));
            tessellator.func_78381_a();
        }
        if (!skip[4]) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderBlocks.field_147842_e = true;
            renderBlocks.func_147761_c(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(icons[4]));
            tessellator.func_78381_a();
        }
        if (!skip[5]) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderBlocks.field_147842_e = false;
            renderBlocks.func_147734_d(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(icons[5]));
            tessellator.func_78381_a();
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

