/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import shetiphian.core.common.Function;

public abstract class SoundHandler {
    private Minecraft mc = FMLClientHandler.instance().getClient();

    @SubscribeEvent
    public void playSound(PlaySoundEvent17 event) {
        if (event.category == SoundCategory.BLOCKS || event.category == SoundCategory.ANIMALS || event.category == null) {
            ISound sound = event.sound;
            event.result = this.onPlaySound(sound, event.name, sound.func_147653_e(), sound.func_147655_f(), sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
        }
    }

    protected abstract ISound onPlaySpecialSound(ISound var1, String var2, float var3, float var4, int var5, int var6, int var7);

    protected abstract ISound onPlayPlaceBreakSound(ISound var1, String var2, float var3, float var4, int var5, int var6, int var7, Block var8, byte var9);

    protected abstract ISound onPlayWalkFallSound(ISound var1, String var2, float var3, float var4, int var5, int var6, int var7, Block var8, byte var9);

    private ISound onPlaySound(ISound sound, String name, float volume, float pitch, float sx, float sy, float sz) {
        byte metadata;
        Block block;
        ISound newSound;
        ISound newSound2;
        int[] blockXZ = Function.getBlockXZ(sx, sz);
        int x = blockXZ[0];
        int z = blockXZ[1];
        int y = (int)sy;
        if (sy - (float)y > 0.0f) {
            ++y;
        }
        if (!name.startsWith("dig") && !name.startsWith("step") && sound != (newSound2 = this.onPlaySpecialSound(sound, name, volume, pitch, x, y, z))) {
            return newSound2;
        }
        if (name.startsWith("dig")) {
            if (this.mc.field_71441_e.func_147439_a(x, y, z) instanceof BlockAir) {
                --y;
            }
            if (sound != (newSound = this.onPlayPlaceBreakSound(sound, name, volume, pitch, x, y, z, block = this.mc.field_71441_e.func_147439_a(x, y, z), metadata = (byte)this.mc.field_71441_e.func_72805_g(x, y, z)))) {
                return newSound;
            }
        }
        if (name.startsWith("step") && sound != (newSound = this.onPlayWalkFallSound(sound, name, volume, pitch, x, y, z, block = this.mc.field_71441_e.func_147439_a(x, y - 1, z), metadata = (byte)this.mc.field_71441_e.func_72805_g(x, y - 1, z)))) {
            return newSound;
        }
        return sound;
    }

    protected ISound getBreakSound(Block.SoundType sound, float volume, float pitch, float x, float y, float z) {
        return this.getSound(sound.func_150495_a(), (sound.func_150497_c() + volume) / 2.0f, (sound.func_150494_d() + pitch) / 2.0f, x, y, z);
    }

    protected ISound getStepSound(Block.SoundType sound, float volume, float pitch, float x, float y, float z) {
        return this.getSound(sound.func_150498_e(), (sound.func_150497_c() + volume) / 2.0f, (sound.func_150494_d() + pitch) / 2.0f, x, y, z);
    }

    protected ISound getSound(String name, float volume, float pitch, float x, float y, float z) {
        return new PositionedSoundRecord(new ResourceLocation(name), volume, pitch, x, y, z);
    }
}

