/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Logger;

public class RecipeHelper {
    private final Logger errorLog;

    public RecipeHelper(Logger logger) {
        this.errorLog = logger;
    }

    public void addShapelessOreRecipe(ItemStack result, Object ... recipe) {
        try {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(result, recipe));
        }
        catch (Exception error) {
            this.errorLog.error("Invalid ShapelessOreRecipe: Error Returned = " + error);
        }
    }

    public void addShapedOreRecipe(ItemStack result, Object ... recipe) {
        try {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(result, recipe));
        }
        catch (Exception error) {
            this.errorLog.error("Invalid ShapedOreRecipe: Error Returned = " + error);
        }
    }

    public void addShapelessRecipe(ItemStack result, Object ... recipe) {
        try {
            GameRegistry.addShapelessRecipe((ItemStack)result, (Object[])recipe);
        }
        catch (Exception error) {
            this.errorLog.error("Invalid ShapelessRecipe: Error Returned = " + error);
        }
    }

    public void addShapedRecipe(ItemStack result, Object ... recipe) {
        try {
            GameRegistry.addRecipe((ItemStack)result, (Object[])recipe);
        }
        catch (Exception error) {
            this.errorLog.error("Invalid ShapedRecipe: Error Returned = " + error);
        }
    }

    public void addSmelting(ItemStack result, ItemStack input, float experience) {
        if (result != null && input != null) {
            FurnaceRecipes.func_77602_a().func_151394_a(input, result, experience);
        } else {
            this.errorLog.error("Invalid FurnaceRecipe: " + input + " > " + result);
        }
    }

    public void remove(ItemStack findItem, int recipeSize, boolean isShapeless, boolean isShaped) {
        ArrayList recipes = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        for (int scan = 0; scan < recipes.size(); ++scan) {
            ItemStack recipeResult;
            IRecipe iRecipe = (IRecipe)recipes.get(scan);
            if (iRecipe == null || recipeSize > 0 && iRecipe.func_77570_a() != recipeSize || (recipeResult = iRecipe.func_77571_b()) == null) continue;
            if ((iRecipe instanceof ShapedRecipes || iRecipe instanceof ShapedOreRecipe) && isShaped && ItemStack.func_77989_b((ItemStack)findItem, (ItemStack)recipeResult)) {
                this.errorLog.info("Removed Shaped Recipe: " + recipes.get(scan) + " -> " + recipeResult);
                recipes.remove(scan);
            }
            if (!(iRecipe instanceof ShapelessRecipes) && !(iRecipe instanceof ShapelessOreRecipe) || !isShapeless || !ItemStack.func_77989_b((ItemStack)findItem, (ItemStack)recipeResult)) continue;
            this.errorLog.info("Removed Shapeless Recipe: " + recipes.get(scan) + " -> " + recipeResult);
            recipes.remove(scan);
        }
    }
}

