/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.io.File;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class SPConfig
extends Configuration {
    public SPConfig(File file) {
        super(file);
    }

    public SPConfig(File file, String configVersion) {
        super(file, configVersion);
    }

    public String getString(String name, String category, String defaultValue, String comment, String langKey, Pattern pattern) {
        Property prop = this.get(category, name, defaultValue);
        prop.setLanguageKey(langKey);
        prop.setValidationPattern(pattern);
        prop.comment = comment;
        return prop.getString();
    }

    public String getString(String name, String category, String defaultValue, String comment, String[] validValues, String langKey) {
        Property prop = this.get(category, name, defaultValue);
        prop.setValidValues(validValues);
        prop.setLanguageKey(langKey);
        prop.comment = comment;
        return prop.getString();
    }

    public String[] getStringList(String name, String category, String[] defaultValue, String comment, String[] validValues, String langKey) {
        Property prop = this.get(category, name, defaultValue);
        prop.setLanguageKey(langKey);
        prop.setValidValues(validValues);
        prop.comment = comment;
        return prop.getStringList();
    }

    public boolean getBoolean(String name, String category, boolean defaultValue, String comment, String langKey) {
        Property prop = this.get(category, name, defaultValue);
        prop.setLanguageKey(langKey);
        prop.comment = comment;
        return prop.getBoolean(defaultValue);
    }

    public int getInt(String name, String category, int defaultValue, int minValue, int maxValue, String comment, String langKey) {
        Property prop = this.get(category, name, defaultValue);
        prop.setLanguageKey(langKey);
        prop.comment = comment + "\n[range: " + minValue + " to " + maxValue + "]";
        prop.setMinValue(minValue);
        prop.setMaxValue(maxValue);
        return prop.getInt(defaultValue) < minValue ? minValue : (prop.getInt(defaultValue) > maxValue ? maxValue : prop.getInt(defaultValue));
    }

    public float getFloat(String name, String category, float defaultValue, float minValue, float maxValue, String comment, String langKey) {
        Property prop = this.get(category, name, Float.toString(defaultValue), name);
        prop.setLanguageKey(langKey);
        prop.comment = comment + "\n[range: " + minValue + " to " + maxValue + "]";
        prop.setMinValue((double)minValue);
        prop.setMaxValue((double)maxValue);
        try {
            return Float.parseFloat(prop.getString()) < minValue ? minValue : (Float.parseFloat(prop.getString()) > maxValue ? maxValue : Float.parseFloat(prop.getString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }
}

