/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.molecule;

import minechem.item.molecule.MoleculeEnum;
import minechem.item.molecule.MoleculeItem;
import minechem.render.RenderingUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class MoleculeItemRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case ENTITY_BOBBING: 
            case ENTITY_ROTATION: {
                return true;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemstack, Object ... data) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        MoleculeItem item = (MoleculeItem)itemstack.func_77973_b();
        IIcon testtube = itemstack.func_77954_c();
        switch (type) {
            case INVENTORY: {
                this.renderItemInInventory(type, itemstack, item.filledMolecule, item.render_pass1, item.render_pass2);
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                this.renderItemInEquipped(type, itemstack, testtube, item.render_pass1, item.render_pass2);
                break;
            }
            case ENTITY: {
                EntityItem entityItem = (EntityItem)data[1];
                if (entityItem.field_70170_p == null) {
                    float angle = (float)(Minecraft.func_71386_F() % 8000L) / 8000.0f * 360.0f;
                    GL11.glPushMatrix();
                    GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.2f, (float)-0.5f, (float)0.0f);
                    this.renderItemAsEntity(type, itemstack, testtube, item.render_pass1, item.render_pass2);
                    GL11.glPopMatrix();
                    break;
                }
                this.renderItemAsEntity(type, itemstack, testtube, item.render_pass1, item.render_pass2);
                break;
            }
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2896);
    }

    private void renderItemInInventory(IItemRenderer.ItemRenderType type, ItemStack itemstack, IIcon testtube, IIcon pass1, IIcon pass2) {
        MoleculeEnum molecule = MoleculeItem.getMolecule(itemstack);
        GL11.glColor3f((float)molecule.red, (float)molecule.green, (float)molecule.blue);
        RenderingUtil.drawTexturedRectUV(type, 0.0f, 0.0f, 5.0f, 16.0f, 16.0f, pass1);
        GL11.glColor3f((float)molecule.red2, (float)molecule.green2, (float)molecule.blue2);
        RenderingUtil.drawTexturedRectUV(type, 0.0f, 0.0f, 5.0f, 16.0f, 16.0f, pass2);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderingUtil.drawTexturedRectUV(type, 0.0f, 0.0f, 5.0f, 16.0f, 16.0f, testtube);
    }

    private void renderItemInEquipped(IItemRenderer.ItemRenderType type, ItemStack itemstack, IIcon testtube, IIcon pass1, IIcon pass2) {
        MoleculeEnum molecule = MoleculeItem.getMolecule(itemstack);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor3f((float)molecule.red, (float)molecule.green, (float)molecule.blue);
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)pass1.func_94212_f(), (float)pass1.func_94206_g(), (float)pass1.func_94209_e(), (float)pass1.func_94210_h(), (int)pass1.func_94211_a(), (int)pass1.func_94216_b(), (float)0.0625f);
        GL11.glColor3f((float)molecule.red2, (float)molecule.green2, (float)molecule.blue2);
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)pass2.func_94212_f(), (float)pass2.func_94206_g(), (float)pass2.func_94209_e(), (float)pass2.func_94210_h(), (int)pass2.func_94211_a(), (int)pass2.func_94216_b(), (float)0.0625f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)testtube.func_94212_f(), (float)testtube.func_94206_g(), (float)testtube.func_94209_e(), (float)testtube.func_94210_h(), (int)testtube.func_94211_a(), (int)testtube.func_94216_b(), (float)0.0625f);
    }

    private void renderItemAsEntity(IItemRenderer.ItemRenderType type, ItemStack itemstack, IIcon testtube, IIcon pass1, IIcon pass2) {
        MoleculeEnum molecule = MoleculeItem.getMolecule(itemstack);
        GL11.glPushMatrix();
        GL11.glColor3f((float)molecule.red, (float)molecule.green, (float)molecule.blue);
        RenderingUtil.drawTextureIn3D(pass1);
        GL11.glColor3f((float)molecule.red2, (float)molecule.green2, (float)molecule.blue2);
        RenderingUtil.drawTextureIn3D(pass2);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderingUtil.drawTextureIn3D(testtube);
        GL11.glPopMatrix();
    }
}

