/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.polytool;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import minechem.item.element.ElementEnum;
import minechem.item.polytool.PolytoolItem;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.tileentity.decomposer.DecomposerRecipeHandler;
import minechem.utils.MinechemUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class PolytoolEventHandler {
    private static final Random random = new Random();

    public void addDrops(LivingDropsEvent event, ItemStack dropStack) {
        EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
        entityitem.field_145804_b = 10;
        event.drops.add(entityitem);
    }

    @SubscribeEvent
    public void onDrop(LivingDropsEvent event) {
        if ("player".equals(event.source.field_76373_n)) {
            EntityItem entityItem2;
            float powerSilicon;
            EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
            ItemStack stack = player.func_71045_bC();
            if (stack != null && stack.func_77973_b() instanceof PolytoolItem && (powerSilicon = PolytoolItem.getPowerOfType(stack, ElementEnum.Si)) > 0.0f) {
                int amount = (int)Math.ceil(random.nextDouble() * (double)powerSilicon);
                Iterator iter = event.drops.iterator();
                if ((float)random.nextInt(16) < 1.0f + powerSilicon) {
                    ArrayList<EntityItem> trueResult = new ArrayList<EntityItem>();
                    block0: while (iter.hasNext()) {
                        entityItem2 = (EntityItem)iter.next();
                        ItemStack item = entityItem2.func_92059_d();
                        while (item.field_77994_a > 0) {
                            DecomposerRecipe recipe = DecomposerRecipeHandler.instance.getRecipe(item);
                            if (recipe != null) {
                                ArrayList<ItemStack> items = MinechemUtil.convertChemicalsIntoItemStacks(recipe.getOutput());
                                for (ItemStack itemStack : items) {
                                    trueResult.add(new EntityItem(entityItem2.field_70170_p, entityItem2.field_70165_t, entityItem2.field_70163_u, entityItem2.field_70161_v, itemStack));
                                }
                            } else {
                                trueResult.add(entityItem2);
                                continue block0;
                            }
                            --item.field_77994_a;
                        }
                    }
                    event.drops.clear();
                    event.drops.addAll(trueResult);
                }
            }
            if (event.entityLiving instanceof EntitySkeleton || event.entityLiving instanceof EntityZombie || event.entityLiving instanceof EntityPlayer) {
                EntityLivingBase enemy = event.entityLiving;
                if (stack != null && stack.func_77973_b() instanceof PolytoolItem) {
                    float power;
                    if (enemy instanceof EntityZombie && (power = PolytoolItem.getPowerOfType(stack, ElementEnum.N)) > 0.0f) {
                        int amount = (int)Math.ceil(random.nextDouble() * (double)power);
                        this.addDrops(event, new ItemStack(Items.field_151083_be, amount, 0));
                        Iterator iter = event.drops.iterator();
                        while (iter.hasNext()) {
                            entityItem2 = (EntityItem)iter.next();
                            if (entityItem2.func_92059_d().func_77973_b() != Items.field_151078_bh) continue;
                            iter.remove();
                        }
                    }
                    if (enemy instanceof EntitySkeleton && (power = PolytoolItem.getPowerOfType(stack, ElementEnum.Ca)) > 0.0f) {
                        int amount = (int)Math.ceil(random.nextDouble() * (double)power);
                        for (EntityItem entityItem2 : event.drops) {
                            if (entityItem2.func_92059_d().func_77973_b() != Items.field_151103_aS) continue;
                            entityItem2.func_92059_d().field_77994_a += amount;
                        }
                    }
                    for (float beheading = PolytoolItem.getPowerOfType(stack, ElementEnum.Be); beheading > 5.0f; beheading -= 1.0f) {
                        if (!(beheading > 0.0f) || !((float)random.nextInt(5) < beheading * 10.0f)) continue;
                        if (event.entityLiving instanceof EntitySkeleton) {
                            EntitySkeleton skeleton = (EntitySkeleton)enemy;
                            this.addDrops(event, new ItemStack(Items.field_151144_bL, 1, skeleton.func_82202_m()));
                            continue;
                        }
                        if (event.entityLiving instanceof EntityZombie) {
                            this.addDrops(event, new ItemStack(Items.field_151144_bL, 1, 2));
                            continue;
                        }
                        if (!(event.entityLiving instanceof EntityPlayer)) continue;
                        ItemStack dropStack = new ItemStack(Items.field_151144_bL, 1, 3);
                        NBTTagCompound nametag = new NBTTagCompound();
                        nametag.func_74778_a("SkullOwner", player.getDisplayName());
                        this.addDrops(event, dropStack);
                    }
                }
            }
        }
    }
}

