/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.polytool.types;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import minechem.item.element.ElementEnum;
import minechem.item.polytool.PolytoolItem;
import minechem.item.polytool.PolytoolUpgradeType;
import minechem.utils.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class PolytoolTypeIron
extends PolytoolUpgradeType {
    private static Map<String, Boolean> ores = new LinkedHashMap<String, Boolean>();

    public static void getOres() {
        for (String ore : OreDictionary.getOreNames()) {
            if (!ore.regionMatches(0, "ore", 0, 3)) continue;
            for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                ores.put(PolytoolTypeIron.blockHash(stack), true);
            }
        }
    }

    private static String blockHash(ItemStack stack) {
        return PolytoolTypeIron.blockHash(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j());
    }

    private static String blockHash(Block block, int meta) {
        return block.func_149739_a() + "@" + meta;
    }

    @Override
    public void onBlockDestroyed(ItemStack itemStack, World world, Block id, int x1, int y1, int z1, EntityLivingBase entityLiving) {
        if (!world.field_72995_K && entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            ArrayList<CoordTuple> queue = new ArrayList<CoordTuple>(100);
            float carbon = 0.0f;
            for (PolytoolUpgradeType upgrade : PolytoolItem.getUpgrades(itemStack)) {
                if (upgrade.getElement() != ElementEnum.C) continue;
                carbon = upgrade.power;
            }
            int meta = world.func_72805_g(x1, y1, z1);
            if (ores.containsKey(PolytoolTypeIron.blockHash(id, meta))) {
                int toMine = (int)this.power;
                queue.add(new CoordTuple(x1, y1, z1));
                while (!queue.isEmpty()) {
                    CoordTuple coord = (CoordTuple)queue.remove(0);
                    int x = coord.x;
                    int y = coord.y;
                    int z = coord.z;
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        if (world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != id || world.func_72805_g(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != meta) continue;
                        this.breakExtraBlock(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, player, id, meta, carbon);
                        queue.add(new CoordTuple(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ));
                        if (--toMine > 0) continue;
                        return;
                    }
                }
            }
        }
    }

    @Override
    public ElementEnum getElement() {
        return ElementEnum.Fe;
    }

    @Override
    public String getDescription() {
        return "Mines deposits of ores";
    }

    protected void breakExtraBlock(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, float carbon) {
        if (player.field_71075_bZ.field_75098_d) {
            block.func_149681_a(world, x, y, z, meta, player);
            world.func_147468_f(x, y, z);
            if (!world.field_72995_K) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            }
            return;
        }
        if (!world.field_72995_K) {
            int bonus = block == Blocks.field_150482_ag || block == Blocks.field_150365_q ? (int)(world.field_73012_v.nextDouble() * Math.log(carbon)) + 1 : 1;
            block.func_149681_a(world, x, y, z, meta, player);
            if (block.removedByPlayer(world, player, x, y, z, true)) {
                for (int i = 0; i < bonus; ++i) {
                    block.func_149636_a(world, player, x, y, z, meta);
                }
            }
            EntityPlayerMP mpPlayer = (EntityPlayerMP)player;
            mpPlayer.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        }
    }
}

