/*
 * Decompiled with CFR 0.152.
 */
package minechem.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import minechem.potion.PotionChemical;
import minechem.reference.Resources;
import minechem.tileentity.decomposer.DecomposerGui;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.tileentity.decomposer.DecomposerRecipeChance;
import minechem.tileentity.decomposer.DecomposerRecipeHandler;
import minechem.tileentity.decomposer.DecomposerRecipeSelect;
import minechem.tileentity.decomposer.DecomposerRecipeSuper;
import minechem.utils.Compare;
import minechem.utils.LogHelper;
import minechem.utils.MinechemUtil;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class DecomposerNEIRecipeHandler
extends TemplateRecipeHandler {
    private static final String MINECHEM_DECOMPOSER_RECIPES_ID = "minechem.decomposer";
    private static final int INPUT_X_OFS = 75;
    private static final int INPUT_Y_OFS = 5;
    private static final int OUTPUT_X_OFS = 5;
    private static final int OUTPUT_Y_SCALE = 18;
    private static final int OUTPUT_Y_OFS = 51;
    private static final int INPUT_ARROW_Y_OFS = 20;

    public String getRecipeName() {
        return MinechemUtil.getLocalString("gui.title.decomposer");
    }

    public String getGuiTexture() {
        return Resources.Gui.NEI_DECOMPOSER.toString();
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)131);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 20, 16, 30), MINECHEM_DECOMPOSER_RECIPES_ID, new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(MINECHEM_DECOMPOSER_RECIPES_ID)) {
            for (DecomposerRecipe dr : DecomposerRecipe.recipes.values()) {
                ItemStack input = dr.getInput().func_77946_l();
                if (input.func_77973_b() == null) continue;
                if (input.func_77960_j() == Short.MAX_VALUE) {
                    input.func_77964_b(0);
                }
                LogHelper.debug(input.func_82833_r());
                this.registerDecomposerRecipe(dr);
            }
            this.arecipes = this.sortList(this.arecipes);
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (!Compare.isStackAChemical(result)) {
            return;
        }
        PotionChemical resultChemical = MinechemUtil.itemStackToChemical(result);
        if (resultChemical == null) {
            return;
        }
        for (DecomposerRecipe dr : DecomposerRecipe.recipes.values()) {
            if (!dr.outputContains(resultChemical)) continue;
            this.registerDecomposerRecipe(dr);
        }
        this.arecipes = this.sortList(this.arecipes);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        DecomposerRecipe dr = DecomposerRecipeHandler.instance.getRecipe(ingredient);
        if (dr != null) {
            this.registerDecomposerRecipe(dr);
        }
        this.arecipes = this.sortList(this.arecipes);
    }

    public Class getGuiClass() {
        return DecomposerGui.class;
    }

    public void registerDecomposerRecipe(DecomposerRecipe dr) {
        if (dr != null && dr.hasOutput()) {
            BaseCachedDecomposerRecipe cdr = this.buildCachedRecipe(dr);
            this.arecipes.add(cdr);
        }
    }

    private ArrayList<TemplateRecipeHandler.CachedRecipe> sortList(ArrayList<TemplateRecipeHandler.CachedRecipe> list) {
        ArrayList<BaseCachedDecomposerRecipe> drList = new ArrayList<BaseCachedDecomposerRecipe>();
        for (TemplateRecipeHandler.CachedRecipe cachedRecipe : list) {
            drList.add((BaseCachedDecomposerRecipe)cachedRecipe);
        }
        Collections.sort(drList);
        list.clear();
        for (BaseCachedDecomposerRecipe baseCachedDecomposerRecipe : drList) {
            list.add(baseCachedDecomposerRecipe);
        }
        return list;
    }

    public void drawExtras(int recipeIdx) {
        BaseCachedDecomposerRecipe cdr = (BaseCachedDecomposerRecipe)this.arecipes.get(recipeIdx);
        float chance = cdr.getChance();
        if (chance < 1.0f) {
            String format = chance > 0.09f ? "%2.0f%%" : "%.3f%%";
            String chanceStr = String.format(format, (double)chance * 100.0);
            int xPos = 75 - minechem.gui.GuiDraw.getStringWidth(chanceStr) - 5;
            minechem.gui.GuiDraw.drawString(chanceStr, xPos, 30, 8, false);
        }
        cdr.cycleOutput(this.cycleticks);
    }

    private BaseCachedDecomposerRecipe buildCachedRecipe(DecomposerRecipe dr) {
        if (dr instanceof DecomposerRecipeSelect) {
            return new CachedDecomposerRecipeSelect((DecomposerRecipeSelect)dr);
        }
        if (dr instanceof DecomposerRecipeChance) {
            return new CachedDecomposerRecipeChance((DecomposerRecipeChance)dr);
        }
        if (dr instanceof DecomposerRecipeSuper) {
            return new CachedDecomposerRecipeSuper((DecomposerRecipeSuper)dr);
        }
        return new CachedDecomposerRecipe(dr);
    }

    public class CachedDecomposerRecipeSuper
    extends CachedDecomposerRecipe {
        private long cycleAtTick;
        private float chance;
        private DecomposerRecipeSuper decomposerRecipeSuper;

        public CachedDecomposerRecipeSuper(DecomposerRecipeSuper dr) {
            super(dr);
            this.cycleAtTick = -1L;
            this.decomposerRecipeSuper = dr;
            this.chance = dr.getChance();
        }

        @Override
        public void cycleOutput(long tick) {
            if (this.cycleAtTick == -1L) {
                this.cycleAtTick = tick + 20L;
            }
            if (tick >= this.cycleAtTick) {
                ArrayList<ItemStack> outputsToShow;
                this.cycleAtTick = tick + 20L;
                while ((outputsToShow = MinechemUtil.convertChemicalsIntoItemStacks(this.decomposerRecipeSuper.getOutput())) == null || outputsToShow.isEmpty()) {
                }
                this.setOutputs(outputsToShow);
            }
        }
    }

    public class CachedDecomposerRecipeSelect
    extends CachedDecomposerRecipeChance {
        private int numOutputSets;
        private int outputSetToShow;
        private long cycleAtTick;
        private DecomposerRecipeSelect decomposerRecipeSelect;

        public CachedDecomposerRecipeSelect(DecomposerRecipeSelect dr) {
            super(dr);
            this.numOutputSets = dr.getAllPossibleRecipes().size();
            this.outputSetToShow = -1;
            this.decomposerRecipeSelect = dr;
            this.cycleAtTick = 0L;
        }

        @Override
        public void cycleOutput(long tick) {
            if (this.outputSetToShow == -1) {
                this.cycleAtTick = tick + 20L;
                this.outputSetToShow = 0;
                return;
            }
            if (tick >= this.cycleAtTick) {
                this.cycleAtTick = tick + 20L;
                ++this.outputSetToShow;
                if (this.outputSetToShow >= this.numOutputSets) {
                    this.outputSetToShow = 0;
                }
                ArrayList<DecomposerRecipe> possibleRecipes = this.decomposerRecipeSelect.getAllPossibleRecipes();
                ArrayList<ItemStack> outputsToShow = MinechemUtil.convertChemicalsIntoItemStacks(possibleRecipes.get(this.outputSetToShow).getOutputRaw());
                this.setOutputs(outputsToShow);
            }
        }
    }

    public class CachedDecomposerRecipeChance
    extends CachedDecomposerRecipe {
        private float chance;

        public CachedDecomposerRecipeChance(DecomposerRecipeChance dr) {
            super(dr);
            this.chance = dr.getChance();
        }

        @Override
        public float getChance() {
            return this.chance;
        }
    }

    public class CachedDecomposerRecipe
    extends BaseCachedDecomposerRecipe {
        public CachedDecomposerRecipe(DecomposerRecipe dr) {
            super(dr.getInput());
            ArrayList<ItemStack> outputs = dr instanceof DecomposerRecipeSuper ? MinechemUtil.convertChemicalsIntoItemStacks(dr.getOutput()) : MinechemUtil.convertChemicalsIntoItemStacks(dr.getOutputRaw());
            this.setOutputs(outputs);
        }
    }

    public abstract class BaseCachedDecomposerRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements Comparable {
        protected PositionedStack input;
        protected PositionedStack output1;
        protected List<PositionedStack> otherOutputs;

        protected BaseCachedDecomposerRecipe(ItemStack input) {
            super((TemplateRecipeHandler)DecomposerNEIRecipeHandler.this);
            this.otherOutputs = new ArrayList<PositionedStack>();
            this.input = new PositionedStack((Object)input, 75, 5);
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output1;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.otherOutputs;
        }

        public int compareTo(Object o) {
            if (o instanceof BaseCachedDecomposerRecipe) {
                BaseCachedDecomposerRecipe recipe = (BaseCachedDecomposerRecipe)o;
                if (recipe instanceof CachedDecomposerRecipeSuper && !(this instanceof CachedDecomposerRecipeSuper)) {
                    return -1;
                }
                if (!(recipe instanceof CachedDecomposerRecipeSuper) && this instanceof CachedDecomposerRecipeSuper) {
                    return 1;
                }
                if (recipe.getOtherStacks().size() < this.getOtherStacks().size()) {
                    return 1;
                }
                if (recipe.getOtherStacks().size() > this.getOtherStacks().size()) {
                    return -1;
                }
                int countThis = 0;
                if (this.getResult() != null) {
                    countThis += this.getResult().item.field_77994_a;
                }
                for (PositionedStack stack : this.getOtherStacks()) {
                    countThis += stack.item.field_77994_a;
                }
                int countOther = 0;
                if (this.getResult() != null) {
                    countOther += this.getResult().item.field_77994_a;
                }
                for (PositionedStack stack : recipe.getOtherStacks()) {
                    countOther += stack.item.field_77994_a;
                }
                if (countOther < countThis) {
                    return 1;
                }
                if (countOther > countThis) {
                    return -1;
                }
            }
            return 0;
        }

        public float getChance() {
            return 1.0f;
        }

        public void cycleOutput(long tick) {
        }

        protected void setOutputs(List<ItemStack> outputs) {
            if (outputs != null && !outputs.isEmpty()) {
                outputs = MinechemUtil.pushTogetherStacks(outputs);
                int digits = MinechemUtil.getNumberOfDigits(outputs.get((int)0).field_77994_a);
                int digitOffset = digits > 3 ? (digits - 3) * 5 : 0;
                int x = 5 + digitOffset;
                this.output1 = new PositionedStack((Object)outputs.get(0), x, 51);
                this.otherOutputs = new ArrayList<PositionedStack>();
                if (outputs.size() > 1) {
                    int row = 0;
                    for (int idx = 1; idx < outputs.size(); ++idx) {
                        ItemStack o = outputs.get(idx);
                        digits = MinechemUtil.getNumberOfDigits(o.field_77994_a);
                        int n = digitOffset = digits > 3 ? (digits - 3) * 5 : 0;
                        if ((x += digitOffset + 18 + 5) > 147) {
                            x = 5 + digitOffset;
                            ++row;
                        }
                        int y = 51 + row * 18;
                        this.otherOutputs.add(new PositionedStack((Object)o, x, y));
                    }
                }
            }
        }
    }
}

