/*
 * Decompiled with CFR 0.152.
 */
package minechem.network.message;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import minechem.item.blueprint.MinechemBlueprint;
import minechem.tileentity.multiblock.ghostblock.GhostBlockTileEntity;
import net.minecraft.tileentity.TileEntity;

public class GhostBlockMessage
implements IMessage,
IMessageHandler<GhostBlockMessage, IMessage> {
    private int posX;
    private int posY;
    private int posZ;
    private int blueprintID;
    private int ghostblockID;

    public GhostBlockMessage() {
    }

    public GhostBlockMessage(GhostBlockTileEntity tile) {
        this.posX = tile.field_145851_c;
        this.posY = tile.field_145848_d;
        this.posZ = tile.field_145849_e;
        this.blueprintID = tile.getBlueprint().id;
        this.ghostblockID = tile.getBlockID();
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readInt();
        this.posY = buf.readInt();
        this.posZ = buf.readInt();
        this.blueprintID = buf.readInt();
        this.ghostblockID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        buf.writeInt(this.blueprintID);
        buf.writeInt(this.ghostblockID);
    }

    public IMessage onMessage(GhostBlockMessage message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.posX, message.posY, message.posZ);
        if (tileEntity instanceof GhostBlockTileEntity) {
            ((GhostBlockTileEntity)tileEntity).setBlueprintAndID(MinechemBlueprint.blueprints.get(message.blueprintID), message.ghostblockID);
        }
        return null;
    }
}

