/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.decomposer;

import java.util.ArrayList;
import java.util.Iterator;
import minechem.potion.PotionChemical;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.tileentity.decomposer.DecomposerRecipeChance;
import net.minecraft.item.ItemStack;

public class DecomposerRecipeSelect
extends DecomposerRecipeChance {
    ArrayList<DecomposerRecipe> possibleRecipes = new ArrayList();

    public DecomposerRecipeSelect(ItemStack input, float chance, DecomposerRecipe ... possibleRecipes) {
        super(input, chance, new PotionChemical[0]);
        for (DecomposerRecipe recipe : possibleRecipes) {
            this.possibleRecipes.add(recipe);
        }
    }

    @Override
    public ArrayList<PotionChemical> getOutput() {
        if (random.nextFloat() < this.chance) {
            DecomposerRecipe selectedRecipe = this.possibleRecipes.get(random.nextInt(this.possibleRecipes.size()));
            return selectedRecipe.getOutput();
        }
        return null;
    }

    @Override
    public ArrayList<PotionChemical> getOutputRaw() {
        return this.possibleRecipes.get(0).getOutputRaw();
    }

    public DecomposerRecipe getRecipeRaw() {
        return this.possibleRecipes.get(0);
    }

    public ArrayList<DecomposerRecipe> getAllPossibleRecipes() {
        return this.possibleRecipes;
    }

    @Override
    public boolean isNull() {
        return super.isNull() && this.possibleRecipes == null;
    }

    @Override
    public boolean hasOutput() {
        return !this.possibleRecipes.isEmpty();
    }

    @Override
    public boolean outputContains(PotionChemical potionChemical) {
        DecomposerRecipe dr;
        boolean contains = false;
        Iterator<DecomposerRecipe> i$ = this.possibleRecipes.iterator();
        while (i$.hasNext() && !(contains = (dr = i$.next()).outputContains(potionChemical))) {
        }
        return contains;
    }
}

