/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import minechem.utils.MinechemUtil;

public class TimeHelper {
    public static String getTimeFromTicks(long ticks) {
        if (ticks < 0L) {
            return MinechemUtil.getLocalString("minechem.unstable", true);
        }
        String timeLeft = "";
        String hourabbr = MinechemUtil.getLocalString("minechem.hour.abbr", true);
        String minabbr = MinechemUtil.getLocalString("minechem.min.abbr", true);
        String secabbr = MinechemUtil.getLocalString("minechem.sec.abbr", true);
        if (ticks < 1728000L) {
            int hrs = (int)(ticks / 72000L);
            ticks -= (long)(72000 * hrs);
            if (hrs > 0) {
                timeLeft = hourabbr.isEmpty() || hourabbr.equals("minechem.hour.abbr") ? hrs + "hr " : hrs + hourabbr + " ";
            }
        }
        if (ticks < 72000L) {
            int mins = (int)(ticks / 1200L);
            ticks -= (long)(1200 * mins);
            if (mins > 0) {
                timeLeft = minabbr.isEmpty() || minabbr.equals("minechem.min.abbr") ? timeLeft + mins + "m" : timeLeft + mins + minabbr;
            }
        }
        if (ticks < 1200L) {
            int secs = (int)(ticks / 20L);
            ticks -= (long)(20 * secs);
            if (secs > 0) {
                if (!timeLeft.equals("")) {
                    timeLeft = timeLeft + " ";
                }
                timeLeft = secabbr.isEmpty() || secabbr.equals("minechem.sec.abbr") ? timeLeft + secs + "s" : timeLeft + secs + secabbr;
            }
        }
        return timeLeft;
    }
}

