/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.configuration;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import portablejim.veinminer.configuration.ConfigurationValues;
import portablejim.veinminer.configuration.Tool;
import portablejim.veinminer.configuration.ToolType;
import portablejim.veinminer.configuration.json.ToolStruct;
import portablejim.veinminer.util.BlockID;

public class ConfigurationSettings {
    private ConfigurationValues configValues;
    private boolean[] autoDetectBlocksToggle;
    private HashSet<String>[] autoDetectBlocksList;
    private ArrayList<Set<BlockID>> blockCongruenceList;
    private HashMap<BlockID, Integer> blockCongruenceMap;
    private int blockLimit;
    private int radiusLimit;
    private int blocksPerTick;
    private boolean enableAllBlocks;
    private boolean enableAllTools;
    private int preferredMode;
    private Map<String, Tool> toolsAndBlocks;
    private int hungerModifier;
    private int experienceModifier;

    public ConfigurationSettings(ConfigurationValues configValues) {
        this.configValues = configValues;
        this.autoDetectBlocksToggle = new boolean[ToolType.values().length];
        this.autoDetectBlocksList = new HashSet[ToolType.values().length];
        for (ToolType tool : ToolType.values()) {
            this.autoDetectBlocksToggle[tool.ordinal()] = false;
            this.autoDetectBlocksList[tool.ordinal()] = new HashSet();
        }
        this.blockCongruenceList = new ArrayList();
        this.blockCongruenceMap = new HashMap();
        this.toolsAndBlocks = new HashMap<String, Tool>();
        this.parseConfigValues();
    }

    private void parseConfigValues() {
        try {
            JsonObject toolsJson = this.configValues.toolsAndBlocks.getAsJsonObject().getAsJsonObject("tools");
            for (Map.Entry entry : toolsJson.entrySet()) {
                String toolName = (String)entry.getKey();
                Gson gson = new Gson();
                ToolStruct toolInstance = (ToolStruct)gson.fromJson((JsonElement)((JsonElement)entry.getValue()).getAsJsonObject(), ToolStruct.class);
                if (toolInstance.name == null) {
                    toolInstance.name = toolName;
                }
                if (toolInstance.icon == null) {
                    toolInstance.icon = "";
                }
                if (toolInstance.blocklist == null) {
                    toolInstance.blocklist = new String[0];
                }
                if (toolInstance.toollist == null) {
                    toolInstance.toollist = new String[0];
                }
                this.toolsAndBlocks.put(toolName, new Tool(toolInstance));
            }
        }
        catch (Exception toolsJson) {
            // empty catch block
        }
        boolean defaultsAdded = false;
        for (String defaultTool : this.configValues.defaultTools.keySet()) {
            if (this.toolsAndBlocks.containsKey(defaultTool)) continue;
            this.toolsAndBlocks.put(defaultTool, this.configValues.defaultTools.get(defaultTool));
            defaultsAdded = true;
        }
        for (Iterator<String> iterator : ToolType.values()) {
            this.setAutodetectBlocksToggle((ToolType)((Object)iterator), this.configValues.toolConfig.get(iterator).autodetectToggle.value);
            this.setAutodetectBlocksList((ToolType)((Object)iterator), this.configValues.toolConfig.get(iterator).autodetectList.value);
        }
        this.setBlockLimit(this.configValues.BLOCK_LIMIT);
        this.setBlocksPerTick(this.configValues.BLOCKS_PER_TICK);
        this.setRadiusLimit(this.configValues.RADIUS_LIMIT);
        this.setBlockCongruenceList(this.configValues.BLOCK_EQUIVALENCY_LIST);
        this.setHungerModifier(this.configValues.HUNGER_MULTIPLIER);
        this.setExperienceModifier(this.configValues.EXPERIENCE_MULTIPLIER);
        this.setEnableAllBlocks(this.configValues.ENABLE_ALL_BLOCKS);
        this.setEnableAllTools(this.configValues.ENABLE_ALL_TOOLS);
        this.setPreferredMode(this.configValues.CLIENT_PREFERRED_MODE, "pressed");
        if (defaultsAdded) {
            this.saveConfigs();
        }
    }

    public void reloadConfigFile() {
        this.configValues.loadConfigFile();
        this.parseConfigValues();
        this.saveConfigs();
    }

    public boolean getEnableAllBlocks() {
        return this.enableAllBlocks;
    }

    void setEnableAllBlocks(boolean enableAllBlocks) {
        this.enableAllBlocks = enableAllBlocks;
    }

    public boolean getEnableAllTools() {
        return this.enableAllTools;
    }

    void setEnableAllTools(boolean enableAllTools) {
        this.enableAllTools = enableAllTools;
    }

    void setAutodetectBlocksToggle(ToolType tool, boolean value) {
        this.autoDetectBlocksToggle[tool.ordinal()] = value;
    }

    public boolean getAutodetectBlocksToggle(ToolType tool) {
        return this.autoDetectBlocksToggle[tool.ordinal()];
    }

    void setAutodetectBlocksList(ToolType tool, String list) {
        String[] parts;
        for (String part : parts = list.split(",")) {
            if (part.isEmpty()) continue;
            this.autoDetectBlocksList[tool.ordinal()].add(part);
        }
    }

    public Set<String> getAutodetectBlocksList(ToolType tool) {
        return this.autoDetectBlocksList[tool.ordinal()];
    }

    public void addToolType(String newType, String name, String icon) {
        if (!newType.isEmpty() && !this.toolsAndBlocks.containsKey(newType)) {
            Tool newTool = new Tool(name, icon, new String[0], new String[0]);
            this.toolsAndBlocks.put(newType, newTool);
        }
    }

    public void addBlockToWhitelist(String tool, BlockID block) {
        if (!block.name.isEmpty()) {
            BlockID testBlock = new BlockID(block.name, -1);
            if (!this.toolsAndBlocks.get((Object)tool).blocklist.contains(block) && !this.toolsAndBlocks.get((Object)tool).blocklist.contains(testBlock)) {
                block.metadata = block.metadata == Short.MAX_VALUE ? -1 : block.metadata;
                this.toolsAndBlocks.put(tool, this.toolsAndBlocks.get(tool).addBlock(block));
            }
        }
    }

    public void removeBlockFromWhitelist(String tool, BlockID block) {
        BlockID blockNoMeta = new BlockID(block.name, block.metadata);
        blockNoMeta.metadata = -1;
        if (this.toolsAndBlocks.get((Object)tool).blocklist.contains(block)) {
            this.toolsAndBlocks.put(tool, this.toolsAndBlocks.get(tool).removeBlock(block));
        } else if (this.toolsAndBlocks.get((Object)tool).blocklist.contains(blockNoMeta)) {
            this.toolsAndBlocks.put(tool, this.toolsAndBlocks.get(tool).removeBlock(blockNoMeta));
        }
    }

    public ArrayList<String> getBlockIDArray(String toolType) {
        ArrayList<String> output = new ArrayList<String>();
        for (BlockID blockID : this.toolsAndBlocks.get((Object)toolType).blocklist) {
            output.add(blockID.toString());
        }
        return output;
    }

    public boolean whiteListHasBlockId(String tool, BlockID targetBlock) {
        BlockID targetBlockNoMeta = new BlockID(targetBlock.name, targetBlock.metadata);
        targetBlockNoMeta.metadata = -1;
        return this.toolsAndBlocks.get((Object)tool).blocklist.contains(targetBlock) || this.toolsAndBlocks.get((Object)tool).blocklist.contains(targetBlockNoMeta);
    }

    public void addCongruentBlocks(String existingBlock, String newBlock) {
        this.setBlockCongruenceList(String.format("%s=%s", existingBlock, newBlock));
    }

    void setBlockCongruenceList(String congruenceList) {
        String[] blocksString;
        for (String congruentBlocks : blocksString = congruenceList.split(",")) {
            int newId = this.blockCongruenceList.size();
            HashSet<BlockID> newCongruentBlocks = new HashSet<BlockID>();
            if (!congruentBlocks.contains("=")) continue;
            for (String blockString : congruentBlocks.split("=")) {
                BlockID newBlockId = new BlockID(blockString);
                newCongruentBlocks.add(newBlockId);
                if (this.blockCongruenceMap.containsKey(newBlockId)) {
                    newId = this.blockCongruenceMap.get(newBlockId);
                }
                this.blockCongruenceMap.put(newBlockId, newId);
            }
            newCongruentBlocks.addAll(newCongruentBlocks);
            if (newId < this.blockCongruenceList.size()) {
                this.blockCongruenceList.get(newId).addAll(newCongruentBlocks);
                continue;
            }
            this.blockCongruenceList.add(newId, newCongruentBlocks);
        }
    }

    public String getBlockCongruenceList() {
        ArrayList<String> congruenceGroups = new ArrayList<String>();
        for (Set<BlockID> group : this.blockCongruenceList) {
            congruenceGroups.add(Joiner.on((char)'=').join(group));
        }
        return Joiner.on((char)',').join(congruenceGroups);
    }

    public Set<BlockID> getCongruentBlocks(BlockID targetBlock) {
        int listId = this.blockCongruenceMap.get(targetBlock);
        return this.blockCongruenceList.get(listId);
    }

    public boolean areBlocksCongruent(BlockID block1, BlockID block2) {
        BlockID block1NoMeta = new BlockID(block1.name, block1.metadata);
        block1NoMeta.metadata = -1;
        BlockID block2NoMeta = new BlockID(block2.name, block2.metadata);
        block2NoMeta.metadata = -1;
        if (!this.blockCongruenceMap.containsKey(block1) && !this.blockCongruenceMap.containsKey(block1NoMeta)) {
            return false;
        }
        int targetBlock1 = this.blockCongruenceMap.containsKey(block1) ? this.blockCongruenceMap.get(block1) : this.blockCongruenceMap.get(block1NoMeta);
        if (!this.blockCongruenceMap.containsKey(block2) && !this.blockCongruenceMap.containsKey(block2NoMeta)) {
            return false;
        }
        int targetBlock2 = this.blockCongruenceMap.containsKey(block2) ? this.blockCongruenceMap.get(block2) : this.blockCongruenceMap.get(block2NoMeta);
        return targetBlock1 == targetBlock2;
    }

    public void addTool(String tool, String name) {
        this.toolsAndBlocks.put(tool, this.toolsAndBlocks.get(tool).addTool(name));
    }

    public void removeTool(String tool, String name) {
        this.toolsAndBlocks.put(tool, this.toolsAndBlocks.get(tool).removeTool(name));
    }

    public Set<String> getToolTypeNames() {
        return this.toolsAndBlocks.keySet();
    }

    public String getToolTypeName(String toolType) {
        return this.toolsAndBlocks.get((Object)toolType).name;
    }

    public String getToolTypeIcon(String toolType) {
        return this.toolsAndBlocks.get((Object)toolType).icon;
    }

    public ArrayList<String> getToolIdArray(String tool) {
        return new ArrayList<String>(this.toolsAndBlocks.get((Object)tool).toollist);
    }

    public int getBlockLimit() {
        return this.blockLimit;
    }

    public void setBlockLimit(int blockLimit) {
        if (blockLimit < -1) {
            this.radiusLimit = -1;
        }
        this.blockLimit = blockLimit;
    }

    public int getRadiusLimit() {
        return this.radiusLimit;
    }

    public void setRadiusLimit(int radiusLimit) {
        if (radiusLimit < -1) {
            radiusLimit = -1;
        } else if (radiusLimit > 1000) {
            radiusLimit = 1000;
        }
        this.radiusLimit = radiusLimit;
    }

    public int getBlocksPerTick() {
        return this.blocksPerTick;
    }

    public void setBlocksPerTick(int blocksPerTick) {
        if (blocksPerTick < -1) {
            blocksPerTick = -1;
        } else if (blocksPerTick > 1000) {
            blocksPerTick = 100;
        }
        this.blocksPerTick = blocksPerTick;
    }

    public int getHungerMultiplier() {
        return this.hungerModifier;
    }

    public void setHungerModifier(int hungerModifier) {
        this.hungerModifier = hungerModifier < 0 ? 0 : hungerModifier;
    }

    public int getExperienceMultiplier() {
        return this.experienceModifier;
    }

    public void setExperienceModifier(int experienceModifier) {
        this.experienceModifier = experienceModifier < 0 ? 0 : experienceModifier;
    }

    public boolean toolIsOfType(ItemStack tool, String type) {
        return tool == null || this.toolsAndBlocks.get((Object)type).toollist.contains(Item.field_150901_e.func_148750_c((Object)tool.func_77973_b()));
    }

    boolean setPreferredMode(String modeString, String fallback) {
        if ("disabled".equals(modeString)) {
            this.preferredMode = 0;
            return true;
        }
        if ("pressed".equals(modeString)) {
            this.preferredMode = 1;
            return true;
        }
        if ("released".equals(modeString)) {
            this.preferredMode = 2;
            return true;
        }
        if ("sneak".equals(modeString)) {
            this.preferredMode = 3;
            return true;
        }
        if ("no_sneak".equals(modeString)) {
            this.preferredMode = 4;
            return true;
        }
        if (fallback != null) {
            this.setPreferredMode(fallback, null);
        }
        return false;
    }

    public void setPreferredMode(int mode) {
        this.preferredMode = mode;
    }

    public int getPreferredMode() {
        return this.preferredMode;
    }

    public String getPreferredModeString() {
        switch (this.preferredMode) {
            case 0: {
                return "disabled";
            }
            case 1: {
                return "pressed";
            }
            case 2: {
                return "released";
            }
            case 3: {
                return "sneak";
            }
            case 4: {
                return "no_sneak";
            }
        }
        return "";
    }

    public void saveConfigs() {
        this.configValues.toolsAndBlocks = this.getToolsAndBlocksJson();
        this.configValues.BLOCK_LIMIT = this.getBlockLimit();
        this.configValues.BLOCKS_PER_TICK = this.getBlocksPerTick();
        this.configValues.RADIUS_LIMIT = this.getRadiusLimit();
        this.configValues.BLOCK_EQUIVALENCY_LIST = this.getBlockCongruenceList();
        this.configValues.HUNGER_MULTIPLIER = this.getHungerMultiplier();
        this.configValues.EXPERIENCE_MULTIPLIER = this.getExperienceMultiplier();
        this.configValues.ENABLE_ALL_BLOCKS = this.getEnableAllBlocks();
        this.configValues.ENABLE_ALL_TOOLS = this.getEnableAllTools();
        this.configValues.CLIENT_PREFERRED_MODE = this.getPreferredModeString();
        this.configValues.saveConfigFile();
    }

    public JsonObject getToolsAndBlocksJson() {
        JsonObject jsonTools = new JsonObject();
        ArrayList<String> sortedToolNames = new ArrayList<String>(this.toolsAndBlocks.keySet());
        Collections.sort(sortedToolNames);
        for (String toolName : sortedToolNames) {
            Tool tool = this.toolsAndBlocks.get(toolName);
            JsonArray toolList = new JsonArray();
            ArrayList<String> sortedToolList = new ArrayList<String>(tool.toollist);
            Collections.sort(sortedToolList);
            for (String whiteListTool : sortedToolList) {
                toolList.add((JsonElement)new JsonPrimitive(whiteListTool));
            }
            JsonArray blockList = new JsonArray();
            ArrayList<BlockID> sortedBlockList = new ArrayList<BlockID>(tool.blocklist);
            Collections.sort(sortedBlockList);
            for (BlockID whitelistBlock : sortedBlockList) {
                blockList.add((JsonElement)new JsonPrimitive(whitelistBlock.toString()));
            }
            JsonObject jsonTool = new JsonObject();
            jsonTool.add("name", (JsonElement)new JsonPrimitive(tool.name));
            jsonTool.add("icon", (JsonElement)new JsonPrimitive(tool.icon));
            jsonTool.add("toollist", (JsonElement)toolList);
            jsonTool.add("blocklist", (JsonElement)blockList);
            jsonTools.add(toolName, (JsonElement)jsonTool);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("tools", (JsonElement)jsonTools);
        return jsonObject;
    }
}

