/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.core;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import portablejim.veinminer.VeinMiner;
import portablejim.veinminer.api.Point;
import portablejim.veinminer.api.VeinminerInitalToolCheck;
import portablejim.veinminer.configuration.ConfigurationSettings;
import portablejim.veinminer.core.MinerInstance;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.util.BlockID;
import portablejim.veinminer.util.Compatibility;

public class CoreEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void blockBreakEvent(BlockEvent.BreakEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        Point breakPont = Compatibility.getPoint(event);
        MinerServer server = VeinMiner.instance.minerServer;
        if (server == null || server.pointIsBlacklisted(breakPont)) {
            return;
        }
        if (event.getPlayer() != null && server.getInstance(event.getPlayer()) != null) {
            return;
        }
        ConfigurationSettings configurationSettings = VeinMiner.instance.minerServer.getConfigurationSettings();
        int radiusLimit = configurationSettings.getRadiusLimit();
        int blockLimit = configurationSettings.getBlockLimit();
        VeinminerInitalToolCheck startConfig = new VeinminerInitalToolCheck(event.getPlayer(), breakPont, radiusLimit, blockLimit, configurationSettings.getRadiusLimit(), configurationSettings.getBlockLimit());
        MinecraftForge.EVENT_BUS.post((Event)startConfig);
        if (startConfig.allowVeinminerStart.isAllowed()) {
            radiusLimit = Math.min(startConfig.radiusLimit, radiusLimit);
            blockLimit = Math.min(startConfig.blockLimit, blockLimit);
            MinerInstance instance = new MinerInstance(event.world, (EntityPlayerMP)event.getPlayer(), Compatibility.getPoint(event), new BlockID(Block.field_149771_c.func_148750_c((Object)event.block), event.blockMetadata), server, radiusLimit, blockLimit);
            if (instance.mineBlock(breakPont) > 0) {
                event.setCanceled(true);
            }
        }
    }

    public void collectDrops(BlockEvent.HarvestDropsEvent event) {
    }
}

