/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.event.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayerMP;
import portablejim.veinminer.VeinMiner;
import portablejim.veinminer.lib.MinerLogger;
import portablejim.veinminer.network.PacketPingClient;
import portablejim.veinminer.server.MinerServer;

public class PlayerServerEvent {
    MinerServer minerServer = null;

    public PlayerServerEvent() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void setServer(MinerServer server) {
        this.minerServer = server;
    }

    @SubscribeEvent
    public void connected(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            PacketPingClient packet = new PacketPingClient();
            VeinMiner.instance.networkWrapper.sendTo((IMessage)packet, player);
            MinerLogger.debug("Sent ping packet to client", new Object[0]);
        } else if (event.player != null) {
            MinerLogger.debug("Somehow %s is not an EntityPlayerMP", event.player.toString());
        }
    }

    @SubscribeEvent
    public void disconnected(PlayerEvent.PlayerLoggedOutEvent event) {
        this.minerServer.removeClientPlayer(event.player.getPersistentID());
    }
}

