/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import portablejim.veinminer.VeinMiner;
import portablejim.veinminer.network.GenericHandler;
import portablejim.veinminer.network.PacketChangeMode;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.util.PlayerStatus;

public class PacketClientPresent
implements IMessage {
    public short mode;

    public PacketClientPresent() {
        this.mode = 0;
    }

    public PacketClientPresent(int clientMode) {
        switch (clientMode) {
            case 1: {
                this.mode = 1;
                break;
            }
            case 2: {
                this.mode = (short)2;
                break;
            }
            case 3: {
                this.mode = (short)3;
                break;
            }
            case 4: {
                this.mode = (short)4;
                break;
            }
            default: {
                this.mode = 0;
            }
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeShort((int)this.mode);
    }

    public void fromBytes(ByteBuf buffer) {
        this.mode = buffer.readShort();
    }

    public static class Handler
    extends GenericHandler<PacketClientPresent> {
        @Override
        public void processMessage(PacketClientPresent packetClientPresent, MessageContext context) {
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            UUID playerName = player.func_110124_au();
            MinerServer minerServer = VeinMiner.instance.minerServer;
            minerServer.addClientPlayer(playerName);
            switch (packetClientPresent.mode) {
                case 3: {
                    minerServer.setPlayerStatus(playerName, PlayerStatus.SNEAK_ACTIVE);
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("mod.veinminer.preferredmode.sneak", new Object[0]));
                    break;
                }
                case 4: {
                    minerServer.setPlayerStatus(playerName, PlayerStatus.SNEAK_INACTIVE);
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("mod.veinminer.preferredmode.nosneak", new Object[0]));
                    break;
                }
                case 1: 
                case 2: {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("mod.veinminer.preferredmode.auto", new Object[0]));
                }
                default: {
                    minerServer.setPlayerStatus(playerName, PlayerStatus.INACTIVE);
                }
            }
            VeinMiner.instance.networkWrapper.sendTo((IMessage)new PacketChangeMode(packetClientPresent.mode), player);
        }
    }
}

