/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import java.util.EnumSet;
import java.util.Set;
import openmods.calc.TokenProperties;

public enum TokenType {
    DEC_NUMBER(TokenProperties.VALUE, new TokenProperties[0]),
    HEX_NUMBER(TokenProperties.VALUE, new TokenProperties[0]),
    OCT_NUMBER(TokenProperties.VALUE, new TokenProperties[0]),
    BIN_NUMBER(TokenProperties.VALUE, new TokenProperties[0]),
    QUOTED_NUMBER(TokenProperties.VALUE, new TokenProperties[0]),
    SYMBOL(TokenProperties.POSSIBLE_FUNCTION, new TokenProperties[0]),
    SYMBOL_WITH_ARGS(TokenProperties.POSSIBLE_FUNCTION, new TokenProperties[0]),
    OPERATOR(TokenProperties.NEXT_OP_INFIX, new TokenProperties[0]),
    LEFT_BRACKET(TokenProperties.NEXT_OP_INFIX, new TokenProperties[0]),
    RIGHT_BRACKET,
    SEPARATOR(TokenProperties.NEXT_OP_INFIX, new TokenProperties[0]);

    private final Set<TokenProperties> properties;

    public boolean isValue() {
        return this.properties.contains((Object)TokenProperties.VALUE);
    }

    public final boolean isNextOpInfix() {
        return this.properties.contains((Object)TokenProperties.NEXT_OP_INFIX);
    }

    public final boolean isPossibleFunction() {
        return this.properties.contains((Object)TokenProperties.POSSIBLE_FUNCTION);
    }

    private TokenType(TokenProperties property, TokenProperties ... properties) {
        this.properties = EnumSet.of(property, properties);
    }

    private TokenType() {
        this.properties = EnumSet.noneOf(TokenProperties.class);
    }
}

