/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Preconditions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;
import openmods.utils.ByteUtils;

public class SyncableEnum<E extends Enum<E>>
extends SyncableObjectBase
implements ISyncableValueProvider<E> {
    private final E[] values;
    private E value;

    public static <E extends Enum<E>> SyncableEnum<E> create(E initialValue) {
        return new SyncableEnum<E>(initialValue);
    }

    public SyncableEnum(E value) {
        this.value = value;
        this.values = (Enum[])((Enum)value).getDeclaringClass().getEnumConstants();
    }

    @Override
    public void readFromStream(DataInputStream stream) {
        int ordinal = ByteUtils.readVLI(stream);
        this.value = this.values[ordinal];
    }

    @Override
    public void writeToStream(DataOutputStream stream) {
        ByteUtils.writeVLI(stream, ((Enum)this.value).ordinal());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        nbt.func_74768_a(name, ((Enum)this.value).ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        int original = nbt.func_74762_e(name);
        this.value = this.values[original];
    }

    @Override
    public E getValue() {
        return this.value;
    }

    public E get() {
        return this.value;
    }

    public void set(E value) {
        Preconditions.checkNotNull(value);
        if (this.value != value) {
            this.value = value;
            this.markDirty();
        }
    }

    public E increment() {
        int next = ((Enum)this.value).ordinal() + 1;
        this.value = next >= this.values.length ? this.values[0] : this.values[next];
        this.markDirty();
        return this.value;
    }

    public E decrement() {
        int prev = ((Enum)this.value).ordinal() - 1;
        this.value = prev < 0 ? this.values[this.values.length - 1] : this.values[prev];
        this.markDirty();
        return this.value;
    }
}

