/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.block;

import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.CoreUtils;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.attachments.cover.CoverHoleRender;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public abstract class Attachment {
    public final TileTDBase tile;
    public final byte side;

    public Attachment(TileTDBase tileTDBase, byte by) {
        this.tile = tileTDBase;
        this.side = by;
    }

    public abstract String getName();

    public abstract int getId();

    public void writeToNBT(NBTTagCompound nBTTagCompound) {
    }

    public void readFromNBT(NBTTagCompound nBTTagCompound) {
    }

    public void addDescriptionToPacket(PacketCoFHBase packetCoFHBase) {
    }

    public void getDescriptionFromPacket(PacketCoFHBase packetCoFHBase) {
    }

    public abstract Cuboid6 getCuboid();

    public boolean onWrenched() {
        this.tile.removeAttachment(this);
        for (ItemStack itemStack : this.getDrops()) {
            this.dropItemStack(itemStack);
        }
        return true;
    }

    public abstract TileTDBase.NeighborTypes getNeighborType();

    public abstract boolean isNode();

    public boolean doesTick() {
        return false;
    }

    public void tick(int n) {
    }

    public void dropItemStack(ItemStack itemStack) {
        Cuboid6 cuboid6 = this.getCuboid();
        CoreUtils.dropItemStackIntoWorldWithVelocity((ItemStack)itemStack, (World)this.tile.func_145831_w(), (double)((double)this.tile.x() + cuboid6.min.x + (double)this.tile.world().field_73012_v.nextFloat() * (cuboid6.max.x - cuboid6.min.x)), (double)((double)this.tile.y() + cuboid6.min.y + (double)this.tile.world().field_73012_v.nextFloat() * (cuboid6.max.y - cuboid6.min.y)), (double)((double)this.tile.z() + cuboid6.min.z + (double)this.tile.world().field_73012_v.nextFloat() * (cuboid6.max.z - cuboid6.min.z)));
    }

    @SideOnly(value=Side.CLIENT)
    public abstract boolean render(int var1, RenderBlocks var2);

    public void addCollisionBoxesToList(AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        Cuboid6 cuboid6 = this.getCuboid().add(new Vector3((double)((TileEntity)this.tile).field_145851_c, (double)((TileEntity)this.tile).field_145848_d, (double)((TileEntity)this.tile).field_145849_e));
        if (cuboid6.intersects(new Cuboid6(axisAlignedBB))) {
            list.add(cuboid6.toAABB());
        }
    }

    public boolean makesSideSolid() {
        return false;
    }

    public void onNeighborChange() {
    }

    public abstract ItemStack getPickBlock();

    public boolean canAddToTile(TileTDBase tileTDBase) {
        return tileTDBase.attachments[this.side] == null;
    }

    public abstract List<ItemStack> getDrops();

    @SideOnly(value=Side.CLIENT)
    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return null;
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return null;
    }

    public boolean isUseable(EntityPlayer entityPlayer) {
        return this.tile.isUseable(entityPlayer);
    }

    public void receiveGuiNetworkData(int n, int n2) {
    }

    public PacketTileInfo getNewPacket() {
        PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this.tile);
        packetTileInfo.addByte(1 + this.side);
        return packetTileInfo;
    }

    public void sendGuiNetworkData(Container container, List list, boolean bl) {
    }

    public int getInvSlotCount() {
        return 0;
    }

    public boolean openGui(EntityPlayer entityPlayer) {
        return false;
    }

    public void handleInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
    }

    public BlockDuct.ConnectionTypes getRenderConnectionType() {
        return TileTDBase.getDefaultConnectionType(this.getNeighborType(), TileTDBase.ConnectionTypes.NORMAL);
    }

    public boolean allowPipeConnection() {
        return false;
    }

    public boolean addToTile() {
        return this.canAddToTile(this.tile) && this.tile.addAttachment(this);
    }

    public void drawSelectionExtra(EntityPlayer entityPlayer, MovingObjectPosition movingObjectPosition, float f) {
    }

    public void postNeighbourChange() {
    }

    public int getRSOutput() {
        return 0;
    }

    public boolean shouldRSConnect() {
        return false;
    }

    public boolean respondsToSignallum() {
        return false;
    }

    public void checkSignal() {
    }

    public void addInfo(List<IChatComponent> list, EntityPlayer entityPlayer, boolean bl) {
    }

    @SideOnly(value=Side.CLIENT)
    public CoverHoleRender.ITransformer[] getHollowMask() {
        return null;
    }
}

