/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments;

import cofh.api.tileentity.IPortableData;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.lib.util.helpers.RedstoneControlHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.attachments.IStuffable;
import cofh.thermaldynamics.duct.attachments.cover.CoverHoleRender;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.attachments.filter.IFilterAttachment;
import cofh.thermaldynamics.duct.attachments.filter.IFilterFluid;
import cofh.thermaldynamics.duct.attachments.filter.IFilterItems;
import cofh.thermaldynamics.gui.client.GuiDuctConnection;
import cofh.thermaldynamics.gui.container.ContainerDuctConnection;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class ConnectionBase
extends Attachment
implements IStuffable,
IRedstoneControl,
IFilterAttachment,
IPortableData {
    public boolean stuffed = false;
    public int type = 0;
    public boolean isValidInput;
    public boolean isPowered = false;
    public IRedstoneControl.ControlMode rsMode = IRedstoneControl.ControlMode.HIGH;
    public FilterLogic filter;
    int prevFlag = -1;

    public ConnectionBase(TileTDBase tileTDBase, byte by) {
        super(tileTDBase, by);
    }

    public ConnectionBase(TileTDBase tileTDBase, byte by, int n) {
        this(tileTDBase, by);
        this.type = n;
        this.filter = this.createFilterLogic();
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74774_a("type", (byte)this.type);
        this.filter.writeToNBT(nBTTagCompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        this.type = nBTTagCompound.func_74771_c("type") % 5;
        this.filter = this.createFilterLogic();
        this.filter.readFromNBT(nBTTagCompound);
    }

    @Override
    public TileTDBase.NeighborTypes getNeighborType() {
        return this.isValidInput ? TileTDBase.NeighborTypes.INPUT : TileTDBase.NeighborTypes.DUCT_ATTACHMENT;
    }

    @Override
    public List<ItemStack> getDrops() {
        LinkedList<ItemStack> linkedList = new LinkedList<ItemStack>();
        linkedList.add(this.getPickBlock());
        return linkedList;
    }

    @Override
    public void addDescriptionToPacket(PacketCoFHBase packetCoFHBase) {
        packetCoFHBase.addBool(this.stuffed);
        packetCoFHBase.addByte(this.type);
    }

    @Override
    public void getDescriptionFromPacket(PacketCoFHBase packetCoFHBase) {
        this.stuffed = packetCoFHBase.getBool();
        this.type = packetCoFHBase.getByte();
    }

    @Override
    public void onNeighborChange() {
        super.onNeighborChange();
        TileEntity tileEntity = this.tile.getAdjTileEntitySafe(this.side);
        this.clearCache();
        boolean bl = this.isValidInput;
        this.isValidInput = this.isValidTile(tileEntity);
        if (this.isValidInput) {
            this.cacheTile(tileEntity);
        }
        boolean bl2 = this.isPowered;
        boolean bl3 = this.isPowered = this.rsMode.isDisabled() || this.rsMode.getState() == this.getPowerState();
        if (bl2 != this.isPowered || this.isValidInput != bl) {
            this.tile.func_145831_w().func_147471_g(((TileEntity)this.tile).field_145851_c, ((TileEntity)this.tile).field_145848_d, ((TileEntity)this.tile).field_145849_e);
        }
    }

    @Override
    public void checkSignal() {
        boolean bl = this.isPowered;
        boolean bl2 = this.isPowered = this.rsMode.isDisabled() || this.rsMode.getState() == this.getPowerState();
        if (bl != this.isPowered) {
            this.tile.func_145831_w().func_147471_g(((TileEntity)this.tile).field_145851_c, ((TileEntity)this.tile).field_145848_d, ((TileEntity)this.tile).field_145849_e);
        }
    }

    @Override
    public boolean respondsToSignallum() {
        return true;
    }

    public boolean getPowerState() {
        if (this.tile.myGrid != null && this.tile.myGrid.rs != null && this.tile.myGrid.rs.redstoneLevel > 0) {
            return true;
        }
        return this.tile.func_145831_w().func_72864_z(((TileEntity)this.tile).field_145851_c, ((TileEntity)this.tile).field_145848_d, ((TileEntity)this.tile).field_145849_e);
    }

    @Override
    public boolean isStuffed() {
        return false;
    }

    public abstract void clearCache();

    public abstract void cacheTile(TileEntity var1);

    public abstract boolean isValidTile(TileEntity var1);

    @Override
    public Cuboid6 getCuboid() {
        return TileTDBase.subSelection[this.side].copy();
    }

    @Override
    public boolean isNode() {
        return true;
    }

    public PacketTileInfo getNewPacket(byte by) {
        PacketTileInfo packetTileInfo = this.getNewPacket();
        packetTileInfo.addByte(by);
        return packetTileInfo;
    }

    @Override
    public void handleInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
        super.handleInfoPacket(packetCoFHBase, bl, entityPlayer);
        byte by = packetCoFHBase.getByte();
        this.handleInfoPacketType(by, packetCoFHBase, bl, entityPlayer);
    }

    public void setControl(IRedstoneControl.ControlMode controlMode) {
        if (!this.canAlterRS()) {
            return;
        }
        this.rsMode = controlMode;
        if (ServerHelper.isClientWorld((World)this.tile.world())) {
            PacketTileInfo packetTileInfo = this.getNewPacket((byte)1);
            packetTileInfo.addByte(this.rsMode.ordinal());
            PacketHandler.sendToServer((PacketBase)packetTileInfo);
        } else {
            this.onNeighborChange();
        }
    }

    public IRedstoneControl.ControlMode getControl() {
        return this.rsMode;
    }

    public void setPowered(boolean bl) {
        this.isPowered = bl;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean canAlterRS() {
        return false;
    }

    public FilterLogic getFilter() {
        if (this.filter == null) {
            this.filter = this.createFilterLogic();
        }
        return this.filter;
    }

    public void handleInfoPacketType(byte by, PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
        if (by == 1) {
            if (this.canAlterRS()) {
                this.setControl(IRedstoneControl.ControlMode.values()[packetCoFHBase.getByte()]);
            }
        } else if (by == 2) {
            byte by2;
            this.filter.setFlag(by2 >> 1, ((by2 = packetCoFHBase.getByte()) & 1) == 1);
            this.filter.recalc = true;
        } else if (by == 3) {
            byte by3 = packetCoFHBase.getByte();
            short s = packetCoFHBase.getShort();
            this.filter.setLevel(by3, s);
            this.filter.recalc = true;
        }
    }

    public void sendFilterConfigPacketFlag(int n, boolean bl) {
        PacketTileInfo packetTileInfo = this.getNewPacket((byte)2);
        packetTileInfo.addByte(n << 1 | (bl ? 1 : 0));
        PacketHandler.sendToServer((PacketBase)packetTileInfo);
    }

    public void sendFilterConfigPacketLevel(int n, int n2) {
        PacketTileInfo packetTileInfo = this.getNewPacket((byte)3);
        packetTileInfo.addByte(n);
        packetTileInfo.addShort(n2);
        PacketHandler.sendToServer((PacketBase)packetTileInfo);
    }

    @Override
    public void sendGuiNetworkData(Container container, List list, boolean bl) {
        super.sendGuiNetworkData(container, list, bl);
        int n = this.filter.getFlagByte();
        if (n != this.prevFlag || bl) {
            for (Object object : list) {
                ((ICrafting)object).func_71112_a(container, 0, n);
            }
        }
        this.prevFlag = n;
        if (this.filter.levelsChanged || bl) {
            for (int i = 0; i < FilterLogic.defaultLevels.length; ++i) {
                for (Object e : list) {
                    ((ICrafting)e).func_71112_a(container, 1 + i, this.filter.getLevel(i));
                }
            }
            this.filter.levelsChanged = false;
        }
    }

    @Override
    public void receiveGuiNetworkData(int n, int n2) {
        super.receiveGuiNetworkData(n, n2);
        if (n == 0) {
            this.filter.handleFlagByte(n2);
        } else {
            this.filter.setLevel(n - 1, n2, false);
        }
    }

    @Override
    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerDuctConnection(inventoryPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiDuctConnection(inventoryPlayer, this);
    }

    @Override
    public void stuffItem(ItemStack itemStack) {
    }

    @Override
    public boolean canStuff() {
        return false;
    }

    @Override
    public BlockDuct.ConnectionTypes getRenderConnectionType() {
        return BlockDuct.ConnectionTypes.DUCT;
    }

    @Override
    public IFilterItems getItemFilter() {
        return this.filter;
    }

    @Override
    public IFilterFluid getFluidFilter() {
        return this.filter;
    }

    public abstract FilterLogic createFilterLogic();

    @Override
    public boolean openGui(EntityPlayer entityPlayer) {
        if (ServerHelper.isServerWorld((World)this.tile.world())) {
            entityPlayer.openGui((Object)ThermalDynamics.instance, 1 + this.side, this.tile.func_145831_w(), ((TileEntity)this.tile).field_145851_c, ((TileEntity)this.tile).field_145848_d, ((TileEntity)this.tile).field_145849_e);
        }
        return true;
    }

    public String getDataType() {
        return "ConnectionBase";
    }

    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (this.canAlterRS() && nBTTagCompound.func_74764_b("RSControl")) {
            this.setControl(RedstoneControlHelper.getControlFromNBT((NBTTagCompound)nBTTagCompound));
        }
        this.filter.readFromNBT(nBTTagCompound);
        this.onNeighborChange();
    }

    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (this.canAlterRS()) {
            RedstoneControlHelper.setItemStackTagRS((NBTTagCompound)nBTTagCompound, (IRedstoneControl)this);
        }
        this.filter.writeToNBT(nBTTagCompound);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CoverHoleRender.ITransformer[] getHollowMask() {
        return CoverHoleRender.hollowDuctTile;
    }

    public static class NETWORK_ID {
        public static final byte GUI = 0;
        public static final byte RSCONTROL = 1;
        public static final byte FILTERFLAG = 2;
        public static final byte FILTERLEVEL = 3;
    }
}

