/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.gui.client;

import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketTileInfo;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.entity.TileTransportDuct;
import com.google.common.base.Strings;
import net.minecraft.item.ItemStack;

public final class DirectoryEntry {
    public final String name;
    public final int x;
    public final int y;
    public final int z;
    public final ItemStack icon;

    public static void addDirectoryEntry(PacketTileInfo packetTileInfo, TileTransportDuct tileTransportDuct) {
        packetTileInfo.addString(tileTransportDuct.data.name);
        packetTileInfo.addInt(tileTransportDuct.x());
        packetTileInfo.addInt(tileTransportDuct.y());
        packetTileInfo.addInt(tileTransportDuct.z());
        packetTileInfo.addItemStack(tileTransportDuct.data.item);
    }

    public DirectoryEntry(PacketCoFHBase packetCoFHBase) {
        this(packetCoFHBase.getString(), packetCoFHBase.getInt(), packetCoFHBase.getInt(), packetCoFHBase.getInt(), packetCoFHBase.getItemStack());
    }

    public DirectoryEntry(String string, int n, int n2, int n3, ItemStack itemStack) {
        this.name = string;
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.icon = itemStack;
    }

    public String toString() {
        return "DirectoryEntry{name='" + this.name + '\'' + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", icon=" + this.icon + '}';
    }

    public String getName() {
        if (Strings.isNullOrEmpty((String)this.name)) {
            return StringHelper.localize((String)"info.thermaldynamics.transport.unnamed");
        }
        return this.name;
    }
}

