/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.PlantGathererConfig;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PlantGathererTile
extends IndustrialAreaWorkingTile<PlantGathererTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private SidedInventoryComponent<PlantGathererTile> output = (SidedInventoryComponent)new SidedInventoryComponent("output", 70, 22, 15, 0).setColor(DyeColor.ORANGE).setRange(5, 3).setComponentHarness((IComponentHarness)this);
    @Save
    private SidedFluidTankComponent<PlantGathererTile> tank;

    public PlantGathererTile() {
        super(ModuleAgricultureHusbandry.PLANT_GATHERER, RangeManager.RangeType.BEHIND, true, PlantGathererConfig.powerPerOperation);
        this.addInventory((InventoryComponent)this.output);
        this.tank = (SidedFluidTankComponent)new SidedFluidTankComponent("sludge", PlantGathererConfig.maxSludgeTankSize, 45, 20, 1).setColor(DyeColor.MAGENTA).setComponentHarness((IComponentHarness)this);
        this.addTank(this.tank);
        this.maxProgress = PlantGathererConfig.maxProgress;
        this.powerPerOperation = PlantGathererConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.powerPerOperation)) {
            int amount = Math.max(1, BlockUtils.getBlockPosInAABB(this.getWorkingArea().func_197752_a()).size() / 4);
            for (int i = 0; i < amount; ++i) {
                Optional<PlantRecollectable> optional;
                BlockPos pointed = this.getPointedBlockPos();
                if (this.isLoaded(pointed) && !ItemStackUtils.isInventoryFull(this.output) && (optional = IFRegistries.PLANT_RECOLLECTABLES_REGISTRY.getValues().stream().filter(plantRecollectable -> plantRecollectable.canBeHarvested(this.field_145850_b, pointed, this.field_145850_b.func_180495_p(pointed))).findFirst()).isPresent()) {
                    List<ItemStack> drops = optional.get().doHarvestOperation(this.field_145850_b, pointed, this.field_145850_b.func_180495_p(pointed));
                    this.tank.fill(new FluidStack((Fluid)ModuleCore.SLUDGE.getSourceFluid(), 10 * drops.size()), IFluidHandler.FluidAction.EXECUTE);
                    drops.forEach(stack -> ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false));
                    if (optional.get().shouldCheckNextPlant(this.field_145850_b, pointed, this.field_145850_b.func_180495_p(pointed))) {
                        this.increasePointer();
                    }
                    return new IndustrialWorkingTile.WorkAction(this, 0.3f, this.powerPerOperation);
                }
                this.increasePointer();
            }
        }
        this.increasePointer();
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<PlantGathererTile> createEnergyStorage() {
        return new EnergyStorageComponent(PlantGathererConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public PlantGathererTile getSelf() {
        return this;
    }
}

