/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator;

import com.buuz135.industrial.block.IndustrialBlock;
import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.block.generator.tile.MycelialReactorTile;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.worlddata.MycelialDataManager;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.RotatableBlock;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class MycelialReactorBlock
extends IndustrialBlock<MycelialReactorTile> {
    public MycelialReactorBlock() {
        super("mycelial_reactor", AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150339_S), MycelialReactorTile.class, (ItemGroup)ModuleGenerator.TAB_GENERATOR);
    }

    public IFactory<MycelialReactorTile> getTileEntityFactory() {
        return MycelialReactorTile::new;
    }

    @Nonnull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof MycelialReactorTile && placer != null) {
            ((MycelialReactorTile)entity).setOwner(placer.func_110124_au().toString());
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (player.func_225608_bj_() && !worldIn.field_72995_K && tileEntity instanceof MycelialReactorTile) {
            List<String> available = MycelialDataManager.getReactorAvailable(((MycelialReactorTile)tileEntity).getOwner(), worldIn, false);
            if (available.size() != IMycelialGeneratorType.TYPES.size()) {
                player.func_145747_a((ITextComponent)new StringTextComponent("Generators not running:").func_240699_a_(TextFormatting.RED), player.func_110124_au());
            }
            for (IMycelialGeneratorType type : IMycelialGeneratorType.TYPES) {
                if (available.contains(type.getName())) continue;
                player.func_145747_a((ITextComponent)new TranslationTextComponent("block.industrialforegoing.mycelial_" + type.getName()).func_240699_a_(TextFormatting.RED), player.func_110124_au());
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, hand, ray);
    }
}

