/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.misc.EnchantmentFactoryConfig;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.DyeColor;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class EnchantmentFactoryTile
extends IndustrialProcessingTile<EnchantmentFactoryTile> {
    private static final int XP_30 = 1410;
    @Save
    private SidedFluidTankComponent<EnchantmentFactoryTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", EnchantmentFactoryConfig.tankSize, 34, 20, 0).setColor(DyeColor.LIME).setTankAction(FluidTankComponent.Action.FILL).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207185_a(IndustrialTags.Fluids.EXPERIENCE));
    @Save
    private SidedInventoryComponent<EnchantmentFactoryTile> inputFirst;
    @Save
    private SidedInventoryComponent<EnchantmentFactoryTile> output;

    public EnchantmentFactoryTile() {
        super(ModuleMisc.ENCHANTMENT_FACTORY, 100, 40);
        this.addTank(this.tank);
        this.inputFirst = (SidedInventoryComponent)new SidedInventoryComponent("input", 70, 40, 1, 1).setColor(DyeColor.BLUE).setInputFilter((stack, integer) -> !this.isEnchanted((ItemStack)stack) && stack.func_77956_u() || stack.func_77973_b().equals(Items.field_151122_aG)).setSlotLimit(1).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inputFirst);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 135, 40, 1, 2).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
    }

    @Override
    public boolean canIncrease() {
        return this.tank.getFluidAmount() >= 28200 && !this.inputFirst.getStackInSlot(0).func_190926_b() && this.output.getStackInSlot(0).func_190926_b();
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            ItemStack output = EnchantmentHelper.func_77504_a((Random)this.field_145850_b.field_73012_v, (ItemStack)this.inputFirst.getStackInSlot(0).func_77946_l(), (int)50, (boolean)true);
            this.inputFirst.setStackInSlot(0, ItemStack.field_190927_a);
            this.output.setStackInSlot(0, output);
            this.tank.drainForced(28200, IFluidHandler.FluidAction.EXECUTE);
        };
    }

    @Override
    protected int getTickPower() {
        return EnchantmentFactoryConfig.powerPerTick;
    }

    public EnchantmentFactoryTile getSelf() {
        return this;
    }

    private boolean isEnchanted(ItemStack stack) {
        return stack.func_77948_v() || stack.func_77973_b() instanceof EnchantedBookItem;
    }

    protected EnergyStorageComponent<EnchantmentFactoryTile> createEnergyStorage() {
        return new EnergyStorageComponent(EnchantmentFactoryConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return EnchantmentFactoryConfig.maxProgress;
    }
}

