/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.SludgeRefinerConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SludgeRefinerTile
extends IndustrialProcessingTile<SludgeRefinerTile> {
    private int getPowerPerTick;
    @Save
    private SidedFluidTankComponent<SludgeRefinerTile> sludge = (SidedFluidTankComponent)new SidedFluidTankComponent("sludge", SludgeRefinerConfig.maxSludgeTankSize, 31, 20, 0).setColor(DyeColor.MAGENTA).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.SLUDGE.getSourceFluid()));
    @Save
    private SidedInventoryComponent<SludgeRefinerTile> output;

    public SludgeRefinerTile() {
        super(ModuleResourceProduction.SLUDGE_REFINER, 53, 40);
        this.addTank(this.sludge);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 80, 22, 15, 1).setColor(DyeColor.ORANGE).setRange(5, 3).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.getPowerPerTick = SludgeRefinerConfig.powerPerTick;
    }

    @Override
    public boolean canIncrease() {
        return this.sludge.getFluidAmount() >= 500;
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            Item item = (Item)IndustrialTags.Items.SLUDGE_OUTPUT.func_205596_a(this.field_145850_b.field_73012_v);
            if (item != null && ItemHandlerHelper.insertItem(this.output, (ItemStack)new ItemStack((IItemProvider)item), (boolean)true).func_190926_b()) {
                this.sludge.drainForced(500, IFluidHandler.FluidAction.EXECUTE);
                ItemHandlerHelper.insertItem(this.output, (ItemStack)new ItemStack((IItemProvider)item), (boolean)false);
            }
        };
    }

    protected EnergyStorageComponent<SludgeRefinerTile> createEnergyStorage() {
        return new EnergyStorageComponent(SludgeRefinerConfig.maxStoredPower, 10, 20);
    }

    @Override
    protected int getTickPower() {
        return this.getPowerPerTick;
    }

    @Nonnull
    public SludgeRefinerTile getSelf() {
        return this;
    }
}

