/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.entity;

import com.buuz135.industrial.item.infinity.item.ItemInfinityNuke;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.proxy.client.sound.TickeableSound;
import com.buuz135.industrial.utils.explosion.ExplosionTickHandler;
import com.buuz135.industrial.utils.explosion.ProcessExplosion;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class InfinityNukeEntity
extends Entity {
    private static final DataParameter<Integer> RADIUS = EntityDataManager.func_187226_a(InfinityNukeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> EXPLODING = EntityDataManager.func_187226_a(InfinityNukeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ARMED = EntityDataManager.func_187226_a(InfinityNukeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TICKS = EntityDataManager.func_187226_a(InfinityNukeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    @Nullable
    private LivingEntity placedBy;
    private ItemStack original = new ItemStack((IItemProvider)ModuleTool.INFINITY_NUKE);
    private boolean exploding = false;
    private boolean armed = false;
    private int radius = 1;
    private int ticksExploding = 1;
    private ProcessExplosion explosionHelper;
    @OnlyIn(value=Dist.CLIENT)
    private TickeableSound chargingSound;
    @OnlyIn(value=Dist.CLIENT)
    private TickeableSound explodingSound;

    public InfinityNukeEntity(EntityType<? extends InfinityNukeEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.field_70156_m = true;
    }

    public InfinityNukeEntity(World worldIn, LivingEntity owner, ItemStack original) {
        this(ModuleTool.INFINITY_NUKE_ENTITY_TYPE, worldIn);
        this.placedBy = owner;
        this.original = original;
        this.radius = ItemInfinityNuke.getRadius(original);
        this.field_70180_af.func_187227_b(RADIUS, (Object)this.radius);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
        }
        if (this.exploding) {
            if (this.field_70170_p instanceof ServerWorld && this.explosionHelper == null) {
                this.explosionHelper = new ProcessExplosion(this.func_233580_cy_(), ItemInfinityNuke.getRadius(this.original), (ServerWorld)this.field_70170_p, 39, this.placedBy != null ? this.placedBy.func_145748_c_().getString() : "");
                ExplosionTickHandler.processExplosionList.add(this.explosionHelper);
            }
            this.setTicksExploding(this.getTicksExploding() + 1);
            this.func_233566_aG_();
        }
        if (this.field_70170_p.field_72995_K && ((Boolean)this.func_184212_Q().func_187225_a(EXPLODING)).booleanValue() && this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 1.1, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b())), this.func_226277_ct_() + this.field_70170_p.func_201674_k().nextDouble() - 0.5, this.func_226278_cu_(), this.func_226281_cx_() + this.field_70170_p.func_201674_k().nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
        if (this.explosionHelper != null && this.explosionHelper.isDead) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            this.tickClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient() {
        if (this.chargingSound == null && ((Boolean)this.func_184212_Q().func_187225_a(EXPLODING)).booleanValue()) {
            this.chargingSound = new TickeableSound(this.field_70170_p, this.func_233580_cy_(), ModuleTool.NUKE_CHARGING, (Integer)this.func_184212_Q().func_187225_a(RADIUS), 10);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.chargingSound);
        }
        if (this.chargingSound != null) {
            this.chargingSound.increase();
            if (!Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)this.chargingSound) && this.explodingSound == null) {
                this.explodingSound = new TickeableSound(this.field_70170_p, this.func_233580_cy_(), ClientProxy.NUKE_EXPLOSION, (Integer)this.func_184212_Q().func_187225_a(RADIUS), 10);
                this.explodingSound.setPitch(1.0f);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.explodingSound);
            }
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(RADIUS, (Object)1);
        this.field_70180_af.func_187214_a(EXPLODING, (Object)false);
        this.field_70180_af.func_187214_a(ARMED, (Object)false);
        this.field_70180_af.func_187214_a(TICKS, (Object)1);
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("Original", (INBT)this.getOriginal().serializeNBT());
        compound.func_74757_a("Exploding", this.isExploding());
        compound.func_74757_a("Armed", this.isArmed());
        compound.func_74768_a("TicksExploding", this.getTicksExploding());
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setArmed(compound.func_74767_n("Armed"));
        this.setExploding(compound.func_74767_n("Exploding"));
        this.setOriginal(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Original")));
        this.setTicksExploding(compound.func_74762_e("TicksExploding"));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.isExploding()) {
            return ActionResultType.SUCCESS;
        }
        if (player.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND && player.func_184586_b(hand).func_190926_b()) {
            this.arm();
        }
        if (!player.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND) {
            if (player.func_184586_b(hand).func_190926_b()) {
                if (player.func_225608_bj_()) {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)this.original);
                    this.func_70106_y();
                    return ActionResultType.SUCCESS;
                }
                this.setArmed(!this.isArmed());
                return ActionResultType.SUCCESS;
            }
            if (!this.isExploding() && this.isArmed() && player.func_184586_b(hand).func_77973_b().equals(Items.field_151033_d)) {
                this.setExploding(true);
                player.func_184586_b(hand).func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_184230_a(player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void arm() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(ClientProxy.NUKE_ARMING, SoundCategory.BLOCKS, 1.0f, 1.0f, this.func_233580_cy_()));
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public ItemStack getOriginal() {
        return this.original;
    }

    public void setOriginal(ItemStack original) {
        this.original = original;
    }

    public boolean isExploding() {
        return this.exploding;
    }

    public void setExploding(boolean exploding) {
        this.exploding = exploding;
        this.func_184212_Q().func_187227_b(EXPLODING, (Object)exploding);
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean armed) {
        this.armed = armed;
        this.func_184212_Q().func_187227_b(ARMED, (Object)armed);
    }

    public boolean isDataArmed() {
        return (Boolean)this.func_184212_Q().func_187225_a(ARMED);
    }

    public boolean isDataExploding() {
        return (Boolean)this.func_184212_Q().func_187225_a(EXPLODING);
    }

    public int getTicksExploding() {
        return this.ticksExploding;
    }

    public void setTicksExploding(int ticksExploding) {
        this.ticksExploding = ticksExploding;
        this.func_184212_Q().func_187227_b(TICKS, (Object)ticksExploding);
    }

    public int getDataTicksExploding() {
        return (Integer)this.func_184212_Q().func_187225_a(TICKS);
    }
}

