/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.fluid;

import com.buuz135.industrial.fluid.OreFluid;
import com.buuz135.industrial.item.OreBucketItem;
import com.hrznstudio.titanium.module.api.IAlternativeEntries;
import com.hrznstudio.titanium.module.api.RegistryManager;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class OreFluidInstance
extends ForgeRegistryEntry<OreFluidInstance>
implements IAlternativeEntries {
    private OreFluid flowingFluid;
    private OreFluid sourceFluid;
    private Item bucketFluid;
    private Block blockFluid;

    public OreFluidInstance(String modid, String fluid, FluidAttributes.Builder attributes, boolean hasBucket, ItemGroup group) {
        this.sourceFluid = (OreFluid)new OreFluid.Source(attributes){}.setRegistryName(modid, fluid);
        this.flowingFluid = (OreFluid)new OreFluid.Flowing(attributes).setRegistryName(modid, fluid + "_fluid");
        this.sourceFluid = this.sourceFluid.setSourceFluid(this.sourceFluid).setFlowingFluid((Fluid)this.flowingFluid);
        this.flowingFluid = this.flowingFluid.setSourceFluid(this.sourceFluid).setFlowingFluid((Fluid)this.flowingFluid);
        if (hasBucket) {
            this.bucketFluid = (Item)new OreBucketItem(this::getSourceFluid, new Item.Properties().func_200919_a(Items.field_151133_ar).func_200917_a(1).func_200916_a(group)).setRegistryName(modid, fluid + "_bucket");
        }
        this.blockFluid = (Block)new FlowingFluidBlock(this.sourceFluid, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e()){}.setRegistryName(modid, fluid + "_block");
        this.sourceFluid.setBlockFluid(this.blockFluid).setBucketFluid(this.bucketFluid);
        this.flowingFluid.setBlockFluid(this.blockFluid).setBucketFluid(this.bucketFluid);
    }

    public void addAlternatives(RegistryManager<?> registry) {
        registry.content(Fluid.class, (IForgeRegistryEntry)this.flowingFluid);
        registry.content(Fluid.class, (IForgeRegistryEntry)this.sourceFluid);
        registry.content(Block.class, (IForgeRegistryEntry)this.blockFluid);
        if (this.bucketFluid != null) {
            registry.content(Item.class, (IForgeRegistryEntry)this.bucketFluid);
        }
    }

    public OreFluid getFlowingFluid() {
        return this.flowingFluid;
    }

    public OreFluid getSourceFluid() {
        return this.sourceFluid;
    }

    public Item getBucketFluid() {
        return this.bucketFluid;
    }

    public Block getBlockFluid() {
        return this.blockFluid;
    }

    public void setBucketFluid(Item bucketFluid) {
        this.bucketFluid = bucketFluid;
        this.sourceFluid.setBucketFluid(bucketFluid);
        this.flowingFluid.setBucketFluid(bucketFluid);
    }
}

