/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.assets.types.ITankAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.BucketItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemStackTankScreenAddon
extends BasicScreenAddon
implements IClickable {
    private IFluidHandler tank;
    private ITankAsset asset;
    private FluidTankComponent.Type type;
    private int tankSlot;

    public ItemStackTankScreenAddon(int posX, int posY, IFluidHandler tank, int tankSlot, FluidTankComponent.Type type) {
        super(posX, posY);
        this.tank = tank;
        this.type = type;
        this.tankSlot = tankSlot;
    }

    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.asset = (ITankAsset)IAssetProvider.getAsset((IAssetProvider)provider, (IAssetType)this.type.getAssetType());
        Rectangle area = this.asset.getArea();
        if (!this.tank.getFluidInTank(this.tankSlot).isEmpty()) {
            TextureAtlasSprite sprite;
            Texture texture;
            FluidStack fluidStack = this.tank.getFluidInTank(this.tankSlot);
            int stored = fluidStack.getAmount();
            int capacity = this.tank.getTankCapacity(this.tankSlot);
            int topBottomPadding = this.asset.getFluidRenderPadding(Direction.UP) + this.asset.getFluidRenderPadding(Direction.DOWN);
            int offset = stored * (area.height - topBottomPadding) / capacity;
            ResourceLocation flowing = fluidStack.getFluid().getAttributes().getStillTexture(fluidStack);
            if (flowing != null && (texture = screen.getMinecraft().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b)) instanceof AtlasTexture && (sprite = ((AtlasTexture)texture).func_195424_a(flowing)) != null) {
                screen.getMinecraft().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                Color color = new Color(fluidStack.getFluid().getAttributes().getColor());
                RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
                RenderSystem.enableBlend();
                Screen.func_238470_a_((MatrixStack)stack, (int)(this.getPosX() + guiX + this.asset.getFluidRenderPadding(Direction.WEST)), (int)(this.getPosY() + guiY + this.asset.getFluidRenderPadding(Direction.UP) + (fluidStack.getFluid().getAttributes().isGaseous() ? 0 : area.height - topBottomPadding - offset)), (int)0, (int)((int)(area.getWidth() - (double)this.asset.getFluidRenderPadding(Direction.EAST) - (double)this.asset.getFluidRenderPadding(Direction.WEST))), (int)offset, (TextureAtlasSprite)sprite);
                RenderSystem.disableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        ITankAsset asset = (ITankAsset)IAssetProvider.getAsset((IAssetProvider)provider, (IAssetType)this.type.getAssetType());
        AssetUtil.drawAsset((MatrixStack)stack, (Screen)screen, (IAsset)asset, (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
    }

    public void drawForegroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
    }

    public List<ITextComponent> getTooltipLines() {
        ArrayList<ITextComponent> strings = new ArrayList<ITextComponent>();
        strings.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.titanium.tank.fluid").getString()).func_230529_a_((ITextComponent)(this.tank.getFluidInTank(this.tankSlot).isEmpty() ? new TranslationTextComponent("tooltip.titanium.tank.empty").func_240699_a_(TextFormatting.WHITE) : new TranslationTextComponent(this.tank.getFluidInTank(this.tankSlot).getFluid().getAttributes().getTranslationKey(this.tank.getFluidInTank(this.tankSlot))))).func_240699_a_(TextFormatting.WHITE));
        strings.add((ITextComponent)new TranslationTextComponent("tooltip.titanium.tank.amount").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(TextFormatting.WHITE + new DecimalFormat().format(this.tank.getFluidInTank(this.tankSlot).getAmount()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(this.tank.getTankCapacity(this.tankSlot)) + TextFormatting.DARK_AQUA + "mb")));
        if (!Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_190926_b() && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(iFluidHandlerItem -> {
                boolean isBucket = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_77973_b() instanceof BucketItem;
                int amount = isBucket ? 1000 : Integer.MAX_VALUE;
                boolean canFillFromItem = false;
                boolean canDrainFromItem = false;
                if (isBucket) {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                    canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                } else {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                    boolean bl = canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                }
                if (canFillFromItem) {
                    strings.add((ITextComponent)new TranslationTextComponent("tooltip.titanium.tank.can_fill_from_item").func_240699_a_(TextFormatting.BLUE));
                }
                if (canDrainFromItem) {
                    strings.add((ITextComponent)new TranslationTextComponent("tooltip.titanium.tank.can_drain_from_item").func_240699_a_(TextFormatting.GOLD));
                }
                if (canFillFromItem) {
                    strings.add((ITextComponent)new TranslationTextComponent("tooltip.titanium.tank.action_fill").func_240699_a_(TextFormatting.DARK_GRAY));
                }
                if (canDrainFromItem) {
                    strings.add((ITextComponent)new TranslationTextComponent("tooltip.titanium.tank.action_drain").func_240699_a_(TextFormatting.DARK_GRAY));
                }
                if (!canDrainFromItem && !canFillFromItem) {
                    strings.add((ITextComponent)new TranslationTextComponent("tooltip.titanium.tank.no_action").func_240699_a_(TextFormatting.RED));
                }
            });
        } else {
            strings.add((ITextComponent)new TranslationTextComponent("tooltip.titanium.tank.no_tank").func_240699_a_(TextFormatting.DARK_GRAY));
        }
        return strings;
    }

    public int getXSize() {
        return this.asset != null ? this.asset.getArea().width : 0;
    }

    public int getYSize() {
        return this.asset != null ? this.asset.getArea().height : 0;
    }

    public void handleClick(Screen screen, int guiX, int guiY, double mouseX, double mouseY, int button) {
        if (!Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_190926_b() && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 1.0f, 1.0f, Minecraft.func_71410_x().field_71439_g.func_233580_cy_()));
            if (screen instanceof ContainerScreen && ((ContainerScreen)screen).func_212873_a_() instanceof ILocatable) {
                ILocatable locatable = (ILocatable)((ContainerScreen)screen).func_212873_a_();
                CompoundNBT compoundNBT = new CompoundNBT();
                if (this.tank instanceof FluidTankComponent) {
                    compoundNBT.func_74778_a("Name", ((FluidTankComponent)this.tank).getName());
                } else {
                    compoundNBT.func_74757_a("Invalid", true);
                }
                Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(iFluidHandlerItem -> {
                    boolean isBucket = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_77973_b() instanceof BucketItem;
                    int amount = isBucket ? 1000 : Integer.MAX_VALUE;
                    boolean canFillFromItem = false;
                    boolean canDrainFromItem = false;
                    if (isBucket) {
                        canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                        canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                    } else {
                        canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                        boolean bl = canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                    }
                    if (canFillFromItem && button == 0) {
                        compoundNBT.func_74757_a("Fill", true);
                    }
                    if (canDrainFromItem && button == 1) {
                        compoundNBT.func_74757_a("Fill", false);
                    }
                });
                Titanium.NETWORK.get().sendToServer((Object)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), -3, compoundNBT));
            }
        }
    }
}

