/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component.custom;

import com.buuz135.industrial.api.conveyor.gui.PositionedGuiComponent;
import com.buuz135.industrial.gui.component.custom.ICanSendNetworkMessage;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class RegulatorFilterGuiComponent
extends PositionedGuiComponent {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("industrialforegoing", "textures/gui/conveyor.png");

    public RegulatorFilterGuiComponent(int x, int y, int xSize, int ySize) {
        super(x, y, xSize, ySize);
    }

    @Override
    public boolean handleClick(ContainerScreen conveyor, int guiX, int guiY, double mouseX, double mouseY) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (mouseX > (double)(posX + 1) && mouseX < (double)(posX + 1 + 16) && mouseY > (double)(posY + 1) && mouseY < (double)(posY + 1 + 16)) {
                    if (conveyor instanceof ICanSendNetworkMessage) {
                        ((ICanSendNetworkMessage)conveyor).sendMessage(pos, Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().serializeNBT());
                    }
                    return true;
                }
                ++pos;
            }
        }
        return false;
    }

    @Override
    public boolean onScrolled(ContainerScreen conveyor, int guiX, int guiY, double mouseX, double mouseY, double delta) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (mouseX > (double)(posX + 1) && mouseX < (double)(posX + 1 + 16) && mouseY > (double)(posY + 1) && mouseY < (double)(posY + 1 + 16)) {
                    if (conveyor instanceof ICanSendNetworkMessage) {
                        CompoundNBT compoundNBT = new CompoundNBT();
                        int amount = (int)delta;
                        if (Screen.func_231173_s_()) {
                            amount *= this.getFilter().getSmallMultiplier();
                        }
                        if (Screen.func_231172_r_()) {
                            amount *= this.getFilter().getBigMultiplier();
                        }
                        compoundNBT.func_74768_a("Amount", amount);
                        ((ICanSendNetworkMessage)conveyor).sendMessage(pos, compoundNBT);
                    }
                    return true;
                }
                ++pos;
            }
        }
        return false;
    }

    @Override
    public void drawGuiBackgroundLayer(MatrixStack stack, int guiX, int guiY, double mouseX, double mouseY) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(BG_TEXTURE);
                Minecraft.func_71410_x().field_71462_r.func_238474_b_(stack, posX, posY, 176, 0, 18, 18);
                if (!this.getFilter().getFilter()[pos].getStack().func_190926_b()) {
                    Minecraft.func_71410_x().func_175599_af().func_175042_a(this.getFilter().getFilter()[pos].getStack(), posX + 1, posY + 1);
                    if (this.isRegulator()) {
                        stack.func_227860_a_();
                        stack.func_227861_a_(0.0, 0.0, 260.0);
                        stack.func_227862_a_(0.5f, 0.5f, 0.5f);
                        String amount = this.getFilter().getFilter()[pos].getAmount() + "";
                        Minecraft.func_71410_x().field_71466_p.func_238421_b_(stack, TextFormatting.WHITE + amount, ((float)(posX + 17) - (float)Minecraft.func_71410_x().field_71466_p.func_78256_a(amount) / 2.0f) * 2.0f, (float)((posY + 13) * 2), 0xFFFFFF);
                        stack.func_227865_b_();
                    }
                }
                ++pos;
            }
        }
    }

    @Override
    public void drawGuiForegroundLayer(MatrixStack stack, int guiX, int guiY, double mouseX, double mouseY) {
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (!(mouseX > (double)(posX + 1)) || !(mouseX < (double)(posX + 1 + 16)) || !(mouseY > (double)(posY + 1)) || !(mouseY < (double)(posY + 1 + 16))) continue;
                AssetUtil.drawSelectingOverlay((MatrixStack)stack, (int)(posX + 1 - guiX), (int)(posY + 1 - guiY), (int)(posX + 17 - guiX), (int)(posY + 17 - guiY));
                return;
            }
        }
    }

    @Override
    public boolean isInside(double mouseX, double mouseY) {
        return mouseX > (double)this.getXPos() && mouseX < (double)(this.getXPos() + this.getXSize() * 18) && mouseY > (double)this.getYPos() && mouseY < (double)(this.getYPos() + this.getYSize() * 18);
    }

    public abstract RegulatorFilter getFilter();

    public abstract boolean isRegulator();

    @Override
    @Nullable
    public List<ITextComponent> getTooltip(int guiX, int guiY, double mouseX, double mouseY) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (mouseX > (double)(posX + 1) && mouseX < (double)(posX + 1 + 16) && mouseY > (double)(posY + 1) && mouseY < (double)(posY + 1 + 16) && !this.getFilter().getFilter()[pos].getStack().func_190926_b()) {
                    List strings = Minecraft.func_71410_x().field_71462_r.func_231151_a_(this.getFilter().getFilter()[pos].getStack());
                    if (this.isRegulator()) {
                        strings.add(new StringTextComponent(TextFormatting.DARK_GRAY + "*Use Scroll Wheel to change*"));
                    }
                    return strings;
                }
                ++pos;
            }
        }
        return null;
    }
}

