/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.entity.InfinityLauncherProjectileEntity;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemInfinityLauncher
extends ItemInfinity {
    public static int POWER_CONSUMPTION = 100000;
    public static int FUEL_CONSUMPTION = 30;
    public static String PLUNGER_NBT = "Plunger";

    public ItemInfinityLauncher(ItemGroup group) {
        super("infinity_launcher", group, new Item.Properties().func_200917_a(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, false);
        this.disableArea();
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        super.addNbt(stack, power, fuel, special);
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a(PLUNGER_NBT, PlungerAction.RELEASE.getId());
        stack.func_77982_d(nbt);
    }

    @Override
    public void addTooltipDetails(BasicItem.Key key, ItemStack stack, List<ITextComponent> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        PlungerAction action = this.getPlungerAction(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent("text.industrialforegoing.action").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new TranslationTextComponent("text.industrialforegoing.launcher." + action.name().toLowerCase(Locale.ROOT)).func_240699_a_(action.getColor())));
    }

    public PlungerAction getPlungerAction(ItemStack stack) {
        return PlungerAction.getFromId(stack.func_196082_o().func_74762_e(PLUNGER_NBT));
    }

    public void setPlungerAction(ItemStack stack, PlungerAction plungerAction) {
        stack.func_196082_o().func_74768_a(PLUNGER_NBT, plungerAction.getId());
    }

    @Override
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 36000;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185307_s;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!playerIn.func_225608_bj_()) {
            playerIn.func_184598_c(handIn);
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        int time;
        float velo;
        if (entityLiving instanceof PlayerEntity && !((double)(velo = ItemInfinityLauncher.getArrowVelocity(time = this.func_77626_a(stack) - timeLeft)) < 0.1) && this.enoughFuel(stack)) {
            PlayerEntity playerentity = (PlayerEntity)entityLiving;
            playerentity.func_184811_cZ().func_185145_a((Item)this, 20);
            if (!worldIn.field_72995_K) {
                int k;
                int j;
                InfinityLauncherProjectileEntity abstractarrowentity = new InfinityLauncherProjectileEntity(worldIn, (LivingEntity)playerentity, this.getPlungerAction(stack), ItemInfinityLauncher.getSelectedTier(stack).getRadius());
                abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, velo * 3.0f, 1.0f);
                if (velo == 1.0f) {
                    abstractarrowentity.func_70243_d(true);
                }
                if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                    abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() + (double)j * 0.5 + 0.5);
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                    abstractarrowentity.func_70240_a(k);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                    abstractarrowentity.func_70015_d(100);
                }
                this.consumeFuel(stack);
                abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
                worldIn.func_217376_c((Entity)abstractarrowentity);
            }
            worldIn.func_184148_a((PlayerEntity)null, playerentity.func_226277_ct_(), playerentity.func_226278_cu_(), playerentity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + velo * 0.5f);
            playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        List<IFactory<? extends IScreenAddon>> factory = super.getScreenAddons(stack);
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 52, 14, 14, FacingUtil.Sideness.RIGHT).setId(4))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 52, 14, 14, FacingUtil.Sideness.LEFT).setId(5))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon("", 72, 56, false){

            public String getText() {
                PlungerAction action = ItemInfinityLauncher.this.getPlungerAction((ItemStack)stack.get());
                return TextFormatting.DARK_GRAY + new TranslationTextComponent("text.industrialforegoing.action").func_240699_a_(TextFormatting.GRAY).getString() + action.getColor() + new TranslationTextComponent("text.industrialforegoing.launcher." + action.name().toLowerCase(Locale.ROOT)).func_240699_a_(action.getColor()).getString();
            }
        }));
        return factory;
    }

    @Override
    public void handleButtonMessage(int id, PlayerEntity playerEntity, CompoundNBT compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        ItemStack stack = playerEntity.func_184586_b(Hand.MAIN_HAND);
        PlungerAction plungerAction = this.getPlungerAction(stack);
        if (id == 4) {
            this.setPlungerAction(stack, PlungerAction.getFromId(plungerAction.getId() + 1));
        }
        if (id == 5) {
            this.setPlungerAction(stack, PlungerAction.getFromId(plungerAction.getId() - 1));
        }
    }

    @Override
    public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
        new DissolutionChamberRecipe(this.getRegistryName(), new Ingredient.IItemList[]{new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_221732_cb)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_151031_f)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_221732_cb)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)ModuleTool.MOB_IMPRISONMENT_TOOL)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)ModuleCore.RANGE_ADDONS[11])), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD)}, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid(), 2000), 400, new ItemStack((IItemProvider)this), FluidStack.EMPTY);
    }

    public static enum PlungerAction {
        RELEASE(0, TextFormatting.GREEN),
        CAPTURE(1, TextFormatting.GOLD),
        DAMAGE(2, TextFormatting.RED);

        private final int id;
        private final TextFormatting color;

        private PlungerAction(int id, TextFormatting color) {
            this.id = id;
            this.color = color;
        }

        public static PlungerAction getFromId(int id) {
            if (id < 0) {
                return DAMAGE;
            }
            for (PlungerAction value : PlungerAction.values()) {
                if (value.id != id) continue;
                return value;
            }
            return RELEASE;
        }

        public int getId() {
            return this.id;
        }

        public TextFormatting getColor() {
            return this.color;
        }
    }
}

