/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.entity.InfinityTridentEntity;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemInfinityTrident
extends ItemInfinity {
    private static String LOYALTY_NBT = "Loyalty";
    private static String RIPTIDE_NBT = "Riptide";
    private static String CHANNELING_NBT = "Channeling";
    private static int LOYALTY_MAX = 5;
    private static int RIPTIDE_MAX = 5;
    public static int POWER_CONSUMPTION = 100000;
    public static int FUEL_CONSUMPTION = 30;

    public ItemInfinityTrident(ItemGroup group) {
        super("infinity_trident", group, new Item.Properties().func_200917_a(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, true);
    }

    @Override
    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        super.addNbt(stack, power, fuel, special);
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a(LOYALTY_NBT, 0);
        nbt.func_74768_a(RIPTIDE_NBT, 0);
        nbt.func_74757_a(CHANNELING_NBT, false);
        stack.func_77982_d(nbt);
    }

    @Override
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.SPEAR;
    }

    public int func_77626_a(ItemStack stack) {
        return 36000;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (EnchantmentHelper.func_203190_g((ItemStack)itemstack) > 0 && !playerIn.func_70026_G()) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        if (!playerIn.func_225608_bj_()) {
            playerIn.func_184598_c(handIn);
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.equals(Enchantments.field_203193_C) || enchantment.equals(Enchantments.field_203195_E) || enchantment.equals(Enchantments.field_203196_F)) {
            return false;
        }
        return Items.field_203184_eO.canApplyAtEnchantingTable(new ItemStack((IItemProvider)Items.field_203184_eO), enchantment);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)entityLiving;
            int i = this.func_77626_a(stack) - timeLeft;
            if (i >= 10) {
                int riptideModifier = this.getCurrentRiptide(stack);
                if (riptideModifier <= 0 && this.enoughFuel(stack) && !worldIn.field_72995_K) {
                    stack.func_222118_a(1, (LivingEntity)playerentity, player -> player.func_213334_d(entityLiving.func_184600_cs()));
                    if (riptideModifier == 0) {
                        this.consumeFuel(stack);
                        InfinityTridentEntity tridententity = new InfinityTridentEntity(worldIn, (LivingEntity)playerentity, stack);
                        tridententity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, 2.5f + (float)riptideModifier * 0.5f, 1.0f);
                        if (playerentity.field_71075_bZ.field_75098_d) {
                            tridententity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_217376_c((Entity)tridententity);
                        worldIn.func_217384_a((PlayerEntity)null, (Entity)tridententity, SoundEvents.field_203274_ip, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        if (!playerentity.field_71075_bZ.field_75098_d) {
                            playerentity.field_71071_by.func_184437_d(stack);
                        }
                    }
                }
                playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                if (riptideModifier > 0 && this.enoughFuel(stack)) {
                    float f7 = playerentity.field_70177_z;
                    float f = playerentity.field_70125_A;
                    float f1 = -MathHelper.func_76126_a((float)(f7 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
                    float f2 = -MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
                    float f3 = MathHelper.func_76134_b((float)(f7 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
                    float f4 = MathHelper.func_76129_c((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)riptideModifier * 2.0f) / 4.0f);
                    playerentity.func_70024_g((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    playerentity.func_204803_n(20);
                    if (playerentity.func_233570_aj_()) {
                        playerentity.func_213315_a(MoverType.SELF, new Vector3d(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = riptideModifier >= 3 ? SoundEvents.field_203273_io : (riptideModifier == 2 ? SoundEvents.field_203272_in : SoundEvents.field_203271_im);
                    worldIn.func_217384_a((PlayerEntity)null, (Entity)playerentity, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    this.consumeFuel(stack);
                }
            }
        }
    }

    public int getCurrentLoyalty(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(LOYALTY_NBT);
    }

    public int getMaxLoyalty(ItemStack stack) {
        InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityTrident.getPowerFromStack(stack)).getLeft());
        return Math.min(Math.max(0, infinityTier.getRadius() - 1), LOYALTY_MAX);
    }

    public void setLoyalty(ItemStack stack, int level) {
        stack.func_196082_o().func_74768_a(LOYALTY_NBT, level);
    }

    public int getCurrentRiptide(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(RIPTIDE_NBT);
    }

    public int getMaxRiptide(ItemStack stack) {
        InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityTrident.getPowerFromStack(stack)).getLeft());
        return Math.min(Math.max(0, infinityTier.getRadius() - 1), RIPTIDE_MAX);
    }

    public void setRiptide(ItemStack stack, int level) {
        stack.func_196082_o().func_74768_a(RIPTIDE_NBT, level);
    }

    public boolean getCurrentChanneling(ItemStack stack) {
        return stack.func_196082_o().func_74767_n(CHANNELING_NBT);
    }

    public boolean canChanneling(ItemStack stack) {
        return ((InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityTrident.getPowerFromStack(stack)).getLeft())).getRadius() >= 4;
    }

    public void setChanneling(ItemStack stack, boolean enabled) {
        stack.func_196082_o().func_74757_a(CHANNELING_NBT, enabled);
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        List<IFactory<? extends IScreenAddon>> factory = super.getScreenAddons(stack);
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 52, 14, 14, FacingUtil.Sideness.RIGHT).setId(4))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 52, 14, 14, FacingUtil.Sideness.LEFT).setId(5))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon("", 72, 56, false){

            public String getText() {
                return TextFormatting.DARK_GRAY + new TranslationTextComponent("enchantment.minecraft.loyalty").func_240702_b_(": ").func_240702_b_(ItemInfinityTrident.this.getCurrentLoyalty((ItemStack)stack.get()) + "/" + ItemInfinityTrident.this.getMaxLoyalty((ItemStack)stack.get())).getString();
            }
        }));
        int y = 16;
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 52 + y, 14, 14, FacingUtil.Sideness.RIGHT).setId(6))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 52 + y, 14, 14, FacingUtil.Sideness.LEFT).setId(7))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon("", 72, 56 + y, false){

            public String getText() {
                return TextFormatting.DARK_GRAY + new TranslationTextComponent("enchantment.minecraft.riptide").func_240702_b_(": ").func_240702_b_(ItemInfinityTrident.this.getCurrentRiptide((ItemStack)stack.get()) + "/" + ItemInfinityTrident.this.getMaxRiptide((ItemStack)stack.get())).getString();
            }
        }));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new StateButtonAddon(new ButtonComponent(54, 52 + y * 2, 14, 14).setId(8), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[0]), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[0])}){

            public int getState() {
                return ItemInfinityTrident.this.getCurrentChanneling((ItemStack)stack.get()) ? 0 : 1;
            }
        }));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon(TextFormatting.DARK_GRAY + new TranslationTextComponent("enchantment.minecraft.channeling").getString(), 72, 56 + y * 2, false)));
        return factory;
    }

    @Override
    public void handleButtonMessage(int id, PlayerEntity playerEntity, CompoundNBT compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        ItemStack stack = playerEntity.func_184586_b(Hand.MAIN_HAND);
        int current = this.getCurrentLoyalty(stack);
        int max = this.getMaxLoyalty(stack);
        if (id == 5 && current > 0) {
            this.setLoyalty(stack, Math.max(current - 1, 0));
        }
        if (id == 4 && current < max) {
            this.setRiptide(stack, 0);
            this.setLoyalty(stack, Math.min(max, current + 1));
        }
        current = this.getCurrentRiptide(stack);
        max = this.getMaxRiptide(stack);
        if (id == 7 && current > 0) {
            this.setRiptide(stack, Math.max(current - 1, 0));
        }
        if (id == 6 && current < max) {
            this.setLoyalty(stack, 0);
            this.setRiptide(stack, Math.min(max, current + 1));
        }
        if (id == 8 && this.canChanneling(stack)) {
            this.setChanneling(stack, !this.getCurrentChanneling(stack));
        }
    }

    @Override
    public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
        new DissolutionChamberRecipe(this.getRegistryName(), new Ingredient.IItemList[]{new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_221732_cb)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_203184_eO)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_221732_cb)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_151012_L)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)ModuleCore.RANGE_ADDONS[11])), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD)}, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid(), 2000), 400, new ItemStack((IItemProvider)this), FluidStack.EMPTY);
    }

    @Override
    public void addTooltipDetails(BasicItem.Key key, ItemStack stack, List<ITextComponent> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        this.addTooltip(tooltip, "enchantment.minecraft.loyalty", this.getCurrentLoyalty(stack));
        this.addTooltip(tooltip, "enchantment.minecraft.riptide", this.getCurrentRiptide(stack));
        this.addTooltip(tooltip, "enchantment.minecraft.channeling", this.getCurrentChanneling(stack) ? 1 : 0);
    }

    private void addTooltip(List<ITextComponent> tooltip, String type, int value) {
        if (value > 0) {
            String level = "0";
            switch (value) {
                case 1: {
                    level = "I";
                    break;
                }
                case 2: {
                    level = "II";
                    break;
                }
                case 3: {
                    level = "III";
                    break;
                }
                case 4: {
                    level = "IV";
                    break;
                }
                case 5: {
                    level = "V";
                }
            }
            tooltip.add((ITextComponent)new TranslationTextComponent(type).func_240702_b_(" " + level).func_240699_a_(TextFormatting.GRAY));
        }
    }
}

