/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.category;

import com.buuz135.industrial.recipe.LaserDrillFluidRecipe;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class LaserDrillFluidCategory
implements IRecipeCategory<LaserDrillFluidRecipe> {
    public static final ResourceLocation ID = new ResourceLocation(LaserDrillFluidRecipe.SERIALIZER.getRecipeType().toString());
    private IGuiHelper guiHelper;

    public LaserDrillFluidCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends LaserDrillFluidRecipe> getRecipeClass() {
        return LaserDrillFluidRecipe.class;
    }

    public String getTitle() {
        return "Laser Drill Fluids";
    }

    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 0, 0, 52, 26).addPadding(0, 60, 35, 65).build();
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(LaserDrillFluidRecipe laserDrillOreRecipe, IIngredients iIngredients) {
        iIngredients.setInputs(VanillaTypes.ITEM, Arrays.asList(laserDrillOreRecipe.catalyst.func_193365_a()));
        iIngredients.setOutput(VanillaTypes.FLUID, (Object)FluidStack.loadFluidStackFromNBT((CompoundNBT)laserDrillOreRecipe.output));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, LaserDrillFluidRecipe laserDrillOreRecipe, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStackGroup = iRecipeLayout.getItemStacks();
        guiItemStackGroup.init(0, true, 35, 4);
        guiItemStackGroup.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
        IGuiFluidStackGroup guiFluidStackGroup = iRecipeLayout.getFluidStacks();
        guiFluidStackGroup.init(1, false, 101, 6, 12, 13, 100, false, new IDrawable(){

            public int getWidth() {
                return 15;
            }

            public int getHeight() {
                return 16;
            }

            public void draw(MatrixStack matrixStack, int i, int i1) {
                AssetUtil.drawAsset((MatrixStack)matrixStack, (Screen)Minecraft.func_71410_x().field_71462_r, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_SMALL), (int)(i - 3), (int)(i1 - 3));
            }
        });
        guiFluidStackGroup.set(1, (List)iIngredients.getOutputs(VanillaTypes.FLUID).get(0));
    }

    public void draw(LaserDrillFluidRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        int recipeWidth = 152;
        if (recipe.pointer > 0) {
            AssetUtil.drawAsset((MatrixStack)matrixStack, (Screen)Minecraft.func_71410_x().field_71462_r, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.BUTTON_ARROW_LEFT), (int)0, (int)70);
        }
        if (recipe.pointer < recipe.rarity.length - 1) {
            AssetUtil.drawAsset((MatrixStack)matrixStack, (Screen)Minecraft.func_71410_x().field_71462_r, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.BUTTON_ARROW_RIGHT), (int)137, (int)70);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("textures/gui/toasts.png"));
        Screen cfr_ignored_0 = Minecraft.func_71410_x().field_71462_r;
        int n = recipeWidth / 10 * 2;
        Minecraft.func_71410_x().field_71466_p.getClass();
        Screen.func_238463_a_((MatrixStack)matrixStack, (int)n, (int)(30 + (9 + 2) * 3), (float)216.0f, (float)0.0f, (int)20, (int)20, (int)256, (int)256);
        Screen cfr_ignored_1 = Minecraft.func_71410_x().field_71462_r;
        int n2 = recipeWidth / 10 * 7;
        Minecraft.func_71410_x().field_71466_p.getClass();
        Screen.func_238463_a_((MatrixStack)matrixStack, (int)n2, (int)(30 + (9 + 2) * 3), (float)216.0f, (float)0.0f, (int)20, (int)20, (int)256, (int)256);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("forge", "textures/gui/icons.png"));
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        int n3 = recipeWidth / 10 * 7 + 1;
        Minecraft.func_71410_x().field_71466_p.getClass();
        screen.func_238474_b_(matrixStack, n3, 30 + (9 + 2) * 3 + 3, 0, 16, 16, 16);
        String minY = new TranslationTextComponent("text.industrialforegoing.miny").getString() + " " + recipe.rarity[recipe.pointer].depth_min;
        String maxY = new TranslationTextComponent("text.industrialforegoing.maxy").getString() + " " + recipe.rarity[recipe.pointer].depth_max;
        String biomes = new TranslationTextComponent("text.industrialforegoing.biomes").getString();
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, TextFormatting.DARK_GRAY + minY, (float)(recipeWidth / 10), 30.0f, 0);
        if (!LaserDrillFluidRecipe.EMPTY.equals((Object)recipe.entity)) {
            String wight = "Over: " + new TranslationTextComponent("entity." + recipe.entity.toString().replace(":", ".")).getString();
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            String string = TextFormatting.DARK_GRAY + wight;
            float f = recipeWidth / 10;
            Minecraft.func_71410_x().field_71466_p.getClass();
            fontRenderer.func_238421_b_(matrixStack, string, f, (float)(30 + (9 + 2)), 0);
        }
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, TextFormatting.DARK_GRAY + maxY, (float)(recipeWidth / 10 * 6), 30.0f, 0);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String string = TextFormatting.DARK_GRAY + "" + TextFormatting.UNDERLINE + biomes;
        float f = recipeWidth / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(biomes) / 2;
        Minecraft.func_71410_x().field_71466_p.getClass();
        fontRenderer.func_238421_b_(matrixStack, string, f, (float)(30 + (9 + 2) * 2), 0);
    }

    public List<ITextComponent> getTooltipStrings(LaserDrillFluidRecipe recipe, double mouseX, double mouseY) {
        if (mouseX > 0.0 && mouseX < 15.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer > 0) {
            return Collections.singletonList(new TranslationTextComponent("text.industrialforegoing.button.jei.prev_rarity"));
        }
        if (mouseX > 137.0 && mouseX < 152.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer < recipe.rarity.length - 1) {
            return Collections.singletonList(new TranslationTextComponent("text.industrialforegoing.button.jei.next_rarity"));
        }
        if (mouseX > 26.0 && mouseX < 46.0) {
            Minecraft.func_71410_x().field_71466_p.getClass();
            if (mouseY > (double)(30 + (9 + 2) * 3)) {
                Minecraft.func_71410_x().field_71466_p.getClass();
                if (mouseY < (double)(30 + (9 + 2) * 3 + 20)) {
                    ArrayList<ITextComponent> biomes = new ArrayList<ITextComponent>();
                    biomes.add((ITextComponent)new TranslationTextComponent("text.industrialforegoing.tooltip.whitelisted_biomes").func_240699_a_(TextFormatting.UNDERLINE).func_240699_a_(TextFormatting.GOLD));
                    if (recipe.rarity[recipe.pointer].whitelist.length == 0) {
                        biomes.add((ITextComponent)new StringTextComponent("- Any"));
                    } else {
                        for (RegistryKey registryKey : recipe.rarity[recipe.pointer].whitelist) {
                            biomes.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent("biome." + registryKey.func_240901_a_().func_110624_b() + "." + registryKey.func_240901_a_().func_110623_a())));
                        }
                    }
                    return biomes;
                }
            }
        }
        if (mouseX > 104.0 && mouseX < 124.0) {
            Minecraft.func_71410_x().field_71466_p.getClass();
            if (mouseY > (double)(30 + (9 + 2) * 3)) {
                Minecraft.func_71410_x().field_71466_p.getClass();
                if (mouseY < (double)(30 + (9 + 2) * 3 + 20)) {
                    ArrayList<ITextComponent> biomes = new ArrayList<ITextComponent>();
                    biomes.add((ITextComponent)new TranslationTextComponent("text.industrialforegoing.tooltip.blacklisted_biomes").func_240699_a_(TextFormatting.UNDERLINE).func_240699_a_(TextFormatting.GOLD));
                    if (recipe.rarity[recipe.pointer].blacklist.length == 0) {
                        biomes.add((ITextComponent)new StringTextComponent("- None"));
                    } else {
                        for (RegistryKey registryKey : recipe.rarity[recipe.pointer].blacklist) {
                            biomes.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent("biome." + registryKey.func_240901_a_().func_110624_b() + "." + registryKey.func_240901_a_().func_110623_a())));
                        }
                    }
                    return biomes;
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean handleClick(LaserDrillFluidRecipe recipe, double mouseX, double mouseY, int mouseButton) {
        if (mouseX > 0.0 && mouseX < 15.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer > 0) {
            --recipe.pointer;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        if (mouseX > 137.0 && mouseX < 152.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer < recipe.rarity.length - 1) {
            ++recipe.pointer;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        return false;
    }
}

