/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.utils.BlockUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DoubleTallPlantRecollectable
extends PlantRecollectable {
    public DoubleTallPlantRecollectable() {
        super("blocksugarandcactus");
    }

    @Override
    public boolean canBeHarvested(World world, BlockPos pos, BlockState blockState) {
        return blockState.func_177230_c() instanceof CactusBlock && world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof CactusBlock || blockState.func_177230_c() instanceof SugarCaneBlock && world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof SugarCaneBlock;
    }

    @Override
    public List<ItemStack> doHarvestOperation(World world, BlockPos pos, BlockState blockState) {
        NonNullList stacks = NonNullList.func_191196_a();
        this.harvestBlock((NonNullList<ItemStack>)stacks, world, pos.func_177967_a(Direction.UP, 2));
        this.harvestBlock((NonNullList<ItemStack>)stacks, world, pos.func_177967_a(Direction.UP, 1));
        return stacks;
    }

    @Override
    public boolean shouldCheckNextPlant(World world, BlockPos pos, BlockState blockState) {
        return true;
    }

    private void harvestBlock(NonNullList<ItemStack> stacks, World world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() instanceof CactusBlock || blockState.func_177230_c() instanceof SugarCaneBlock) {
            stacks.addAll(BlockUtils.getBlockDrops(world, pos));
            if (!world.func_204610_c(pos).func_206888_e()) {
                world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            } else {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    @Override
    public List<String> getRecollectablesNames() {
        return Arrays.asList("text.industrialforegoing.plant.sugar_cane", "text.industrialforegoing.plant.cactus");
    }
}

