/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.worlddata;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.INBTSerializable;

public class MycelialDataManager
extends WorldSavedData {
    public static final String NAME = "IFMycelial";
    public HashMap<String, HashMap<String, List<GeneratorInfo>>> infos = new HashMap();

    public MycelialDataManager() {
        super(NAME);
    }

    public static void setGeneratorInfo(String uuid, World world, BlockPos pos, IMycelialGeneratorType type) {
        if (world instanceof ServerWorld) {
            MycelialDataManager dataManager = MycelialDataManager.getData((IWorld)world);
            List generatorInfos = dataManager.getInfos().computeIfAbsent(uuid, s -> new HashMap()).computeIfAbsent(type.getName(), s -> new ArrayList());
            boolean updated = false;
            for (GeneratorInfo generatorInfo : generatorInfos) {
                if (!generatorInfo.pos.equals((Object)pos) || !generatorInfo.world.equals(world.func_234923_W_())) continue;
                updated = true;
                generatorInfo.lastRun = world.func_82737_E();
            }
            if (!updated) {
                generatorInfos.add(new GeneratorInfo(world.func_82737_E(), 0L, pos, (RegistryKey<World>)world.func_234923_W_()));
            }
            dataManager.func_76185_a();
        }
    }

    public static void removeGeneratorInfo(String uuid, World world, BlockPos pos, IMycelialGeneratorType type) {
        MycelialDataManager dataManager = MycelialDataManager.getData((IWorld)world);
        List generatorInfos = dataManager.getInfos().computeIfAbsent(uuid, s -> new HashMap()).computeIfAbsent(type.getName(), s -> new ArrayList());
        generatorInfos.removeIf(generatorInfo -> ((GeneratorInfo)generatorInfo).world.equals(world.func_234923_W_()) && ((GeneratorInfo)generatorInfo).pos.equals((Object)pos));
        dataManager.func_76185_a();
    }

    public static List<String> getReactorAvailable(String uuid, World world, boolean execute) {
        ArrayList<String> names = new ArrayList<String>();
        if (world instanceof ServerWorld) {
            MycelialDataManager dataManager = MycelialDataManager.getData((IWorld)world);
            HashMap generators = dataManager.getInfos().computeIfAbsent(uuid, s -> new HashMap());
            block0: for (IMycelialGeneratorType type : IMycelialGeneratorType.TYPES) {
                for (GeneratorInfo generatorInfo : generators.computeIfAbsent(type.getName(), s -> new ArrayList())) {
                    if (generatorInfo.lastTracked + 5L > world.func_82737_E() || generatorInfo.lastRun + 5L < world.func_82737_E()) continue;
                    names.add(type.getName());
                    if (execute) {
                        generatorInfo.lastTracked = world.func_82737_E();
                    }
                    dataManager.func_76185_a();
                    continue block0;
                }
            }
        }
        return names;
    }

    public HashMap<String, HashMap<String, List<GeneratorInfo>>> getInfos() {
        return this.infos;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.infos = new HashMap();
        for (String uuid : nbt.func_74775_l("values").func_150296_c()) {
            CompoundNBT uuidNbt = nbt.func_74775_l("values").func_74775_l(uuid);
            HashMap<String, List> generators = new HashMap<String, List>();
            for (String genName : uuidNbt.func_150296_c()) {
                CompoundNBT genNbt = uuidNbt.func_74775_l(genName);
                for (String s : genNbt.func_150296_c()) {
                    GeneratorInfo generatorInfo = new GeneratorInfo();
                    generatorInfo.deserializeNBT(genNbt.func_74775_l(s));
                    generators.computeIfAbsent(genName, s1 -> new ArrayList()).add(generatorInfo);
                }
            }
            this.infos.put(uuid, generators);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        CompoundNBT values = new CompoundNBT();
        for (String uuid : this.infos.keySet()) {
            CompoundNBT uuidNbt = new CompoundNBT();
            for (String genName : this.infos.get(uuid).keySet()) {
                int i = 0;
                CompoundNBT genNbt = new CompoundNBT();
                for (GeneratorInfo generatorInfo : this.infos.get(uuid).get(genName)) {
                    genNbt.func_218657_a(i + "", (INBT)generatorInfo.serializeNBT());
                    ++i;
                }
                uuidNbt.func_218657_a(genName, (INBT)genNbt);
            }
            values.func_218657_a(uuid, (INBT)uuidNbt);
        }
        compound.func_218657_a("values", (INBT)values);
        return compound;
    }

    @Nullable
    public static MycelialDataManager getData(IWorld world) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = ((ServerWorld)world).func_73046_m().func_71218_a(World.field_234918_g_);
            MycelialDataManager data = (MycelialDataManager)serverWorld.func_217481_x().func_215752_a(MycelialDataManager::new, NAME);
            return data;
        }
        return null;
    }

    public static class GeneratorInfo
    implements INBTSerializable<CompoundNBT> {
        private long lastRun;
        private long lastTracked;
        private BlockPos pos;
        private RegistryKey<World> world;

        public GeneratorInfo(long lastRun, long lastTracked, BlockPos pos, RegistryKey<World> world) {
            this.lastRun = lastRun;
            this.lastTracked = lastTracked;
            this.pos = pos;
            this.world = world;
        }

        public GeneratorInfo() {
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74772_a("Run", this.lastRun);
            compoundNBT.func_74772_a("Track", this.lastTracked);
            compoundNBT.func_74772_a("Pos", this.pos.func_218275_a());
            compoundNBT.func_74778_a("RKValue", this.world.func_240901_a_().toString());
            return compoundNBT;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.lastRun = nbt.func_74763_f("Run");
            this.lastTracked = nbt.func_74763_f("Track");
            this.pos = BlockPos.func_218283_e((long)nbt.func_74763_f("Pos"));
            this.world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("RKValue")));
        }
    }
}

