/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.block.BlockDyeableKitchen;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tile.CounterTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class KitchenCounterBlock
extends BlockDyeableKitchen {
    public static final String name = "counter";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "counter");

    public KitchenCounterBlock() {
        this(registryName);
    }

    public KitchenCounterBlock(ResourceLocation registryName) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(5.0f, 10.0f), registryName);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, FLIPPED, COLOR, HAS_COLOR});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CounterTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.tryRecolorBlock(state, heldItem, world, pos, player, rayTraceResult)) {
            return ActionResultType.SUCCESS;
        }
        CounterTileEntity tileCounter = (CounterTileEntity)world.func_175625_s(pos);
        if (rayTraceResult.func_216354_b() == state.func_177229_b((Property)FACING) && tileCounter != null) {
            if (player.func_225608_bj_()) {
                tileCounter.getDoorAnimator().toggleForcedOpen();
                return ActionResultType.SUCCESS;
            }
            if (!heldItem.func_190926_b() && tileCounter.getDoorAnimator().isForcedOpen()) {
                heldItem = ItemHandlerHelper.insertItemStacked((IItemHandler)tileCounter.getItemHandler(), (ItemStack)heldItem, (boolean)false);
                player.func_184611_a(hand, heldItem);
                return ActionResultType.SUCCESS;
            }
        }
        if (!world.field_72995_K) {
            if (rayTraceResult.func_216354_b() == Direction.UP && !heldItem.func_190926_b() && (heldItem.func_77973_b() instanceof BlockItem || heldItem.func_77973_b() == Compat.cuttingBoardItem)) {
                return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileCounter, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    @Nonnull
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        return (BlockState)state.func_206870_a((Property)FLIPPED, (Comparable)Boolean.valueOf(this.shouldBePlacedFlipped(context, (Direction)state.func_177229_b((Property)FACING))));
    }
}

