/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.api.ToasterHandler;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ToasterTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ToasterBlock
extends BlockKitchen {
    public static final String name = "toaster";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "toaster");
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.4, (double)0.0, (double)4.4, (double)11.6, (double)6.4, (double)11.6);
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

    public ToasterBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(2.5f), registryName);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ACTIVE});
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ToasterTileEntity) {
            ToasterTileEntity tileToaster = (ToasterTileEntity)tileEntity;
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.func_190926_b() || !tileToaster.getItemHandler().getStackInSlot(0).func_190926_b() && !tileToaster.getItemHandler().getStackInSlot(1).func_190926_b()) {
                if (!(tileToaster.isActive() || tileToaster.getItemHandler().getStackInSlot(0).func_190926_b() && tileToaster.getItemHandler().getStackInSlot(1).func_190926_b())) {
                    tileToaster.setActive(!tileToaster.isActive());
                }
            } else {
                ItemStack output;
                ToasterHandler toastHandler = CookingRegistry.getToasterHandler(heldItem);
                if (toastHandler != null && !(output = toastHandler.getToasterOutput(heldItem)).func_190926_b()) {
                    for (int i = 0; i < tileToaster.getItemHandler().getSlots(); ++i) {
                        if (!tileToaster.getItemHandler().getStackInSlot(i).func_190926_b()) continue;
                        tileToaster.getItemHandler().setStackInSlot(i, heldItem.func_77979_a(1));
                        return ActionResultType.SUCCESS;
                    }
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ToasterTileEntity();
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        ToasterTileEntity tileEntity = (ToasterTileEntity)world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.isActive() && random.nextFloat() < tileEntity.getToastProgress()) {
            double x = (float)pos.func_177958_n() + 0.5f + (random.nextFloat() - 0.5f) * 0.25f;
            double y = (float)pos.func_177956_o() + 0.2f + random.nextFloat() * 6.0f / 16.0f;
            double z = (float)pos.func_177952_p() + 0.5f + (random.nextFloat() - 0.5f) * 0.25f;
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

