/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container;

import java.util.Objects;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.container.CounterContainer;
import net.blay09.mods.cookingforblockheads.container.FridgeContainer;
import net.blay09.mods.cookingforblockheads.container.FruitBasketContainer;
import net.blay09.mods.cookingforblockheads.container.OvenContainer;
import net.blay09.mods.cookingforblockheads.container.RecipeBookContainer;
import net.blay09.mods.cookingforblockheads.container.SpiceRackContainer;
import net.blay09.mods.cookingforblockheads.tile.CookingTableTileEntity;
import net.blay09.mods.cookingforblockheads.tile.CounterTileEntity;
import net.blay09.mods.cookingforblockheads.tile.FridgeTileEntity;
import net.blay09.mods.cookingforblockheads.tile.FruitBasketTileEntity;
import net.blay09.mods.cookingforblockheads.tile.OvenTileEntity;
import net.blay09.mods.cookingforblockheads.tile.SpiceRackTileEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistry;

public class ModContainers {
    public static ContainerType<CounterContainer> counter;
    public static ContainerType<FridgeContainer> fridge;
    public static ContainerType<FruitBasketContainer> fruitBasket;
    public static ContainerType<OvenContainer> oven;
    public static ContainerType<SpiceRackContainer> spiceRack;
    public static ContainerType<RecipeBookContainer> recipeBook;
    public static ContainerType<RecipeBookContainer> cookingTable;
    public static ContainerType<RecipeBookContainer> noFilterBook;
    public static ContainerType<RecipeBookContainer> craftingBook;

    public static void registerContainers(IForgeRegistry<ContainerType<?>> registry) {
        counter = ModContainers.register("counter", (windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
            return new CounterContainer(windowId, inv, (CounterTileEntity)Objects.requireNonNull(tileEntity));
        });
        registry.register(counter);
        fridge = ModContainers.register("fridge", (windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
            return new FridgeContainer(windowId, inv, (FridgeTileEntity)Objects.requireNonNull(tileEntity));
        });
        registry.register(fridge);
        fruitBasket = ModContainers.register("fruit_basket", (windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
            return new FruitBasketContainer(windowId, inv, (FruitBasketTileEntity)Objects.requireNonNull(tileEntity));
        });
        registry.register(fruitBasket);
        oven = ModContainers.register("oven", (windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
            return new OvenContainer(windowId, inv, (OvenTileEntity)Objects.requireNonNull(tileEntity));
        });
        registry.register(oven);
        spiceRack = ModContainers.register("spice_rack", (windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
            return new SpiceRackContainer(windowId, inv, (SpiceRackTileEntity)Objects.requireNonNull(tileEntity));
        });
        registry.register(spiceRack);
        cookingTable = ModContainers.register("cooking_table", (windowId, inv, data) -> {
            World world = inv.field_70458_d.field_70170_p;
            BlockPos pos = data.func_179259_c();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (((CookingTableTileEntity)Objects.requireNonNull(tileEntity)).hasNoFilterBook()) {
                return new RecipeBookContainer(cookingTable, windowId, inv.field_70458_d).setNoFilter().allowCrafting().setKitchenMultiBlock(KitchenMultiBlock.buildFromLocation(world, pos));
            }
            return new RecipeBookContainer(cookingTable, windowId, inv.field_70458_d).allowCrafting().setKitchenMultiBlock(KitchenMultiBlock.buildFromLocation(world, pos));
        });
        registry.register(cookingTable);
        noFilterBook = ModContainers.register("no_filter_book", (windowId, inv, data) -> new RecipeBookContainer(noFilterBook, windowId, inv.field_70458_d).setNoFilter());
        registry.register(noFilterBook);
        recipeBook = ModContainers.register("recipe_book", (windowId, inv, data) -> new RecipeBookContainer(recipeBook, windowId, inv.field_70458_d));
        registry.register(recipeBook);
        craftingBook = ModContainers.register("crafting_book", (windowId, inv, data) -> new RecipeBookContainer(craftingBook, windowId, inv.field_70458_d).allowCrafting());
        registry.register(craftingBook);
    }

    private static <T extends Container> ContainerType<T> register(String name, IContainerFactory<T> containerFactory) {
        return (ContainerType)new ContainerType(containerFactory).setRegistryName(name);
    }
}

