/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.item;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.network.NetworkHandler;
import net.blay09.mods.cookingforblockheads.network.message.MessageSyncedEffect;
import net.blay09.mods.cookingforblockheads.tile.FridgeTileEntity;
import net.blay09.mods.cookingforblockheads.util.TextUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemPreservationChamber
extends Item {
    public static final String name = "preservation_chamber";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "preservation_chamber");

    public ItemPreservationChamber() {
        super(new Item.Properties().func_200916_a(CookingForBlockheads.itemGroup));
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof FridgeTileEntity && !((FridgeTileEntity)tileEntity).getBaseFridge().hasPreservationUpgrade()) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184586_b(context.func_221531_n()).func_190918_g(1);
            }
            ((FridgeTileEntity)tileEntity).getBaseFridge().setHasPreservationUpgrade(true);
            if (!world.field_72995_K) {
                NetworkHandler.sendToAllTracking(new MessageSyncedEffect(pos, MessageSyncedEffect.Type.FRIDGE_UPGRADE), world, pos);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, tooltip, flag);
        tooltip.add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:fridge_upgrade", TextFormatting.YELLOW));
        for (String s : I18n.func_135052_a((String)"tooltip.cookingforblockheads:preservation_chamber.description", (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextUtils.coloredTextComponent(s, TextFormatting.GRAY));
        }
    }
}

