/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.item;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.container.ModContainers;
import net.blay09.mods.cookingforblockheads.container.RecipeBookContainer;
import net.blay09.mods.cookingforblockheads.util.TextUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemRecipeBook
extends Item {
    private final RecipeBookEdition edition;

    public ItemRecipeBook(RecipeBookEdition edition) {
        super(new Item.Properties().func_200916_a(CookingForBlockheads.itemGroup).func_200917_a(1));
        this.edition = edition;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent(Objects.requireNonNull(ItemRecipeBook.this.getRegistryName()).toString());
                }

                public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    RecipeBookContainer container = new RecipeBookContainer(ItemRecipeBook.this.edition.getContainerTypeSupplier().get(), i, playerEntity);
                    if (ItemRecipeBook.this.edition == RecipeBookEdition.NOFILTER) {
                        container.setNoFilter();
                    } else if (ItemRecipeBook.this.edition == RecipeBookEdition.CRAFTING) {
                        container.allowCrafting();
                    }
                    return container;
                }
            });
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, tooltip, flag);
        String registryName = Objects.requireNonNull(this.getRegistryName()).toString();
        tooltip.add(TextUtils.coloredTextComponent("tooltip." + registryName, TextFormatting.YELLOW));
        for (String s : I18n.func_135052_a((String)("tooltip." + registryName + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextUtils.coloredTextComponent(s, TextFormatting.GRAY));
        }
    }

    public static enum RecipeBookEdition {
        NOFILTER(() -> ModContainers.noFilterBook),
        RECIPE(() -> ModContainers.recipeBook),
        CRAFTING(() -> ModContainers.craftingBook);

        private final Supplier<ContainerType<RecipeBookContainer>> containerTypeSupplier;

        private RecipeBookEdition(Supplier<ContainerType<RecipeBookContainer>> containerTypeSupplier) {
            this.containerTypeSupplier = containerTypeSupplier;
        }

        public Supplier<ContainerType<RecipeBookContainer>> getContainerTypeSupplier() {
            return this.containerTypeSupplier;
        }
    }
}

