/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry.recipe;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.RecipeType;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public abstract class FoodRecipe {
    protected List<FoodIngredient> craftMatrix;
    protected ItemStack outputItem;
    protected int recipeWidth = 3;

    public List<FoodIngredient> getCraftMatrix() {
        return this.craftMatrix;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public RecipeType getType() {
        return RecipeType.CRAFTING;
    }

    public int getRecipeWidth() {
        return this.recipeWidth;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.outputItem.func_77973_b().getRegistryName();
    }

    public void fillCraftMatrix(IRecipe<?> recipe) {
        this.craftMatrix = Lists.newArrayList();
        for (Ingredient ingredient : recipe.func_192400_c()) {
            if (ingredient != Ingredient.field_193370_a) {
                boolean isToolItem = CookingRegistry.isToolItem(ingredient);
                this.craftMatrix.add(new FoodIngredient(ingredient, isToolItem));
                continue;
            }
            this.craftMatrix.add(null);
        }
    }
}

